/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webquery;

import is.hugvit.bird.WebContext;
import java.util.Arrays;
import java.util.List;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.lang.WordUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.json.JSONException;
import org.json.JSONObject;

public class GoProCompanySearchQuery
implements IWebFormQuery {
    public static final String LOOKUP_GOPRO = "CompanySearch.GoPro";
    private Organization goPro = null;

    public GoProCompanySearchQuery() throws SelfServiceException {
        this.setup();
    }

    @Override
    public void setContext(WebContext context) {
    }

    @Override
    public void doAction(Element el, String action, JSONObject data) throws FormQueryException {
        try {
            if (data.has("query")) {
                el.addElement("query").setText(data.getString("query"));
                FlexibleDataSetType results = this.search(data.getString("query"));
                if (results != null && results.getData() != null && results.getData().getRowsCount() > 0) {
                    for (FlexibleDataRowType row : results.getData().getRows()) {
                        el.addElement("suggestions").setText(row.getColumnValue(0));
                        Element company = DocumentHelper.createElement((String)"company");
                        Dom4JUtil.addElement(company, "id", row.getID());
                        String streetName = row.getColumnValue(1) + " " + row.getColumnValue(2);
                        Element address = company.addElement("address");
                        Dom4JUtil.addElement(address, "streetname", streetName.trim());
                        Dom4JUtil.addElement(address, "country", WordUtils.capitalize((String)row.getColumnValue(5)));
                        Dom4JUtil.addElement(address, "postcode", row.getColumnValue(3));
                        Dom4JUtil.addElement(address, "city", row.getColumnValue(4));
                        el.addElement("data").add(company);
                    }
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new FormQueryException(ex);
        }
        catch (JSONException ex) {
            throw new FormQueryException((Exception)((Object)ex));
        }
    }

    private FlexibleDataSetType search(String searchString) throws SelfServiceException {
        try {
            DocumentService service = this.getService(this.goPro);
            String searchKey = "*" + searchString + "*";
            DocumentFilterType filter = new DocumentFilterType();
            filter.setID("00000000-0000-0000-0000-000000000000");
            filter.setSubject("");
            filter.setDocumentFormType(1008);
            filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
            filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
            BinaryFilterExpressionType searchFilter = new BinaryFilterExpressionType();
            searchFilter.setPropertyName("_subject");
            searchFilter.setOperator(FilterOperatorType.LIKE);
            searchFilter.setValue((Object)searchKey);
            filter.setCustomFilter((FilterExpressionType)searchFilter);
            filter.setLoadBinaryData(false);
            filter.setLoadDefaultColumns(false);
            filter.setLoadColumns(Arrays.asList("_subject", "_addresses[AddressRefType]._objData[AddressType]._streetName", "_addresses[AddressRefType]._objData[AddressType]._streetNumber", "_addresses[AddressRefType]._objData[AddressType]._postCode", "_addresses[AddressRefType]._objData[AddressType]._city", "_addresses[AddressRefType]._objData[AddressType]._country[ListValueRefType]._objData[ListValueType]._name"));
            return service.getDocumentHeaders(filter);
        }
        catch (GdfServiceException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }

    private DocumentService getService(Organization org) throws SelfServiceException {
        String documentServiceUrl = org.getEndpoint().getHostname();
        String authUsername = org.getEndpoint().getUsername();
        String authPassword = org.getEndpoint().getPassword();
        if (documentServiceUrl == null) {
            throw new SelfServiceException("GoPro Service Url is missing for the organization!");
        }
        if (authUsername == null) {
            throw new SelfServiceException("GoPro username is missing for the organization!");
        }
        if (authPassword == null) {
            throw new SelfServiceException("GoPro password is missing for the organization!");
        }
        documentServiceUrl = documentServiceUrl + this.getBaseUrl(org.getEndpoint().getGoproType());
        return new DocumentService(documentServiceUrl, authUsername, authPassword, false);
    }

    private final String getBaseUrl(RemoteGoPro.GoPro type) {
        switch (type) {
            case GOPRO_NET: {
                return "WebServices/Gdf/BaseDocumentWebService.asmx";
            }
            case GOPRO_CASE: 
            case GOPRO_PORTAL: {
                return "services/DocumentService";
            }
        }
        return null;
    }

    private final void setup() throws SelfServiceException {
        String GoProName = SelfServiceEngine.getConfig(LOOKUP_GOPRO);
        List<Organization> list = ConfigService.getOrganizations();
        BaseDocumentUtil.removeDeletedDocuments(list);
        if (list.size() == 1) {
            this.goPro = list.get(0);
        } else if (StringUtil.isValid(GoProName)) {
            for (Organization org : list) {
                if (!org.getSubject().equalsIgnoreCase(GoProName) && !org.getAlias().equalsIgnoreCase(GoProName)) continue;
                this.goPro = org;
                break;
            }
        }
        if (this.goPro == null) {
            throw new SelfServiceException("No target GoPro found to perform the lookup!");
        }
        if (RemoteGoPro.GoPro.GOPRO_BROKER.equals((Object)this.goPro.getEndpoint().getGoproType()) || RemoteGoPro.GoPro.BROKER_PICKUP.equals((Object)this.goPro.getEndpoint().getGoproType())) {
            throw new SelfServiceException("Cannot perform company lookup on GoPro type: " + this.goPro.getEndpoint().getGoProTypeName());
        }
    }
}

