/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webelement;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.log.Log;
import is.hugvit.net.HttpUtil;
import is.hugvit.util.Util;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public abstract class BaseElement
extends WebForm {
    private static final Pattern RtlLocales = Pattern.compile("^(ar|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)");
    protected static Properties birdconfig;
    protected static Log log;
    protected ResourceBundle resourceBundle;
    protected Element dataroot;

    public synchronized void init(WebContext context) throws BirdException {
        super.init(context);
        if (birdconfig == null) {
            birdconfig = context.getSession().getParameters();
        }
        if (log == null) {
            log = context.getSession().getLog();
        }
        this.dataroot = context.getRootElement().addElement("ss");
        this.resourceBundle = LocaleUtil.getResourceBundle("portal.common", context.getRequest());
        this.setCommonResourceStrings(context);
        this.setServerInfo(context);
    }

    private void setServerInfo(WebContext context) {
        BirdSession session = context.getSession();
        HttpServletRequest req = context.getRequest();
        Element root = context.getRootElement();
        String baseurl = HttpUtil.getServletURL((HttpServletRequest)req);
        Element item = root.addElement("server");
        item.addElement("baseurl").addText(baseurl);
        item.addElement("portal").addText(baseurl + "/portal");
        String encoding = (String)session.getConfig().get("encoding");
        item.addElement("encoding").addText(encoding);
        item.addElement("dateformat").addText(Util.getShortDatePattern());
        String format = Util.getDatePattern((int)3, (Locale)context.getSession().getLocale());
        String dhtmlx = Util.convertToDhtmlxDateFormat((String)format);
        item.addElement("dateformatdhtmlx").addText(dhtmlx);
        item.addElement("secure").addText(String.valueOf(context.getRequest().isSecure()));
        item.addElement("timeout").setText(String.valueOf(context.getRequest().getSession().getMaxInactiveInterval()));
        Element elLocale = item.addElement("locale");
        List<String> localeList = LocaleUtil.getAvailableLocales();
        elLocale.addAttribute("visible", SelfServiceEngine.getConfig("web.locale.user.option"));
        Locale defaultLocale = LocaleUtil.getDefaultLocale();
        elLocale.addAttribute("default", defaultLocale.getLanguage());
        elLocale.addAttribute("defaultname", defaultLocale.getDisplayLanguage());
        String selectedLocale = this.getSelectedLocaleString(localeList);
        if (selectedLocale != null) {
            elLocale.addAttribute("selected", selectedLocale);
        }
        if (localeList.size() > 0) {
            Dom4JUtil.addElement(elLocale, "list", StringUtils.join(localeList, (String)","));
            for (String locale : localeList) {
                Element el = elLocale.addElement("locale");
                el.setText(locale);
                try {
                    String[] loc = locale.split("_");
                    Locale current = new Locale(loc[0], loc[1]);
                    el.addAttribute("name", StringUtils.capitalize((String)current.getDisplayLanguage(current)));
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean isRtlLanguage(String languageString) {
        return languageString != null && RtlLocales.matcher(languageString).find();
    }

    private String getSelectedLocaleString(List<String> localeList) {
        String iso = this.resourceBundle.getLocale().getLanguage();
        for (String locale : localeList) {
            if (!locale.startsWith(iso + "_")) continue;
            return locale;
        }
        return null;
    }

    private void setCommonResourceStrings(WebContext context) {
        if (this.resourceBundle != null) {
            Element elLocale = context.getRootElement().addElement("loc");
            elLocale.addAttribute("lang", this.resourceBundle.getLocale().getDisplayName());
            elLocale.addAttribute("iso", this.resourceBundle.getLocale().getLanguage());
            elLocale.addAttribute("ltr", this.isRtlLanguage(this.resourceBundle.getLocale().getLanguage()) ? "true" : "false");
            Enumeration<String> e = this.resourceBundle.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                elLocale.addElement(key).addText(this.resourceBundle.getString(key));
            }
        }
    }
}

