/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.validator.EmailValidator;

public final class StringUtil {
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-+]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";

    public static final String shortenText(String s, int length) {
        if (s.length() <= length) {
            return s;
        }
        return s.substring(0, length) + "..";
    }

    public static final boolean isValid(String s) {
        return s != null && !"".equals(s.trim());
    }

    public static final boolean isValidEmail(String email) {
        if (!StringUtil.isValid(email)) {
            return false;
        }
        try {
            return EmailValidator.getInstance().isValid(email);
        }
        catch (NoSuchMethodError ex) {
            return StringUtil.simpleEmailValidation(email);
        }
    }

    public static final String sanitizeFileName(String filename) {
        if (filename != null) {
            return filename.replaceAll("[:\\\\/*?|<>]", "_");
        }
        return "";
    }

    public static final String stripHTML(String s) {
        if (s != null) {
            return StringEscapeUtils.unescapeHtml((String)s).replaceAll("\\<.*?\\>", "");
        }
        return "";
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static final String zeroPad(int number) {
        if (number < 10) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    public static final String toUUID(String s) {
        String delim = "-";
        if (s != null && s.length() == 32) {
            String uuid = s.substring(0, 8) + "-" + s.substring(8, 12) + "-" + s.substring(12, 16) + "-" + s.substring(16, 20) + "-" + s.substring(20, 32);
            return uuid;
        }
        return s;
    }

    private static final boolean simpleEmailValidation(String email) {
        Pattern pattern = Pattern.compile(EMAIL_PATTERN);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }
}

