/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AuditLog;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.filters.AuditLogFilter;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.util.LocaleUtil;
import org.jCharts.axisChart.customRenderers.axisValue.PostAxisValueRenderListener;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelPosition;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelRenderer;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.PieChartDataSet;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.properties.BarChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.ClusteredBarChartProperties;
import org.jCharts.properties.PieChart2DProperties;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;
import org.jCharts.types.PieLabelType;

public class ReportDataUtil {
    private static final ResourceBundle rb = LocaleUtil.getResourceBundle("admin.reports");

    public static final IAxisDataSeries getUserDataSeries(ReportPeriod period) throws ChartDataException, SelfServiceException {
        String[] xAxisLabels = ReportDataUtil.getDatexAxisLabels(period);
        String xAxisTitle = null;
        String yAxisTitle = rb.getString("usergraph.yaxis");
        String title = rb.getString("usergraph.title");
        DataSeries dataSeries = new DataSeries(xAxisLabels, xAxisTitle, yAxisTitle, title);
        String[] legendLabels = new String[]{""};
        Paint[] paints = new Paint[]{new Color(14872055)};
        BarChartProperties barChartProperties = new BarChartProperties();
        ValueLabelRenderer valueLabelRenderer = new ValueLabelRenderer(false, false, false, 0);
        valueLabelRenderer.setValueLabelPosition(ValueLabelPosition.ON_TOP);
        valueLabelRenderer.useVerticalLabels(false);
        barChartProperties.setWidthPercentage(0.9f);
        barChartProperties.addPostRenderEventListener((PostAxisValueRenderListener)valueLabelRenderer);
        double[] userData = ReportDataUtil.getUserData(period);
        double[][] data = new double[][]{userData};
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)new AxisChartDataSet((double[][])data, legendLabels, paints, ChartType.BAR, (ChartTypeProperties)barChartProperties));
        return dataSeries;
    }

    public static IAxisDataSeries getRegistrationDataSeries(ReportPeriod period) throws ChartDataException, SelfServiceException {
        String[] xAxisLabels = ReportDataUtil.getDatexAxisLabels(period);
        String xAxisTitle = null;
        String yAxisTitle = rb.getString("registergraph.yaxis");
        String title = rb.getString("registergraph.title");
        DataSeries dataSeries = new DataSeries(xAxisLabels, xAxisTitle, yAxisTitle, title);
        String[] legendLabels = new String[]{""};
        Paint[] paints = new Paint[]{new Color(14872055)};
        BarChartProperties barChartProperties = new BarChartProperties();
        ValueLabelRenderer valueLabelRenderer = new ValueLabelRenderer(false, false, false, 0);
        valueLabelRenderer.setValueLabelPosition(ValueLabelPosition.ON_TOP);
        valueLabelRenderer.useVerticalLabels(false);
        barChartProperties.setWidthPercentage(0.9f);
        barChartProperties.addPostRenderEventListener((PostAxisValueRenderListener)valueLabelRenderer);
        double[] userData = ReportDataUtil.getRegistrationData(period);
        double[][] data = new double[][]{userData};
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)new AxisChartDataSet((double[][])data, legendLabels, paints, ChartType.BAR, (ChartTypeProperties)barChartProperties));
        return dataSeries;
    }

    public static final IAxisDataSeries getCaseDataSeries(ReportPeriod period) throws ChartDataException, SelfServiceException {
        String[] xAxisLabels = ReportDataUtil.getDatexAxisLabels(period);
        String xAxisTitle = null;
        String yAxisTitle = rb.getString("casegraph.yaxis");
        String title = rb.getString("casegraph.title");
        DataSeries dataSeries = new DataSeries(xAxisLabels, xAxisTitle, yAxisTitle, title);
        String[] legendLabels = new String[]{rb.getString("casegraph.created"), rb.getString("casegraph.saved"), rb.getString("casegraph.sent")};
        Paint[] paints = new Paint[]{new Color(255, 122, 31), new Color(175, 181, 39), new Color(120, 199, 77)};
        double[] caseDataCreated = ReportDataUtil.getCaseData(period, CaseDataType.CREATED);
        double[] caseDataModified = ReportDataUtil.getCaseData(period, CaseDataType.MODIFIED);
        double[] caseDataSent = ReportDataUtil.getCaseData(period, CaseDataType.SENT);
        double[][] data = new double[][]{caseDataCreated, caseDataModified, caseDataSent};
        ClusteredBarChartProperties clusteredBarChartProperties = new ClusteredBarChartProperties();
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet((double[][])data, legendLabels, paints, ChartType.BAR_CLUSTERED, (ChartTypeProperties)clusteredBarChartProperties);
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
        return dataSeries;
    }

    public static IAxisDataSeries getSubDocumentDataSeries(ReportPeriod period) throws ChartDataException, SelfServiceException {
        String[] xAxisLabels = ReportDataUtil.getDatexAxisLabels(period);
        String xAxisTitle = null;
        String yAxisTitle = rb.getString("documentgraph.yaxis");
        String title = rb.getString("documentgraph.title");
        DataSeries dataSeries = new DataSeries(xAxisLabels, xAxisTitle, yAxisTitle, title);
        String[] legendLabels = new String[]{rb.getString("documentgraph.memos"), rb.getString("documentgraph.files")};
        Paint[] paints = new Paint[]{new Color(63, 137, 181), new Color(165, 130, 235)};
        double[] caseDataCreated = ReportDataUtil.getDocumentData(period, AuditLogEntry.DataType.MEMO);
        double[] caseDataModified = ReportDataUtil.getDocumentData(period, AuditLogEntry.DataType.EXTERNAL_DOCUMENT);
        double[][] data = new double[][]{caseDataCreated, caseDataModified};
        ClusteredBarChartProperties clusteredBarChartProperties = new ClusteredBarChartProperties();
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet((double[][])data, legendLabels, paints, ChartType.BAR_CLUSTERED, (ChartTypeProperties)clusteredBarChartProperties);
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
        return dataSeries;
    }

    public static PieChartDataSet getCaseTypeSeries(ReportPeriod period) throws SelfServiceException, ChartDataException {
        int caseCount;
        String title = rb.getString("casetypegraph.title");
        List<FormTemplate> templateList = FormService.getFormTemplates();
        List<CaseTemplate> caseTemplateList = CaseService.getCaseTemplates();
        Hashtable<String, Integer> chartData = new Hashtable<String, Integer>();
        for (FormTemplate formTemplate : templateList) {
            caseCount = ReportDataUtil.getFormTypeDate(period, formTemplate.getId());
            if (caseCount <= 0) continue;
            chartData.put(formTemplate.getSubject(), caseCount);
        }
        for (CaseTemplate ct : caseTemplateList) {
            if (ct.isSystemTemplate() || (caseCount = ReportDataUtil.getCaseTypeDate(period, ct.getId())) <= 0) continue;
            chartData.put(ct.getSubject(), caseCount);
        }
        String[] labels = chartData.keySet().toArray(new String[chartData.size()]);
        double[] data = new double[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            data[i] = ((Integer)chartData.get(labels[i])).intValue();
        }
        Paint[] paints = TestDataGenerator.getRandomPaints((int)labels.length);
        PieChart2DProperties properties = new PieChart2DProperties();
        properties.setPieLabelType(PieLabelType.VALUE_LABELS);
        return new PieChartDataSet(title, data, labels, paints, properties);
    }

    private static int getFormTypeDate(ReportPeriod period, String formTemplateId) throws SelfServiceException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        AuditLog auditLog = null;
        AuditLogFilter filter = new AuditLogFilter();
        filter.addDataType(AuditLogEntry.DataType.CASE);
        filter.addAction(AuditLogEntry.Action.CREATE);
        filter.setFormTemplateId(formTemplateId);
        switch (period) {
            case DAY: {
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case WEEK: {
                cal = Calendar.getInstance();
                cal.add(5, -7);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case MONTH: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case YEAR: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                cal.set(2, 0);
                filter.setDateFilter(cal.getTime(), new Date());
            }
        }
        auditLog = LogService.getAuditLog(filter);
        return auditLog.getEntries().size();
    }

    private static int getCaseTypeDate(ReportPeriod period, String caseTemplateId) throws SelfServiceException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        AuditLog auditLog = null;
        AuditLogFilter filter = new AuditLogFilter();
        filter.addDataType(AuditLogEntry.DataType.CASE);
        filter.addAction(AuditLogEntry.Action.CREATE);
        filter.setCaseTemplateId(caseTemplateId);
        switch (period) {
            case DAY: {
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case WEEK: {
                cal = Calendar.getInstance();
                cal.add(5, -6);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case MONTH: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case YEAR: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                cal.set(2, 0);
                filter.setDateFilter(cal.getTime(), new Date());
            }
        }
        auditLog = LogService.getAuditLog(filter);
        return auditLog.getEntries().size();
    }

    private static double[] getDocumentData(ReportPeriod period, AuditLogEntry.DataType dataType) throws SelfServiceException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        AuditLog auditLog = null;
        AuditLogFilter filter = new AuditLogFilter();
        filter.addDataType(dataType);
        filter.addAction(AuditLogEntry.Action.CREATE);
        switch (period) {
            case DAY: {
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case WEEK: {
                cal = Calendar.getInstance();
                cal.add(5, -6);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case MONTH: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case YEAR: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                cal.set(2, 0);
                filter.setDateFilter(cal.getTime(), new Date());
            }
        }
        auditLog = LogService.getAuditLog(filter);
        return ReportDataUtil.getSortedData(period, auditLog);
    }

    private static double[] getCaseData(ReportPeriod period, CaseDataType caseDateType) throws SelfServiceException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        AuditLog auditLog = null;
        AuditLogFilter filter = new AuditLogFilter();
        filter.addDataType(AuditLogEntry.DataType.CASE);
        switch (caseDateType) {
            case CREATED: {
                filter.addAction(AuditLogEntry.Action.CREATE);
                break;
            }
            case MODIFIED: {
                filter.addAction(AuditLogEntry.Action.UPDATE);
                break;
            }
            case SENT: {
                filter.addAction(AuditLogEntry.Action.SEND);
            }
        }
        switch (period) {
            case DAY: {
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case WEEK: {
                cal = Calendar.getInstance();
                cal.add(5, -6);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case MONTH: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case YEAR: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                cal.set(2, 0);
                filter.setDateFilter(cal.getTime(), new Date());
            }
        }
        auditLog = LogService.getAuditLog(filter);
        return ReportDataUtil.getSortedData(period, auditLog);
    }

    private static double[] getRegistrationData(ReportPeriod period) throws SelfServiceException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        AuditLog auditLog = null;
        AuditLogFilter filter = new AuditLogFilter();
        filter.addAction(AuditLogEntry.Action.CREATE);
        filter.addDataType(AuditLogEntry.DataType.USER);
        switch (period) {
            case DAY: {
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case WEEK: {
                cal = Calendar.getInstance();
                cal.add(5, -6);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case MONTH: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case YEAR: {
                cal.set(5, 1);
                cal.set(2, 0);
                filter.setDateFilter(cal.getTime(), new Date());
            }
        }
        auditLog = LogService.getAuditLog(filter);
        return ReportDataUtil.getSortedData(period, auditLog);
    }

    private static double[] getUserData(ReportPeriod period) throws SelfServiceException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        AuditLog auditLog = null;
        AuditLogFilter filter = new AuditLogFilter();
        filter.addAction(AuditLogEntry.Action.LOGIN);
        switch (period) {
            case DAY: {
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case WEEK: {
                cal.add(5, -6);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case MONTH: {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                filter.setDateFilter(cal.getTime(), new Date());
                break;
            }
            case YEAR: {
                cal.set(5, 1);
                cal.set(2, 0);
                filter.setDateFilter(cal.getTime(), new Date());
            }
        }
        auditLog = LogService.getAuditLog(filter);
        return ReportDataUtil.getSortedData(period, auditLog);
    }

    private static final double[] getSortedData(ReportPeriod period, AuditLog log) {
        int i;
        Calendar start = Calendar.getInstance();
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        Calendar end = Calendar.getInstance();
        ArrayList<Integer> dataList = new ArrayList<Integer>();
        switch (period) {
            case DAY: {
                int counter;
                int i2;
                end.setTimeInMillis(start.getTimeInMillis());
                end.add(11, 1);
                for (i2 = 0; i2 < 24; ++i2) {
                    counter = ReportDataUtil.getRecordsCount(period, log.getEntries(), start, end);
                    dataList.add(counter);
                    start.add(11, 1);
                    end.add(11, 1);
                }
                break;
            }
            case WEEK: {
                int counter;
                int i2;
                start.add(5, -6);
                end.setTime(start.getTime());
                end.set(11, 23);
                end.set(12, 59);
                end.set(13, 59);
                for (i2 = 0; i2 < 7; ++i2) {
                    counter = ReportDataUtil.getRecordsCount(period, log.getEntries(), start, end);
                    dataList.add(counter);
                    start.add(5, 1);
                    end.setTime(start.getTime());
                    end.set(11, 23);
                    end.set(12, 59);
                    end.set(13, 59);
                }
                break;
            }
            case MONTH: {
                int counter;
                start.set(5, 1);
                end.setTime(start.getTime());
                end.set(11, 23);
                end.set(12, 59);
                end.set(13, 59);
                int lastDayOfMonth = start.getActualMaximum(5);
                for (i = 0; i < lastDayOfMonth; ++i) {
                    counter = ReportDataUtil.getRecordsCount(period, log.getEntries(), start, end);
                    dataList.add(counter);
                    start.add(5, 1);
                    end.setTime(start.getTime());
                    end.set(11, 23);
                    end.set(12, 59);
                    end.set(13, 59);
                }
                break;
            }
            case YEAR: {
                int counter;
                start.set(2, 0);
                start.set(5, 1);
                end.setTime(start.getTime());
                end.set(5, start.getActualMaximum(5));
                for (i = 0; i < 12; ++i) {
                    counter = ReportDataUtil.getRecordsCount(period, log.getEntries(), start, end);
                    dataList.add(counter);
                    start.add(2, 1);
                    end.setTime(start.getTime());
                    end.set(5, start.getActualMaximum(5));
                }
                break;
            }
        }
        double[] retValues = new double[dataList.size()];
        for (i = 0; i < dataList.size(); ++i) {
            retValues[i] = ((Integer)dataList.get(i)).intValue();
        }
        return retValues;
    }

    private static int getRecordsCount(ReportPeriod period, List<AuditLogEntry> entries, Calendar start, Calendar end) {
        int recordCount = 0;
        if (!period.equals((Object)ReportPeriod.DAY)) {
            start.set(11, 0);
            start.set(12, 0);
            end.set(11, 24);
            end.set(12, 0);
        }
        for (AuditLogEntry entry : entries) {
            if (entry.getTimestamp() < start.getTimeInMillis() || entry.getTimestamp() > end.getTimeInMillis()) continue;
            ++recordCount;
        }
        return recordCount;
    }

    private static final String[] getDatexAxisLabels(ReportPeriod period) {
        ArrayList<String> labels = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        switch (period) {
            case DAY: {
                for (int i = 0; i < 24; ++i) {
                    if (i < 10) {
                        labels.add("0" + i);
                        continue;
                    }
                    labels.add(String.valueOf(i));
                }
                break;
            }
            case WEEK: {
                ArrayList<String> weekDayList = new ArrayList<String>(Arrays.asList(new DateFormatSymbols(LocaleUtil.getLocale()).getWeekdays()));
                weekDayList.remove(0);
                String[] weekDayNames = weekDayList.toArray(new String[weekDayList.size()]);
                int dayOfWeek = cal.get(7);
                String[] restOfWeek = Arrays.copyOfRange(weekDayNames, dayOfWeek, weekDayNames.length);
                ArrayList<String> sortedDays = new ArrayList<String>(Arrays.asList(restOfWeek));
                for (int i = 0; i < dayOfWeek; ++i) {
                    sortedDays.add(weekDayNames[i]);
                }
                for (String label : sortedDays) {
                    labels.add(label);
                }
                break;
            }
            case MONTH: {
                int lastDayOfMonth = cal.getActualMaximum(5);
                for (int i = 1; i <= lastDayOfMonth; ++i) {
                    if (i < 10) {
                        labels.add("0" + i);
                        continue;
                    }
                    labels.add(String.valueOf(i));
                }
                break;
            }
            case YEAR: {
                String[] monthNames = new DateFormatSymbols(LocaleUtil.getLocale()).getMonths();
                for (int i = 0; i < 12; ++i) {
                    labels.add(monthNames[i]);
                }
                break;
            }
        }
        return labels.toArray(new String[labels.size()]);
    }

    public static enum ReportPeriod {
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }

    protected static enum CaseDataType {
        CREATED,
        MODIFIED,
        SENT;

    }
}

