/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import net.gopro.selfservice.SelfServiceEngine;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.log4j.Logger;

public final class ReferenceNumberGenerator {
    private static final Logger logger = Logger.getLogger(ReferenceNumberGenerator.class);
    private static final String DEFAULT_SEQUENCE = "S{D:yyMM}-{N:4}";
    private static AtomicBoolean isRecurring = null;

    public static final String createReferenceNumber(int counter) {
        String sequence = SelfServiceEngine.getConfig("web.casenumber.format");
        if (sequence != null) {
            try {
                return ReferenceNumberGenerator.createReferenceNumber(sequence, counter);
            }
            catch (Exception ex) {
                SelfServiceEngine.getLogger().error("Error using Ref Sequence: " + sequence + ".  Using default fallback sequence");
                return ReferenceNumberGenerator.createReferenceNumber(DEFAULT_SEQUENCE, counter);
            }
        }
        return ReferenceNumberGenerator.createReferenceNumber(DEFAULT_SEQUENCE, counter);
    }

    private static final String createReferenceNumber(String sequence, int counter) {
        String refNumber = "";
        StrTokenizer tok = new StrTokenizer(sequence, StrMatcher.charSetMatcher((String)"{}"));
        while (tok.hasNext()) {
            refNumber = refNumber + ReferenceNumberGenerator.formatString(tok.nextToken(), counter);
        }
        return refNumber;
    }

    public static final boolean isRecurring() {
        try {
            if (isRecurring == null) {
                String refConfig = SelfServiceEngine.getConfig("web.casenumber.reset");
                if (refConfig != null) {
                    isRecurring = new AtomicBoolean(Boolean.valueOf(refConfig));
                    logger.info((Object)("Case Ref Sequence recurrance set from config to: " + refConfig));
                } else {
                    isRecurring = new AtomicBoolean(true);
                    logger.info((Object)"Case Ref Sequence recurrance defaults to true");
                }
            }
            return isRecurring.get();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
            return true;
        }
    }

    private static String formatString(String s, int counter) {
        if (s.startsWith("D:")) {
            String dateFormat = s.substring(2);
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            return format.format(new Date());
        }
        if (s.startsWith("N:")) {
            return StringUtils.leftPad((String)String.valueOf(counter), (int)Integer.valueOf(s.substring(2)), (String)"0");
        }
        return s;
    }
}

