/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.User;

public final class PasswordUtil {
    public static final String encryptPassword(String password) throws SelfServiceException {
        try {
            StringBuffer encoded = new StringBuffer();
            if (password != null) {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(password.getBytes("UTF-8"));
                byte[] digest = md5.digest();
                for (int i = 0; i < digest.length; ++i) {
                    int b = digest[i] & 0xFF;
                    if (b < 16) {
                        encoded.append("0");
                    }
                    encoded.append(Integer.toHexString(b));
                }
            }
            return encoded.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SelfServiceException("MD5 library not available. " + ex.getMessage());
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static boolean isValidMD5(String s) {
        return s.matches("[a-fA-F0-9]{32}");
    }

    public static boolean matchesPassword(String password, User user) throws SelfServiceException {
        if (password != null && user != null) {
            return user.getPassword().equals(PasswordUtil.encryptPassword(password));
        }
        return false;
    }
}

