/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.servlets;

import com.PureEdge.DTK;
import com.PureEdge.error.UWIException;
import com.ibm.form.webform.framework.servlet.IBMWorkplaceFormsServerServlet;
import is.hugvit.log.Log;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.exceptions.FormDeadlineException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.impl.renderers.LotusFormManager;
import net.gopro.selfservice.util.PageUtil;
import net.gopro.selfservice.util.StringUtil;

public class LotusFormServlet
extends IBMWorkplaceFormsServerServlet {
    private static final String SESSION_TEMPLATE = "template_id";
    private static final String SESSION_APPLICATION = "application_id";
    private static final String SESSION_ORGANIZATION = "organization_id";
    private static final String SESSION_NEWFORM = "is_new";
    private static final long serialVersionUID = 7448125003615115727L;
    private static String lotusFormServer = null;
    private Log log = null;

    public void init() throws ServletException {
        super.init();
        try {
            this.log = SelfServiceEngine.getLogger();
            lotusFormServer = this.getServletConfig().getInitParameter("translatorLocation");
            LotusFormManager.setLogger(this.log);
            LotusFormManager.setLotusFormServerUrl(lotusFormServer);
            LotusFormManager.initializeFormTemplates(this.getTemplateManager());
            DTK.initializeWithLocale((String)"Webform Server", (String)"7.6.0", (String)"7.6.0", null);
            DTK.setHardGCFlag((boolean)false);
            this.log.info("Using Lotus Form Server: " + lotusFormServer);
        }
        catch (UWIException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (SelfServiceException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String mode = req.getParameter("mode");
            if (mode != null) {
                if (mode.equalsIgnoreCase("xfdl")) {
                    this.useXFDL(res, true);
                } else if (mode.equalsIgnoreCase("html")) {
                    this.useHTML(res, true);
                } else {
                    throw new ServletException("Invalid filemode defined. [Use only xfdl or html]");
                }
            }
            if (this.isNewForm(req)) {
                String templateId = this.getFormTemplateId(req);
                if (StringUtil.isValid(templateId)) {
                    LotusFormManager.renderFormTemplate(templateId, this, req, res);
                } else {
                    this.log.warn("No formtemplate Id was set");
                    PageUtil.redirect(req, res, "ss_frameout.html?applications.html");
                }
            } else {
                String applicationId = this.getApplicationId(req);
                if (StringUtil.isValid(applicationId)) {
                    LotusFormManager.renderApplication(applicationId, this, req, res);
                } else {
                    this.log.warn("No application Id was set");
                    PageUtil.redirect(req, res, "ss_frameout.html?applications.html");
                }
            }
        }
        catch (SelfServiceException ex) {
            ex.printStackTrace();
            throw new ServletException(ex.getMessage());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (req.getParameter("action") == null) {
            this.doGet(req, res);
        } else {
            try {
                boolean isFinalized = req.getParameter("action").equalsIgnoreCase("send");
                String applicationId = null;
                if (this.isNewForm(req)) {
                    applicationId = LotusFormManager.createApplication(this.getFormTemplateId(req), this.getOrganizationId(req), isFinalized, req);
                    req.getSession().setAttribute(SESSION_NEWFORM, null);
                } else {
                    applicationId = this.getApplicationId(req);
                    LotusFormManager.updateApplication(applicationId, isFinalized, req);
                }
                if (isFinalized) {
                    PageUtil.redirect(req, res, "ss_frameout.html?mycases.html");
                } else {
                    res.sendRedirect("?id=" + applicationId);
                }
            }
            catch (FormDeadlineException ex) {
                ex.printStackTrace();
            }
            catch (SelfServiceException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (SaveConflictException ex) {
                ex.printStackTrace();
            }
        }
    }

    private final String getFormTemplateId(HttpServletRequest request) {
        if (request.getSession().getAttribute(SESSION_TEMPLATE) != null) {
            return (String)request.getSession().getAttribute(SESSION_TEMPLATE);
        }
        return null;
    }

    private final String getApplicationId(HttpServletRequest request) {
        if (request.getSession().getAttribute(SESSION_APPLICATION) != null) {
            return (String)request.getSession().getAttribute(SESSION_APPLICATION);
        }
        return null;
    }

    private final String getOrganizationId(HttpServletRequest request) {
        if (request.getSession().getAttribute(SESSION_ORGANIZATION) != null) {
            return (String)request.getSession().getAttribute(SESSION_ORGANIZATION);
        }
        return null;
    }

    private final boolean isNewForm(HttpServletRequest request) {
        if (request.getSession().getAttribute(SESSION_NEWFORM) != null) {
            String value = (String)request.getSession().getAttribute(SESSION_NEWFORM);
            return "true".equalsIgnoreCase(value);
        }
        return false;
    }
}

