/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.routing;

import is.hugvit.log.Log;
import is.hugvit.thread.ThreadContext;
import is.hugvit.thread.ThreadManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.gopro.selfservice.IFormCaseProcessHookIn;
import net.gopro.selfservice.IGoProDataStore;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.MessageHelper;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.StatusList;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.data.routing.BrokerRelationEntry;
import net.gopro.selfservice.data.routing.QueueLogEntry;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.datastore.BrokerDataStore;
import net.gopro.selfservice.datastore.DataStoreFactory;
import net.gopro.selfservice.datastore.GDFDataStore;
import net.gopro.selfservice.datastore.NOPDataStore;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.exceptions.HookInException;
import net.gopro.selfservice.routing.BrokerRouter;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.QueueService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.ImpersonationUtil;
import net.gopro.selfservice.util.StringUtil;

public class RemoteGoProDataStore
implements Runnable {
    private Log log;
    private static final int DEFAULT_MAX_RETRIES = 5000;

    public void init() throws SelfServiceException {
        ThreadContext tc = ThreadManager.getContext((Object)this);
        this.log = tc.getLog();
    }

    @Override
    public void run() {
        try {
            this.init();
            if (!SelfServiceEngine.isInitialized()) {
                this.log.info("Skipping schedule: Self Service in not yet initialized.");
                return;
            }
            boolean isDisabled = "false".equalsIgnoreCase(SelfServiceEngine.getConfig("agent.schedules.active"));
            if (isDisabled) {
                this.log.warn("Agents are disabled in config, aborting.");
                return;
            }
            ImpersonationUtil.impersonate();
            try {
                this.processQueue();
            }
            catch (SelfServiceException ex) {
                this.log.error("Error processing Queue: " + ex.getMessage());
                ex.printStackTrace();
            }
            try {
                this.processStatusUpdates();
            }
            catch (SelfServiceException ex) {
                this.log.error("Self Service error processing Case updates: " + ex.getMessage());
                ex.printStackTrace();
            }
            catch (GoProDataStoreException ex) {
                this.log.error("Datastore error processing Case updates: " + ex.getMessage());
                ex.printStackTrace();
            }
            try {
                this.processIncomingDocuments();
            }
            catch (SelfServiceException ex) {
                this.log.error("Self Service error processing incoming documents: " + ex.getMessage());
                ex.printStackTrace();
            }
            catch (GoProDataStoreException ex) {
                this.log.error("Datastore error processing incoming documents: " + ex.getMessage());
                ex.printStackTrace();
            }
            try {
                BrokerRouter.processCaseRelations(this.log);
                BrokerRouter.processDocumentRelations(this.log);
            }
            catch (SelfServiceException ex) {
                this.log.error("Error getting document confirmation from Broker!", (Exception)ex);
                ex.printStackTrace();
            }
            catch (GoProDataStoreException ex) {
                this.log.error("Error getting document confirmation from Broker!", (Exception)ex);
                ex.printStackTrace();
            }
        }
        catch (SelfServiceException ex) {
            this.log.error("Self Service could not initialize properly: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            this.log.error("Fatal exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    private void processStatusUpdates() throws SelfServiceException, GoProDataStoreException {
        List<Organization> organizationList = ConfigService.getOrganizations();
        BaseDocumentUtil.removeDeletedDocuments(organizationList);
        if (organizationList != null && organizationList.size() > 0) {
            for (Organization org : organizationList) {
                if (!org.isEnabled()) continue;
                IGoProDataStore gopro = this.getDataStore(org.getId());
                Map<BaseDocument, String> map = null;
                try {
                    map = gopro.getStatusUpdates(org);
                }
                catch (GoProDataStoreException ex) {
                    this.log.error("Error fetching Case status updates for organization: " + org.getSubject(), (Exception)ex);
                }
                if (map == null) continue;
                this.log.info(org.getSubject() + " : Document Count for update: " + map.size());
                if (map.size() <= 0) continue;
                this.updateDocumentStatus(map);
            }
        }
    }

    private void processIncomingDocuments() throws SelfServiceException, GoProDataStoreException {
        List<Organization> organizationList = ConfigService.getOrganizations();
        BaseDocumentUtil.removeDeletedDocuments(organizationList);
        if (organizationList != null && organizationList.size() > 0) {
            for (Organization org : organizationList) {
                if (!org.isEnabled()) continue;
                IGoProDataStore gopro = this.getDataStore(org.getId());
                try {
                    List<? extends SubDocument> docs = gopro.getIncomingDocuments(org);
                    ArrayList<DocumentReferenceMap> unresolvedParentIds = new ArrayList<DocumentReferenceMap>();
                    if (docs == null || docs.size() <= 0) continue;
                    this.log.info(org.getSubject() + " Incoming response count: " + docs.size());
                    MetaData metaMemoSync = org.getMetaDataByKey("sync.memo");
                    MetaData metaFileSync = org.getMetaDataByKey("sync.attachment");
                    for (SubDocument subDocument : docs) {
                        try {
                            SubDocument existingDoc;
                            BaseCase parentCase = CaseService.getCase(subDocument.getCaseId());
                            User caseOwner = UserService.getUser(parentCase.getCreatedById());
                            DocumentReferenceMap refMap = null;
                            if (subDocument.getParentId() != null && subDocument.isParentIdDirty()) {
                                refMap = new DocumentReferenceMap(subDocument.getParentId(), subDocument.getDateCreated());
                                unresolvedParentIds.add(refMap);
                                subDocument.setParentId(null);
                            }
                            subDocument.getAccessControlList().addAll(parentCase.getAccessControlList());
                            if (subDocument instanceof Memo) {
                                Memo memo = (Memo)subDocument;
                                existingDoc = CaseService.getSubDocumentByGoProId(memo.getGoProId());
                                if (existingDoc == null) {
                                    try {
                                        CaseService.createSubDocument(memo);
                                    }
                                    catch (SelfServiceException ex) {
                                        if (gopro instanceof GDFDataStore && metaMemoSync != null) {
                                            ConfigService.updateMetaData(metaMemoSync);
                                        }
                                        throw ex;
                                    }
                                    MessageHelper.sendIncomingMemoMessage(caseOwner, memo, parentCase);
                                    if (refMap == null) continue;
                                    refMap.setDocumentId(memo.getId());
                                    continue;
                                }
                                this.log.warn("The incoming memo " + memo.getSubject() + " has already been added!");
                                continue;
                            }
                            if (!(subDocument instanceof Attachment)) continue;
                            Attachment attachment = (Attachment)subDocument;
                            existingDoc = CaseService.getSubDocumentByGoProId(attachment.getGoProId());
                            if (existingDoc == null) {
                                try {
                                    CaseService.createSubDocument(attachment);
                                }
                                catch (SelfServiceException ex) {
                                    if (gopro instanceof GDFDataStore && metaFileSync != null) {
                                        ConfigService.updateMetaData(metaFileSync);
                                    }
                                    throw ex;
                                }
                                MessageHelper.sendIncomingFileMessage(caseOwner, attachment, parentCase);
                                if (refMap == null) continue;
                                refMap.setDocumentId(attachment.getId());
                                continue;
                            }
                            this.log.warn("The incoming attachment " + attachment.getSubject() + " has already been added.");
                        }
                        catch (SelfServiceException ex) {
                            this.log.error("Error processing incoming document: " + subDocument.getClass().getSimpleName(), (Exception)ex);
                            this.log.error((Exception)ex);
                        }
                        catch (CaseException ex) {
                            this.log.error("Error processing incoming document: " + subDocument.getClass().getSimpleName(), (Exception)ex);
                            this.log.error((Exception)ex);
                        }
                    }
                    Collections.sort(unresolvedParentIds);
                    if (unresolvedParentIds.size() <= 0) continue;
                    this.log.info("ParentIds to resolve: " + unresolvedParentIds.size());
                    for (DocumentReferenceMap documentReferenceMap : unresolvedParentIds) {
                        SubDocument parent = CaseService.getSubDocumentByGoProId(documentReferenceMap.getGoProId());
                        if (parent == null && documentReferenceMap.getGoProId().length() == 32) {
                            parent = CaseService.getSubDocumentByGoProId(StringUtil.toUUID(documentReferenceMap.getGoProId()));
                        }
                        if (parent != null) {
                            SubDocument sub = CaseService.getSubDocument(documentReferenceMap.getDocumentId(), true);
                            if (sub != null) {
                                sub.setParentId(parent.getId());
                                try {
                                    CaseService.updateSubDocument(sub);
                                    this.log.info("Updated parent for: " + sub.getSubject());
                                }
                                catch (Exception ex) {
                                    this.log.error("Error updating parentId : " + ex.getMessage());
                                }
                                continue;
                            }
                            this.log.error("Parent resolver: Subdocument not found: " + documentReferenceMap.getDocumentId());
                            continue;
                        }
                        this.log.error("Parent resolver: Parent doc not found: " + documentReferenceMap.getGoProId());
                    }
                }
                catch (GoProDataStoreException ex) {
                    this.log.error("Error: Incoming documents : " + org.getSubject() + " " + ex.getMessage());
                    this.log.error((Exception)ex);
                }
            }
        }
    }

    private void processQueue() throws SelfServiceException {
        List<RoutingQueueEntry> queueList = QueueService.getRoutingQueue();
        this.log.info("Datastore Queue Size: " + queueList.size());
        int maxRetries = this.getMaximumRetryRounds();
        int itemsReachedMaxRetries = 0;
        Collections.reverse(queueList);
        for (RoutingQueueEntry queueItem : queueList) {
            if (queueItem.getIterationCount() > maxRetries) {
                ++itemsReachedMaxRetries;
                continue;
            }
            Organization destination = ConfigService.getOrganization(queueItem.getOrganizationId());
            if (destination == null) {
                this.log.warn("Organisation not found: " + queueItem.getOrganizationId());
                continue;
            }
            if (destination.isEnabled() && !destination.isDeleted()) {
                if (RoutingQueueEntry.DocumentType.CASE.equals((Object)queueItem.getDocumentType())) {
                    this.log.info("[" + destination.getSubject() + "] Working with application ...");
                    this.handleCase(queueItem);
                } else if (RoutingQueueEntry.DocumentType.SUBDOCUMENT.equals((Object)queueItem.getDocumentType())) {
                    this.log.info("[" + destination.getSubject() + "] Working with a subdocument ...");
                    this.createSubdocument(queueItem);
                } else if (RoutingQueueEntry.DocumentType.CONTACT.equals((Object)queueItem.getDocumentType())) {
                    this.log.info("[" + destination.getSubject() + "] Working with contact which needs updating ...");
                    this.updateContact(queueItem);
                }
                queueItem.incrementIterationCount();
                QueueService.updateRoutingQueueEntry(queueItem);
                continue;
            }
            this.log.debug("Skipping disabled organization: " + destination.getSubject());
        }
        if (itemsReachedMaxRetries > 0) {
            this.log.info(itemsReachedMaxRetries + " items skipped: max retries reached (" + maxRetries + ")");
        }
    }

    private void updateContact(RoutingQueueEntry entry) throws SelfServiceException {
        try {
            User contact = UserService.getUser(entry.getDocumentId());
            if (contact != null && contact.getGoproClientReferences().size() > 0) {
                List<GoProClientBaseReference> refList = contact.getGoProClientReferences(entry.getOrganizationId());
                if (!refList.isEmpty()) {
                    IGoProDataStore gopro = this.getDataStore(entry.getOrganizationId());
                    ArrayList<String> updateIds = new ArrayList<String>();
                    for (GoProClientBaseReference clientRef : refList) {
                        String documentId = gopro.updateContact(contact, clientRef);
                        if (documentId == null) continue;
                        updateIds.add(documentId);
                    }
                    if (updateIds.size() == refList.size()) {
                        QueueService.removeRoutingQueueEntry(entry.getId());
                        entry.markProcessed();
                    }
                }
            } else if (contact == null) {
                QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.WARN, "The user was not found, the user has most likely been deleted."));
            }
        }
        catch (GoProDataStoreException ex) {
            QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, ex));
            this.log.error((Exception)ex);
        }
    }

    private String createSubdocument(RoutingQueueEntry entry) throws SelfServiceException {
        String remoteGoProId = null;
        try {
            SubDocument doc = CaseService.getSubDocument(entry.getDocumentId(), true);
            if (doc != null) {
                BaseCase parentCase = CaseService.getCase(doc.getCaseId());
                IGoProDataStore gopro = null;
                if (parentCase != null) {
                    gopro = this.getDataStore(parentCase.getOrganizationId());
                }
                if (gopro != null && gopro instanceof NOPDataStore) {
                    entry.markProcessed();
                    return null;
                }
                if (parentCase != null && StringUtil.isValid(parentCase.getGoProId())) {
                    String warning;
                    SubDocument parentDocument;
                    boolean isParentResponseDocMissing = false;
                    if (!(doc.getParentId() == null || doc.getParentId().equals(doc.getCaseId()) || (parentDocument = CaseService.getSubDocument(doc.getParentId(), false)) != null && StringUtil.isValid(parentDocument.getGoProId()))) {
                        isParentResponseDocMissing = true;
                    }
                    if (!isParentResponseDocMissing) {
                        if (parentCase instanceof FormCase) {
                            this.doPreSendFormCase(doc, (FormCase)parentCase, IFormCaseProcessHookIn.RecordAction.CREATE);
                        }
                        if ((remoteGoProId = gopro.createSubDocument(doc, parentCase)) != null) {
                            if (gopro instanceof BrokerDataStore) {
                                String transactionId = remoteGoProId;
                                BrokerRelationEntry brokerRelation = new BrokerRelationEntry(entry, transactionId);
                                QueueService.createBrokerRelationEntry(brokerRelation);
                            } else {
                                doc.setGoProId(remoteGoProId);
                                QueueService.createDocumentRelation(entry.getId(), remoteGoProId);
                            }
                            QueueService.removeRoutingQueueEntry(entry.getId());
                            if (parentCase instanceof FormCase) {
                                this.doPostSendFormCase(doc, (FormCase)parentCase, IFormCaseProcessHookIn.RecordAction.CREATE);
                            }
                            entry.markProcessed();
                        } else {
                            warning = "Document created but no ID returned ? ";
                            this.log.warn(warning + "Subdocument: " + entry.getDocumentId());
                            QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, warning));
                        }
                    } else {
                        warning = "Parent Response for [" + doc.getSubject() + "] was not found or parent GoProId is missing.";
                        this.log.warn(warning);
                        QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, warning));
                    }
                } else {
                    String warning = "Parent Case not found or parent GoProId is missing.";
                    this.log.warn(warning);
                    QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, warning));
                }
            } else {
                this.log.warn("SubDocument not found: " + entry.getDocumentId());
            }
        }
        catch (GoProDataStoreException ex) {
            QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, ex));
            this.log.error((Exception)ex);
        }
        catch (HookInException ex) {
            this.log.error("Hookin Exception: CaseId: " + entry.getDocumentId(), (Exception)ex);
        }
        catch (RuntimeException ex) {
            this.log.error("Hookin Exception: CaseId: " + entry.getDocumentId(), (Exception)ex);
        }
        return remoteGoProId;
    }

    private String handleCase(RoutingQueueEntry entry) throws SelfServiceException {
        BaseCase bc = CaseService.getCase(entry.getDocumentId());
        if (bc != null) {
            if (StringUtil.isValid(bc.getGoProId())) {
                return this.updateCase(entry, bc);
            }
            return this.createCase(entry, bc);
        }
        this.log.warn("CaseId not found: " + entry.getDocumentId());
        return null;
    }

    private String updateCase(RoutingQueueEntry entry, BaseCase bc) throws SelfServiceException {
        IGoProDataStore gopro = null;
        String remoteGoProId = null;
        try {
            gopro = this.getDataStore(entry.getOrganizationId());
            if (bc instanceof FormCase) {
                this.doPreSendFormCase(null, (FormCase)bc, IFormCaseProcessHookIn.RecordAction.UPDATE);
            }
            if (gopro instanceof NOPDataStore) {
                entry.markProcessed();
                return null;
            }
            remoteGoProId = gopro.updateCase(bc);
            if (remoteGoProId != null) {
                QueueService.removeRoutingQueueEntry(entry.getId());
                if (bc instanceof FormCase) {
                    this.doPostSendFormCase(null, (FormCase)bc, IFormCaseProcessHookIn.RecordAction.UPDATE);
                }
                entry.markProcessed();
            } else {
                String warning = "Document updated but no ID returned ?";
                this.log.warn(warning + ", Case: " + entry.getDocumentId());
                QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, warning));
            }
        }
        catch (GoProDataStoreException ex) {
            QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, ex));
            this.log.error("Error: " + gopro.getInfo() + " CaseId: " + entry.getDocumentId(), (Exception)ex);
        }
        catch (RuntimeException ex) {
            this.log.error("Hookin Exception: " + gopro.getInfo() + " CaseId: " + entry.getDocumentId(), (Exception)ex);
        }
        catch (HookInException ex) {
            this.log.error("Hookin Exception: " + gopro.getInfo() + " CaseId: " + entry.getDocumentId(), (Exception)ex);
        }
        return remoteGoProId;
    }

    private String createCase(RoutingQueueEntry entry, BaseCase bc) throws SelfServiceException {
        String remoteGoProId = null;
        IGoProDataStore gopro = null;
        try {
            gopro = this.getDataStore(entry.getOrganizationId());
            if (bc instanceof FormCase) {
                this.doPreSendFormCase(null, (FormCase)bc, IFormCaseProcessHookIn.RecordAction.CREATE);
            }
            if (gopro instanceof NOPDataStore) {
                entry.markProcessed();
                return null;
            }
            remoteGoProId = gopro.createCase(bc);
            if (remoteGoProId != null) {
                Organization target = ConfigService.getOrganization(entry.getOrganizationId());
                if (gopro instanceof BrokerDataStore) {
                    String transactionId = remoteGoProId;
                    BrokerRelationEntry brokerRelation = new BrokerRelationEntry(entry, transactionId);
                    QueueService.createBrokerRelationEntry(brokerRelation);
                } else {
                    String caseNumber = gopro.getCaseNumber(remoteGoProId, target);
                    if (caseNumber == null) {
                        this.log.warn("Case Number was not returned: " + bc.getId());
                    }
                    bc.setGoProId(remoteGoProId);
                    bc.setGoProCaseNumber(caseNumber);
                    QueueService.createCaseRelation(entry.getId(), remoteGoProId, caseNumber);
                }
                QueueService.removeRoutingQueueEntry(entry.getId());
                if (bc instanceof FormCase) {
                    this.doPostSendFormCase(null, (FormCase)bc, IFormCaseProcessHookIn.RecordAction.CREATE);
                }
                entry.markProcessed();
            } else {
                String warning = "Document created but no ID returned ?";
                this.log.warn(warning + ", Case: " + entry.getDocumentId());
                QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, warning));
            }
        }
        catch (GoProDataStoreException ex) {
            QueueService.createQueueLogEntry(new QueueLogEntry(entry.getId(), QueueLogEntry.Level.ERROR, ex));
            this.log.error("Error: " + gopro.getInfo() + " CaseId: " + entry.getDocumentId(), (Exception)ex);
        }
        catch (HookInException ex) {
            this.log.error("Hookin Exception: " + gopro.getInfo() + " CaseId: " + entry.getDocumentId(), (Exception)ex);
        }
        catch (RuntimeException ex) {
            this.log.error("Hookin Exception: " + gopro.getInfo() + " CaseId: " + entry.getDocumentId(), (Exception)ex);
        }
        return remoteGoProId;
    }

    private final IGoProDataStore getDataStore(String organizationId) throws GoProDataStoreException {
        try {
            IGoProDataStore gopro = null;
            Organization org = ConfigService.getOrganization(organizationId);
            if (org == null) {
                throw new GoProDataStoreException("Invalid organization Id supplied");
            }
            gopro = DataStoreFactory.getDataStore(org.getEndpoint());
            gopro.setLogger(this.log);
            return gopro;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    private void updateDocumentStatus(Map<BaseDocument, String> map) throws SelfServiceException {
        block0: for (Map.Entry<BaseDocument, String> pairs : map.entrySet()) {
            BaseDocument doc = pairs.getKey();
            String documentStatus = pairs.getValue();
            if (doc instanceof BaseCase && StringUtil.isValid(documentStatus)) {
                BaseCase bc = (BaseCase)doc;
                LinkedList<StatusListItem> caseStatusList = bc.getCaseFlow();
                BaseDocument newStatus = null;
                StatusListItem oldStatus = null;
                for (StatusListItem statusItem : caseStatusList) {
                    if (documentStatus.equalsIgnoreCase(statusItem.getSubject()) || documentStatus.equalsIgnoreCase(statusItem.getAlias())) {
                        newStatus = statusItem;
                    }
                    if (!statusItem.getId().equals(bc.getStatusId())) continue;
                    oldStatus = statusItem;
                }
                if (newStatus == null || newStatus.getId().equals(bc.getStatusId())) continue;
                if (bc instanceof FormCase && !((FormCase)bc).isReOpened()) {
                    bc.setStatusId(newStatus.getId());
                    CaseService.updateCaseStatus(bc);
                    if (oldStatus != null) {
                        this.log.info("Updated Case: " + bc.getReferenceNumber() + " : Old status: " + oldStatus.getSubject() + ",   New status: " + ((ListItem)newStatus).getSubject());
                    } else {
                        this.log.info("Updated Case: " + bc.getReferenceNumber() + " : New status: " + ((ListItem)newStatus).getSubject());
                    }
                    User caseOwner = UserService.getUser(bc.getCreatedById());
                    MessageHelper.sendUpdatedCaseStatusMessage(caseOwner, bc);
                    continue;
                }
                this.log.info(String.format("Status not updated for case: %s, Either not FormCase or has been reopened", bc.getReferenceNumber()));
                continue;
            }
            if (!(doc instanceof SubDocument) || !StringUtil.isValid(documentStatus)) continue;
            SubDocument sub = (SubDocument)doc;
            StatusList statusList = null;
            if (sub instanceof Memo) {
                statusList = (StatusList)ConfigService.getList("00F9E89D6203E1AB00000121159B3979");
            } else if (sub instanceof ExternalDocument) {
                statusList = (StatusList)ConfigService.getList("0009A47DD30D261C0000012110DFE58C");
            } else if (sub instanceof Email) {
                statusList = (StatusList)ConfigService.getList("221003FD1A49F6E10000013775389FFF");
            }
            if (statusList == null) continue;
            for (ListItem item : statusList.getListItems()) {
                if (!item.getSubject().equalsIgnoreCase(documentStatus) && !item.getAlias().equalsIgnoreCase(documentStatus) || sub.getStatusId().equals(item.getId())) continue;
                sub.setStatusId(item.getId());
                sub.setStatusText(item.getSubject());
                CaseService.updateSubdocumentStatus(sub);
                this.log.debug("Status updated for document : " + sub.getSubject() + ". New status: " + item.getSubject());
                continue block0;
            }
        }
    }

    private final void doPreSendFormCase(SubDocument doc, FormCase fc, IFormCaseProcessHookIn.RecordAction action) throws SelfServiceException, HookInException, RuntimeException {
        FormTemplate ft = FormService.getFormTemplate(fc.getFormtemplateId(), false);
        if (ft != null && ft.getFormCaseProcessHookIn() instanceof IFormCaseProcessHookIn) {
            if (doc != null) {
                ft.getFormCaseProcessHookIn().doPreSend(doc, fc, action);
            } else {
                ft.getFormCaseProcessHookIn().doPreSend(fc, action);
            }
        }
    }

    private final void doPostSendFormCase(SubDocument doc, FormCase fc, IFormCaseProcessHookIn.RecordAction action) throws SelfServiceException, HookInException, RuntimeException {
        FormTemplate ft = FormService.getFormTemplate(fc.getFormtemplateId(), false);
        if (ft != null && ft.getFormCaseProcessHookIn() instanceof IFormCaseProcessHookIn) {
            if (doc != null) {
                ft.getFormCaseProcessHookIn().doPostSend(doc, fc, action);
            } else {
                ft.getFormCaseProcessHookIn().doPostSend(fc, action);
            }
        }
    }

    private final int getMaximumRetryRounds() {
        String sRetries = SelfServiceEngine.getConfig("agent.datastore.maxrounds");
        if (sRetries != null) {
            try {
                return Integer.parseInt(sRetries);
            }
            catch (Exception ex) {
                return 5000;
            }
        }
        return 5000;
    }

    private class DocumentReferenceMap
    implements Comparable<DocumentReferenceMap> {
        private String documentId;
        private String goProId;
        private long dateCreated;

        public long getDateCreated() {
            return this.dateCreated;
        }

        public DocumentReferenceMap(String goProId, long dateCreated) {
            this.goProId = goProId;
            this.dateCreated = dateCreated;
        }

        public void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public String getGoProId() {
            return this.goProId;
        }

        @Override
        public int compareTo(DocumentReferenceMap o) {
            if (o.getDateCreated() < this.getDateCreated()) {
                return 1;
            }
            if (o.getDateCreated() > this.getDateCreated()) {
                return -1;
            }
            return 0;
        }
    }
}

