/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pdf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.pdf.PDFProperties;
import net.gopro.selfservice.util.StringUtil;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.servlet.ServletContextURIResolver;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.xml.sax.SAXException;

public class FOPTransformer {
    private static final String V1_XSLFO_SINGLE = "selfservice/v1/selfservice-pdf-fo.xsl";
    private static final String V1_XSLFO_DOUBLE = "selfservice/v1/selfservice-pdf-fo-double.xsl";
    private static final String V1_FOP_CONFIG = "selfservice/v1/fop-config.xml";
    private static final String V2_XSLFO_SINGLE = "selfservice/v2/selfservice-pdf-fo.xsl";
    private static final String V2_XSLFO_DOUBLE = "selfservice/v2/selfservice-pdf-fo-double.xsl";
    private static final String V2_FOP_CONFIG = "selfservice/v2/config.xml";
    private PDFProperties properties;
    private static final Logger logger = Logger.getLogger(FOPTransformer.class);

    public FOPTransformer(PDFProperties properties) {
        this.properties = properties;
    }

    public final byte[] transFormToPDF(Document doc, FormTemplateExtras.XSLFoType fo, GoProFormTemplate.GoProFormType formType) throws SelfServiceException {
        byte[] bytes = null;
        try {
            String xslDoubleTemplate;
            ServletContext ctx = SelfServiceEngine.getContext();
            boolean isCustomLoaded = false;
            InputStream is = null;
            try {
                String templateId;
                String path;
                File templateFile;
                String templateName;
                Node templateIdNode = doc.getRootElement().selectSingleNode("@TEMPLATE-ID");
                Node templateCaseTypeNode = doc.getRootElement().selectSingleNode("@GOPRO-CASETYPE");
                if (templateCaseTypeNode != null && StringUtil.isValid(templateName = templateCaseTypeNode.getText()) && (templateFile = new File(ctx.getRealPath(path = "/WEB-INF/selfservice/" + templateName + ".xsl"))).exists()) {
                    logger.debug((Object)("Found custom FOP file to be used: " + templateName + ".xsl"));
                    is = ctx.getResourceAsStream(path);
                    isCustomLoaded = true;
                }
                if (!isCustomLoaded && templateIdNode != null && StringUtil.isValid(templateId = templateIdNode.getText()) && (templateFile = new File(ctx.getRealPath(path = "/WEB-INF/selfservice/" + templateId + ".xsl"))).exists()) {
                    logger.debug((Object)("Found custom FOP file to be used: " + templateId + ".xsl"));
                    is = ctx.getResourceAsStream(path);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Error loading custom file", (Throwable)ex);
            }
            String xslSingleTemplate = GoProFormTemplate.GoProFormType.GOPRO_FORM_V1.equals((Object)formType) ? V1_XSLFO_SINGLE : V2_XSLFO_SINGLE;
            String string = xslDoubleTemplate = GoProFormTemplate.GoProFormType.GOPRO_FORM_V1.equals((Object)formType) ? V1_XSLFO_DOUBLE : V2_XSLFO_DOUBLE;
            if (is == null) {
                is = fo != null && fo.equals((Object)FormTemplateExtras.XSLFoType.DOUBLE) ? ctx.getResourceAsStream("/WEB-INF/" + xslDoubleTemplate) : ctx.getResourceAsStream("/WEB-INF/" + xslSingleTemplate);
            }
            FopFactory fopFactory = FopFactory.newInstance();
            TransformerFactory tFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
            fopFactory.setURIResolver((URIResolver)new ServletContextURIResolver(ctx));
            try {
                File configFile;
                if (GoProFormTemplate.GoProFormType.GOPRO_FORM_V2.equals((Object)formType)) {
                    configFile = new File(ctx.getRealPath("/WEB-INF/selfservice/v2/config.xml"));
                    fopFactory.setUserConfig(configFile);
                } else {
                    configFile = new File(ctx.getRealPath("/WEB-INF/selfservice/v1/fop-config.xml"));
                    fopFactory.setUserConfig(configFile);
                }
            }
            catch (FileNotFoundException configFile) {
                // empty catch block
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FOUserAgent userAgent = this.createUserAgent(fopFactory, doc, formType);
            Fop fop = fopFactory.newFop("application/pdf", userAgent, (OutputStream)out);
            StreamSource xsltSrc = new StreamSource(is);
            Transformer transformer = tFactory.newTransformer(xsltSrc);
            if (GoProFormTemplate.GoProFormType.GOPRO_FORM_V2.equals((Object)formType)) {
                String basePath = ctx.getRealPath("/WEB-INF/selfservice/v2");
                File fileBasePath = new File(basePath);
                transformer.setParameter("path", fileBasePath.toURI().toString());
            }
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            StreamSource src = new StreamSource(new StringReader(doc.asXML()));
            transformer.transform(src, res);
            is.close();
            bytes = out.toByteArray();
        }
        catch (FOPException ex) {
            ex.printStackTrace();
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
            throw new SelfServiceException(ex);
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SelfServiceException(ex);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            throw new SelfServiceException(ex);
        }
        return bytes;
    }

    private FOUserAgent createUserAgent(FopFactory factory, Document doc, GoProFormTemplate.GoProFormType formType) {
        FOUserAgent userAgent = factory.newFOUserAgent();
        userAgent.setProducer(this.properties.getProducer());
        userAgent.setCreator(this.properties.getCreator());
        userAgent.setCreationDate(new Date());
        userAgent.setTitle(this.properties.getTitle());
        userAgent.setSubject(this.properties.getSubject());
        userAgent.setAuthor(this.properties.getAuthor());
        userAgent.setKeywords(this.properties.getKeywords());
        return userAgent;
    }
}

