/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.Cookie;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.SelfServicePrincipal;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BirdUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.util.ThreadContext;
import org.dom4j.Element;

public class ProfilePage
extends BasePage {
    public static final String pageName = "profile.html";

    @Override
    public void doGet(WebContext context) throws BirdException {
    }

    @Override
    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            InputStream in;
            SelfServicePrincipal principal = this.getPrincipal(context);
            User user = UserService.getUser(principal.getUserId());
            String fullname = StringUtil.stripHTML(data.getString("fullname"));
            String email = data.getString("email");
            String mobilePhone = StringUtil.stripHTML(data.getString("mobile-phone"));
            String homePhone = StringUtil.stripHTML(data.getString("home-phone"));
            String streetname = StringUtil.stripHTML(data.getString("streetname"));
            String city = StringUtil.stripHTML(data.getString("city"));
            String state = StringUtil.stripHTML(data.getString("state"));
            String postcode = StringUtil.stripHTML(data.getString("postcode"));
            String country = StringUtil.stripHTML(data.getString("country"));
            String communication = data.getString("communication");
            String locale = data.getString("locale");
            user.setFullname(fullname);
            user.setEmail(email);
            user.setMobilephoneNumber(mobilePhone);
            user.setHomephoneNumber(homePhone);
            try {
                user.setCommunication(User.Communications.valueOf(communication));
            }
            catch (IllegalArgumentException ex) {
                user.setCommunication(User.Communications.NONE);
            }
            user.getAddress().setStreetName(streetname);
            user.getAddress().setCity(city);
            user.getAddress().setState(state);
            user.getAddress().setPostcode(postcode);
            user.getAddress().setCountry(country);
            if (StringUtil.isValid(locale)) {
                user.setLocale(locale);
            }
            if ((in = data.getInputStream("profile-upload")) != null) {
                this.processProfileImage(context, data, in, user);
            }
            Hashtable ht = data.getHashtable();
            Set<Contact> contactList = user.getContactList();
            for (String key : ht.keySet()) {
                if (!key.startsWith("contactmail-")) continue;
                String contactId = key.split("-")[1];
                String contactEmail = (String)ht.get(key);
                for (Contact contact : contactList) {
                    if (!contact.getId().equals(contactId) || contactEmail.equals(contact.getEmail())) continue;
                    contact.setEmail(contactEmail);
                }
            }
            Enumeration enumKeys = data.keys();
            while (enumKeys.hasMoreElements()) {
                String dataKey = (String)enumKeys.nextElement();
                if (dataKey == null || !dataKey.toLowerCase().startsWith("meta.")) continue;
                String key = dataKey.substring("meta.".length(), dataKey.length());
                String value = data.getString(dataKey);
                MetaData meta = user.getMetaDataByKey(key);
                if (meta != null) {
                    meta.setValue(value);
                    meta.setDirty(true);
                    continue;
                }
                meta = new MetaData(key, value);
                meta.setUserId(user.getId());
                user.getMetadata().add(meta);
            }
            this.doPreSave(user, context, data);
            try {
                String formAction = data.getString("form_action");
                if ("deleteimage".equals(formAction)) {
                    this.deleteProfileImage(context, user);
                }
                UserService.updateUser(user);
                BirdUserPrincipal currentUser = ThreadContext.getCurrentUser();
                currentUser.setFullName(user.getFullname());
                currentUser.setEmail(user.getEmail());
                currentUser.setLocale(user.getLocale());
                ThreadContext.setCurrentUser(currentUser);
                if (StringUtil.isValid(locale)) {
                    Cookie cookie = new Cookie("locale", locale);
                    cookie.setPath(context.getRequest().getServletContext().getContextPath());
                    cookie.setMaxAge(Integer.MAX_VALUE);
                    context.getResponse().addCookie(cookie);
                }
                this.doPostSave(user, context, data);
                data.setMessage(this.resourceBundle.getString("pro.updated"));
                if ("saveandclose".equals(formAction)) {
                    context.setRedirectURL("home.html");
                } else if ("deleteimage".equals(formAction)) {
                    context.setRedirectURL(pageName);
                }
            }
            catch (UserException ex) {
                data.setError(ex.getMessage());
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public boolean querySave(WebContext context, Form data) throws BirdException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception");
        String fullname = data.getString("fullname");
        String email = data.getString("email");
        String streetname = data.getString("streetname");
        String city = data.getString("city");
        String state = data.getString("state");
        String postcode = data.getString("postcode");
        String country = data.getString("country");
        data.put("username", data.get("username"));
        data.put("is-contact", data.get("is-contact"));
        if (!StringUtil.isValid(fullname)) {
            data.setError(rb.getString("user.fullname"));
            return false;
        }
        if (!StringUtil.isValidEmail(email)) {
            data.setError(rb.getString("user.email"));
            return false;
        }
        Hashtable ht = data.getHashtable();
        for (String key : ht.keySet()) {
            String contactEmail;
            if (!key.startsWith("contactmail-") || (contactEmail = (String)ht.get(key)) == null || "".equals(contactEmail) || StringUtil.isValidEmail(contactEmail)) continue;
            data.setError(rb.getString("user.contactemail") + ": " + contactEmail);
            return false;
        }
        boolean isAddressRequired = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.require.address"));
        if (isAddressRequired) {
            if (!StringUtil.isValid(streetname)) {
                data.setError(rb.getString("user.address"));
                return false;
            }
            if (!StringUtil.isValid(city)) {
                data.setError(rb.getString("user.city"));
                return false;
            }
            if (!StringUtil.isValid(state)) {
                data.setError(rb.getString("user.state"));
                return false;
            }
            if (!StringUtil.isValid(postcode)) {
                data.setError(rb.getString("user.postcode"));
                return false;
            }
            if (!StringUtil.isValid(country)) {
                data.setError(rb.getString("user.country"));
                return false;
            }
        }
        String communication = data.getString("communication");
        String mobilePhone = data.getString("mobile-phone");
        try {
            User.Communications com = User.Communications.valueOf(communication);
            if (User.Communications.SMS.equals((Object)com) && !StringUtil.isValid(mobilePhone)) {
                data.setError(rb.getString("user.sms"));
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }

    @Override
    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            MetaData metaIsTwoFactorEnabled;
            SelfServicePrincipal principal = this.getPrincipal(context);
            User user = UserService.getUser(principal.getUserId());
            Address address = user.getAddress();
            data.put("username", user.getUsername());
            data.put("fullname", user.getFullname());
            data.put("email", user.getEmail());
            data.put("mobile-phone", user.getMobilephoneNumber());
            data.put("home-phone", user.getHomephoneNumber());
            data.put("profile-image", user.getProfileImage());
            data.put("communication", user.getCommunication().toString());
            data.put("streetname", address.getStreetName());
            data.put("city", address.getCity());
            data.put("state", address.getState());
            data.put("postcode", address.getPostcode());
            data.put("country", address.getCountry());
            data.put("is-contact", String.valueOf(user.isContact()));
            if (user.isContact()) {
                for (Contact contact : user.getContactList()) {
                    data.put("contactmail-" + contact.getId(), contact.getEmail());
                }
            }
            if ((metaIsTwoFactorEnabled = user.getMetaDataByKey("authentication.twofactor")) != null && !metaIsTwoFactorEnabled.isDeleted() && "true".equalsIgnoreCase(metaIsTwoFactorEnabled.getValue())) {
                data.put("twofactor-enabled", "true");
            } else {
                data.put("twofactor-enabled", "false");
            }
            MetaData metaTwoFactorUserId = user.getMetaDataByKey("twofactor.userid");
            if (metaTwoFactorUserId != null && !metaTwoFactorUserId.isDeleted() && StringUtil.isValid(metaTwoFactorUserId.getValue())) {
                data.put("twofactor-userid", metaTwoFactorUserId.getValue());
            }
            for (MetaData meta : user.getMetadata()) {
                if (meta.getKey().contains(":")) continue;
                data.put("meta." + meta.getKey(), meta.getValue());
            }
            this.queryPostOpen(user, context, data);
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        try {
            SelfServicePrincipal principal = this.getPrincipal(context);
            User user = UserService.getUser(principal.getUserId());
            Element el = user.getXml();
            Element root = this.dataroot.addElement("profile");
            String twoFactor = SelfServiceEngine.getConfig("security.twofactor.enabled");
            if (twoFactor != null && "true".equals(twoFactor)) {
                root.addAttribute("twofactor", "true");
            } else {
                root.addAttribute("twofactor", "false");
            }
            root.add(el);
            Element elStatic = this.dataroot.addElement("communications");
            for (User.Communications c : this.getCommunicationMethods()) {
                Element elc = elStatic.addElement("item");
                elc.setText(this.resourceBundle.getString("pro.comm." + c.toString().toLowerCase()));
                elc.addAttribute("key", c.toString());
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected void doPreSave(User user, WebContext context, Form data) throws BirdException {
    }

    protected void doPostSave(User user, WebContext context, Form data) throws BirdException {
    }

    protected void queryPostOpen(User user, WebContext context, Form data) throws BirdException {
    }

    private void deleteProfileImage(WebContext context, User user) throws BirdException {
        String metadataKey = "profileimage.id";
        MetaData md = user.getMetaDataByKey("profileimage.id");
        if (md != null) {
            String birdFileId = md.getValue();
            BirdFile bf = BirdUtil.getFile(context, birdFileId);
            if (bf != null) {
                bf.delete();
            }
            md.setDeleted(true);
            md.setDirty(true);
        }
        user.setProfileImage(null);
    }

    private void processProfileImage(WebContext context, Form data, InputStream in, User user) throws BirdException {
        try {
            BirdFile bf;
            String uploadField = "profile-upload";
            String metadataKey = "profileimage.id";
            int imageSize = 140;
            byte[] imageBytes = BirdUtil.resizeImage(in, 140);
            ByteArrayInputStreamEx bis = new ByteArrayInputStreamEx(imageBytes);
            MetaData metaProfile = user.getMetaDataByKey("profileimage.id");
            if (metaProfile != null && (bf = BirdUtil.getFile(context, metaProfile.getValue())) != null) {
                bf.setBody((InputStream)bis);
                bf.setFilename(data.getFilename("profile-upload"));
                bf.save();
                return;
            }
            String name = "profile-" + user.getUsername();
            String filename = this.createFilename(data.getFilename("profile-upload"));
            String fileId = BirdUtil.createFile(context, (InputStream)bis, name, filename, true);
            MetaData md = user.getMetaDataByKey("profileimage.id");
            if (md != null) {
                md.setValue(fileId);
                md.setDirty(true);
            } else {
                md = new MetaData();
                md.setKey("profileimage.id");
                md.setValue(fileId);
                user.getMetadata().add(md);
            }
            String profileImage = "files/" + name + "/" + filename;
            user.setProfileImage(profileImage);
            data.put("profile-image", profileImage);
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new BirdException((Exception)ex);
            }
        }
    }

    private final User.Communications[] getCommunicationMethods() {
        String list = SelfServiceEngine.getConfig("web.communications");
        if (list != null && !"".equals(list)) {
            Vector items = Util.split((String)list.trim().toUpperCase(), (String)",");
            Vector<User.Communications> newList = new Vector<User.Communications>();
            newList.add(User.Communications.NONE);
            Enumeration e = items.elements();
            while (e.hasMoreElements()) {
                String key = ((String)e.nextElement()).toUpperCase().trim();
                try {
                    newList.add(User.Communications.valueOf(key));
                }
                catch (Exception ex) {
                    log.warn("Invalid Communication entry in config: " + key);
                }
            }
            User.Communications[] cList = new User.Communications[newList.size()];
            for (int i = 0; i < newList.size(); ++i) {
                cList[i] = (User.Communications)((Object)newList.get(i));
            }
            return cList;
        }
        return User.Communications.values();
    }

    private String createFilename(String filename) {
        String name = UID.getUID().substring(0, 6);
        if (filename.lastIndexOf(".") > 0) {
            name = name + filename.substring(filename.lastIndexOf("."));
        }
        return name;
    }
}

