/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.List;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.MessageService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class InboxPage
extends BasePage {
    public static final String pageName = "inbox.html";
    private static final int FALLBACK_RECORDS_PER_PAGE = 15;

    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            String userId = this.getPrincipal(context).getUserId();
            List<Message> list = MessageService.getMessages(userId);
            BaseDocumentUtil.removeDeletedDocuments(list);
            boolean showAll = "all".equalsIgnoreCase(context.getRequest().getParameter("view"));
            if (!showAll) {
                int recordsPerPage = this.getRecordCountPerPage();
                if (list.size() > 0 && list.size() > recordsPerPage) {
                    int pagerSize;
                    int totalRecords = list.size();
                    int currentPage = this.getPageNumber(context);
                    if (currentPage > (pagerSize = this.getPagerSize(totalRecords, recordsPerPage))) {
                        currentPage = 1;
                    }
                    list = this.getPagedList(list, currentPage, recordsPerPage);
                    this.createPager(totalRecords, currentPage, recordsPerPage, pagerSize, list.size());
                }
            }
            Element el = this.dataroot.addElement("messages");
            this.showList(el, list);
            MessageService.markAllMessagesRead(userId);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }

    protected List<Message> getPagedList(List<Message> list, int page, int recordsPerPage) {
        int endPos;
        int startPos = (page - 1) * recordsPerPage;
        if (startPos > list.size()) {
            startPos = 0;
        }
        if ((endPos = startPos + recordsPerPage) > list.size()) {
            endPos = list.size();
        }
        return list.subList(startPos, endPos);
    }

    protected void createPager(int totalRecords, int currentPage, int recordsPerPage, int pagerSize, int currentRecordCount) {
        Element el = this.dataroot.addElement("pager");
        el.addAttribute("page", String.valueOf(currentPage));
        el.addAttribute("total", String.valueOf(totalRecords));
        el.addAttribute("perpage", String.valueOf(recordsPerPage));
        el.addAttribute("size", String.valueOf(pagerSize));
        int startPos = (currentPage - 1) * recordsPerPage;
        if (startPos > totalRecords) {
            startPos = 0;
        }
        int endPos = startPos + currentRecordCount;
        el.addAttribute("start", String.valueOf(startPos + 1));
        el.addAttribute("end", String.valueOf(endPos));
        for (int i = 1; i <= pagerSize; ++i) {
            el.addElement("page").setText(String.valueOf(i));
        }
    }

    protected final int getPagerSize(int totalRecords, int recordsPerPage) {
        int pages = totalRecords / recordsPerPage;
        if (totalRecords % recordsPerPage != 0) {
            ++pages;
        }
        return pages;
    }

    protected final int getPageNumber(WebContext context) {
        String s = context.getRequest().getParameter("page");
        int pageNumber = 1;
        if (StringUtil.isValid(s)) {
            try {
                pageNumber = Integer.parseInt(s);
                if (pageNumber < 1) {
                    pageNumber = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pageNumber;
    }

    protected final int getRecordCountPerPage() {
        int pagerSize = 15;
        String sCount = SelfServiceEngine.getConfig("web.viewcount.messages");
        if (StringUtil.isValid(sCount)) {
            try {
                pagerSize = Integer.parseInt(sCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pagerSize;
    }
}

