/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.IFormTemplateRenderer;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.CheckoutTicket;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SignedFormDocument;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.DocumentSecurityException;
import net.gopro.selfservice.exceptions.FormDeadlineException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.exceptions.VirusScannerException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.TaskService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.CollaborationHelper;
import net.gopro.selfservice.util.DocumentSecurityUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.ModuleHelper;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;
import org.dom4j.Node;

public class ApplicationPage
extends BasePage {
    public static final String pageName = "application.html";
    private static final boolean isSigningEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("goproforms.x509.signing"));
    private static final boolean isPaymentEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("goproforms.payments"));
    private static final boolean isTasksEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("tasks.enabled"));
    private static final boolean isSharingEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("goproforms.sharing")) && ModuleHelper.isValidLicense("Collaboration Module");

    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            String documentId = context.getRequest().getParameter("id");
            if (StringUtil.isValid(documentId)) {
                boolean isNewFormTemplate;
                boolean bl = isNewFormTemplate = documentId.length() == 6;
                if (isNewFormTemplate) {
                    this.renderFormTemplate(context, documentId);
                } else {
                    this.renderApplication(context, documentId);
                }
                this.dataroot.addAttribute("client-signature", String.valueOf(isSigningEnabled));
                this.dataroot.addAttribute("sharing-enabled", String.valueOf(isSharingEnabled));
                this.dataroot.addAttribute("tasks-enabled", String.valueOf(isTasksEnabled));
            } else {
                this.redirect(context, "applications.html");
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (DocumentSecurityException ex) {
            log.warn(ex.getMessage());
            this.redirect(context, "mycases.html");
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSave(WebContext context, Form data) throws BirdException {
        block13: {
            try {
                String formId = data.getID();
                IFormTemplateRenderer.FormStatus status = this.getFormStatus(data);
                if (StringUtil.isValid(formId) && formId.length() == 6) {
                    Organization org;
                    FormTemplate ft = FormService.getFormTemplateByToken(formId);
                    if (ft != null && (org = ft.getOrganizationByLinkToken(formId)) != null) {
                        IFormTemplateRenderer renderer = ft.getFormRenderEngine();
                        renderer.doSave(context, data, ft, org, status);
                    }
                    break block13;
                }
                if (!StringUtil.isValid(formId)) break block13;
                ApplicationPage applicationPage = this;
                synchronized (applicationPage) {
                    ExternalDocument doc = CaseService.getExternalDocument(formId, true);
                    if (doc != null && doc instanceof ApplicationForm) {
                        if (doc.isSent()) {
                            throw new CaseException("Case cannot be updated, it has already been sent.");
                        }
                        FormTemplate ft = FormService.getFormTemplate(((ApplicationForm)doc).getFormtemplateId(), false);
                        IFormTemplateRenderer renderer = ft.getFormRenderEngine();
                        renderer.doSave(context, data, (ApplicationForm)doc, status);
                    }
                }
            }
            catch (VirusScannerException ex) {
                ex.printStackTrace();
                data.setError(ex.getMessage());
            }
            catch (SelfServiceException ex) {
                throw new BirdException((Exception)ex);
            }
            catch (SaveConflictException ex) {
                ex.printStackTrace();
            }
            catch (FormDeadlineException ex) {
                data.setError(ex.getMessage());
            }
            catch (CaseException ex) {
                data.setError(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            String parentId = context.getRequest().getParameter("pid");
            if (parentId != null) {
                BaseCase bc = CaseService.getCase(parentId);
                if (bc != null) {
                    data.put("parent_id", parentId);
                } else {
                    this.redirect(context, "mycases.html");
                    return false;
                }
            }
            return super.queryOpen(context, data);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public boolean querySave(WebContext context, Form data) throws BirdException {
        String formId = data.getID();
        IFormTemplateRenderer.FormStatus status = this.getFormStatus(data);
        FormTemplate ft = null;
        try {
            ExternalDocument doc;
            if (StringUtil.isValid(formId) && formId.length() == 6) {
                ft = FormService.getFormTemplateByToken(formId);
                if (ft != null && IFormTemplateRenderer.FormStatus.SEND.equals((Object)status) && ft.getExtendedData() != null && ft.getExtendedData().getFormFeeAmount() > 0.0) {
                    data.setError("This application requires payment before it is submitted.  Save the application to continue.");
                    return false;
                }
            } else if (StringUtil.isValid(formId) && (doc = CaseService.getExternalDocument(formId, true)) != null && doc instanceof ApplicationForm) {
                MetaData metaPaymentStamp;
                ft = FormService.getFormTemplate(((ApplicationForm)doc).getFormtemplateId(), false);
                CheckoutTicket ticket = doc.getCheckoutTicket();
                if (ticket != null && ticket.isCheckedOut()) {
                    User currentUser = this.getCurrentUser(context);
                    if (!ticket.getUserId().equals(currentUser.getId())) {
                        data.setError("You cannot save an application which is checked out by another user.");
                        return false;
                    }
                }
                BaseCase bc = CaseService.getCase(doc.getCaseId());
                if (ticket == null && bc.isCheckOutRequired()) {
                    data.setError("You cannot save an application which has not been checked out!");
                    return false;
                }
                if (ft != null && IFormTemplateRenderer.FormStatus.SEND.equals((Object)status) && ft.getExtendedData() != null && ft.getExtendedData().getFormFeeAmount() > 0.0 && (metaPaymentStamp = doc.getMetaDataByKey("payment.stamp")) == null) {
                    data.setError("This application requires payment.  Please finish payment before you try to submit the application.");
                    return false;
                }
            }
            if (ft != null && IFormTemplateRenderer.FormStatus.SEND.equals((Object)status) && !ft.isWithinDateRestriction()) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
                data.setError(rb.getString("form.expired"));
                return false;
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private void renderFormTemplate(WebContext context, String idToken) throws SelfServiceException, BirdException {
        FormTemplate ft = FormService.getFormTemplateByToken(idToken);
        User currentUser = this.getCurrentUser(context);
        boolean isTargetGroupRestricted = false;
        boolean isInAudienceGroup = true;
        if (ft != null) {
            FormTemplate.Restriction restriction;
            FormTemplateExtras fex = ft.getExtendedData();
            if (fex != null && StringUtil.isValid(fex.getTargetGroupId()) && !currentUser.isInTargetGroup(fex.getTargetGroupId())) {
                isTargetGroupRestricted = true;
            }
            if (fex != null) {
                this.dataroot.addAttribute("payment-required", fex.getFormFeeAmount() > 0.0 ? "true" : "false");
            }
            if ((restriction = ft.getRestriction()) != null && FormTemplate.Restriction.CONTACT.equals((Object)restriction) && !currentUser.isContact()) {
                isInAudienceGroup = false;
            }
            this.dataroot.addAttribute("is-signature-required", String.valueOf(ft.isSignatureRequired()));
        }
        this.dataroot.addAttribute("is-submit-enabled", String.valueOf(Boolean.TRUE));
        if (ft != null && ft.isWithinDateRestriction() && !isTargetGroupRestricted && isInAudienceGroup) {
            Organization organization = ft.getOrganizationByLinkToken(idToken);
            if (organization != null) {
                IFormTemplateRenderer renderer = ft.getFormRenderEngine();
                renderer.doRender(context, this.dataroot, ft, organization);
            }
        } else {
            context.setRedirectURL("applications.html");
        }
    }

    private IFormTemplateRenderer.FormStatus getFormStatus(Form data) {
        if (data.contains("form_action")) {
            String action = data.getString("form_action");
            if ("send".equals(action)) {
                return IFormTemplateRenderer.FormStatus.SEND;
            }
            if ("save".equals(action)) {
                return IFormTemplateRenderer.FormStatus.SAVE;
            }
            if ("saveclose".equals(action)) {
                return IFormTemplateRenderer.FormStatus.SAVE_AND_CLOSE;
            }
            if ("savecheckin".equals(action)) {
                return IFormTemplateRenderer.FormStatus.SAVE_AND_CHECKIN;
            }
        }
        return IFormTemplateRenderer.FormStatus.SAVE;
    }

    private void renderApplication(WebContext context, String documentId) throws SelfServiceException, DocumentSecurityException, BirdException {
        SubDocument doc = CaseService.getSubDocument(documentId, true);
        if (doc != null && !doc.isDeleted() && doc instanceof ApplicationForm) {
            SignedFormDocument signedDoc;
            User currentUser = this.getCurrentUser(context);
            ApplicationForm form = (ApplicationForm)doc;
            BaseCase bc = CaseService.getCase(form.getCaseId());
            try {
                DocumentSecurityUtil.validatePermission(bc, currentUser, AccessControl.Permission.READ);
            }
            catch (DocumentSecurityException ex) {
                AuditLogEntry entry = new AuditLogEntry(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS);
                LogService.createLogEntry(entry);
                throw ex;
            }
            this.dataroot.add(bc.getXml());
            FormTemplate ft = FormService.getFormTemplate(form.getFormtemplateId(), false);
            IFormTemplateRenderer renderer = ft.getFormRenderEngine();
            renderer.doRender(context, this.dataroot, form);
            Node templateNode = this.dataroot.selectSingleNode("template");
            if (templateNode != null) {
                Organization org = ConfigService.getOrganization(bc.getOrganizationId());
                ((Element)templateNode).add(org.getXml());
            }
            List<SubDocument> subDocuments = CaseService.getCaseDocuments(form.getCaseId(), false);
            BaseDocumentUtil.removeDeletedDocuments(subDocuments);
            Element elSub = this.dataroot.addElement("subdocuments");
            for (SubDocument subDoc : subDocuments) {
                if (subDoc instanceof ApplicationForm) continue;
                elSub.add(subDoc.getXml());
            }
            if (isTasksEnabled) {
                Element elTasks = this.dataroot.addElement("tasks");
                List<Task> tasks = TaskService.getTasksByParentDocument(form.getCaseId());
                super.showList(elTasks, tasks);
            }
            if (bc instanceof FormCase && bc.isSent() && bc.isSigned() && (signedDoc = ((FormCase)bc).getSignedFormDocument()) != null) {
                signedDoc = (SignedFormDocument)CaseService.getExternalDocument(signedDoc.getId(), true);
                try {
                    this.dataroot.add(signedDoc.getCertificateDataAsXml());
                }
                catch (CertificateException ex) {
                    SelfServiceEngine.getLogger().error((Exception)ex);
                }
            }
            boolean isEditable = this.isEditEnabled((FormCase)bc, form, currentUser);
            this.dataroot.addAttribute("edit", String.valueOf(isEditable));
            CheckoutTicket ticket = form.getCheckoutTicket();
            if (ticket != null) {
                if (ticket.isCheckedOut() && currentUser.getId().equals(ticket.getUserId())) {
                    this.dataroot.addAttribute("is-checkedout", String.valueOf(Boolean.TRUE));
                    this.dataroot.addAttribute("checkout-required", String.valueOf(Boolean.FALSE));
                } else {
                    this.dataroot.addAttribute("is-checkedout", String.valueOf(Boolean.TRUE));
                    this.dataroot.addAttribute("checkout-required", String.valueOf(Boolean.TRUE));
                    if (ticket.getCheckedOutByUser() != null) {
                        this.dataroot.addAttribute("checkout-by", ticket.getCheckedOutByUser());
                    }
                }
            } else {
                this.dataroot.addAttribute("is-checkedout", String.valueOf(Boolean.FALSE));
                this.dataroot.addAttribute("checkout-required", String.valueOf(bc.isCheckOutRequired()));
            }
            if (isPaymentEnabled && ft.getExtendedData() != null) {
                this.dataroot.addAttribute("payment-required", ft.getExtendedData().getFormFeeAmount() > 0.0 ? "true" : "false");
                MetaData metaPayment = form.getMetaDataByKey("payment.stamp");
                if (metaPayment != null) {
                    this.dataroot.addAttribute("payment-completed", "true");
                }
            }
            this.dataroot.addAttribute("is-submit-enabled", String.valueOf(this.isSubmitEnabled((FormCase)bc, currentUser)));
            this.dataroot.addAttribute("is-signature-required", String.valueOf(ft.isSignatureRequired()));
        } else {
            this.redirect(context, "mycases.html");
        }
    }

    protected boolean isEditEnabled(FormCase fc, ApplicationForm form, User currentUser) {
        if (!DocumentSecurityUtil.getDocumentPermission(AccessControl.Permission.WRITE, currentUser, form)) {
            return false;
        }
        if (currentUser.isInRole("A2AAC04696D89CBC6C56EF934F892410")) {
            return true;
        }
        if (fc.isCompanyCase()) {
            return true;
        }
        boolean isOwnerUser = form.getCreatedById().equals(currentUser.getId());
        if (isOwnerUser) {
            return true;
        }
        if (!fc.isShared() && !isOwnerUser) {
            return false;
        }
        CollaborationHelper helper = new CollaborationHelper(fc);
        return !fc.isShared() || helper.isCollaborationUser(currentUser.getId());
    }

    protected boolean isSubmitEnabled(FormCase fc, User currentUser) {
        if (fc.isShared() && !fc.getCreatedById().equals(currentUser.getId())) {
            for (MetaData meta : fc.getMetadata()) {
                if (meta.isDeleted() || !"collaboration.submit".equals(meta.getKey()) || !currentUser.getId().equals(meta.getUserId())) continue;
                return Boolean.valueOf(meta.getValue());
            }
            return false;
        }
        return true;
    }
}

