/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.bird.licence.LicenceService;
import is.hugvit.io.ByteArrayInputStreamEx;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.IPDFSigningProvider;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.exceptions.OrganizationException;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.BirdUtil;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.ModuleHelper;
import net.gopro.selfservice.util.SignatureUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebOrganization
extends WebForm {
    public WebOrganization() {
        this.add(new Field("name", true));
        this.add(new Field("alias", true));
        this.add(new Field("cssfile"));
        this.add(new Field("footer"));
        this.add(new Field("logo", 6));
        this.add(new Field("is-logo", 2));
        this.add(new Field("logo-path"));
        this.add(new Field("is-enabled", 2));
        this.add(new Field("is-remote", 2));
        this.add(new Field("is-service-account", 2));
        this.add(new Field("service-email"));
        this.add(new Field("ApplicationConfirmation", 2));
        this.add(new Field("CaseStatusUpdates", 2));
        this.add(new Field("NewCaseDocuments", 2));
        this.add(new Field("CaseReminders", 2));
        this.add(new Field("ContactNotifications", 2));
        this.add(new Field("TaskReminders", 2));
        this.add(new Field("customclass"));
        this.add(new Field("is-signing", 2));
        this.add(new Field("contains-certificate", 2));
        this.add(new Field("certificate", 6));
        this.add(new Field("certkey"));
        this.add(new Field("servertype", true));
        this.add(new Field("hostname", true));
        this.add(new Field("username"));
        this.add(new Field("password"));
        this.add(new Field("broker-destination-id"));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            Organization o = null;
            if (data.isCreate()) {
                o = new Organization();
            } else if (data.isEdit()) {
                o = ConfigService.getOrganization(data.getID());
            }
            if ((data.isCreate() || data.isEdit()) && o != null) {
                Endpoint ep;
                o.setSubject(data.getString("name"));
                o.setAlias(data.getString("alias"));
                o.setCssFile(data.getString("cssfile", null));
                o.setFooter(data.getString("footer", null));
                o.setEnabled(data.getBoolean("is-enabled"));
                o.setRemoteTemplatesEnabled(data.getBoolean("is-remote"));
                o.setServiceAccountEnabled(data.getBoolean("is-service-account"));
                o.setServiceAccountEmail(data.getString("service-email"));
                o.setCustomClass(data.getString("customclass"));
                InputStream in = data.getInputStream("logo");
                if (in != null) {
                    this.processFileLogo(context, data, in, o);
                }
                boolean existingCertificate = data.getBoolean("contains-certificate");
                o.setSigning(data.getBoolean("is-signing"));
                if (!existingCertificate && o.isSigning()) {
                    InputStream cin = data.getInputStream("certificate");
                    o.setCertificate(IOUtils.toByteArray((InputStream)cin));
                    String cryptKey = SelfServiceEngine.getConfig("crypto.secret");
                    String certKey = SignatureUtil.encryptString(data.getString("certkey"), cryptKey);
                    o.setCertificateKey(certKey);
                }
                if ((ep = o.getEndpoint()) == null) {
                    ep = new Endpoint();
                }
                RemoteGoPro.GoPro goproType = RemoteGoPro.GoPro.valueOf(data.getString("servertype"));
                ep.setGoproType(goproType);
                ep.setHostname(data.getString("hostname"));
                ep.setUsername(data.getString("username", null));
                ep.setPassword(data.getString("password", null));
                ep.setBrokerDestinationId(data.getString("broker-destination", null));
                if (goproType.equals((Object)RemoteGoPro.GoPro.GOPRO_BROKER)) {
                    ep.setBrokerDestinationId(data.getString("broker-destination-id", null));
                }
                o.setEndpoint(ep);
                int mailOptions = 0;
                if (data.getBoolean("ApplicationConfirmation")) {
                    mailOptions += Organization.MailPreference.ApplicationConfirmation.getValue();
                }
                if (data.getBoolean("CaseStatusUpdates")) {
                    mailOptions += Organization.MailPreference.CaseStatusUpdates.getValue();
                }
                if (data.getBoolean("NewCaseDocuments")) {
                    mailOptions += Organization.MailPreference.NewCaseDocuments.getValue();
                }
                if (data.getBoolean("CaseReminders")) {
                    mailOptions += Organization.MailPreference.CaseReminders.getValue();
                }
                if (data.getBoolean("ContactNotifications")) {
                    mailOptions += Organization.MailPreference.ContactNotifications.getValue();
                }
                if (data.getBoolean("TaskReminders")) {
                    mailOptions += Organization.MailPreference.TaskReminders.getValue();
                }
                o.setMailOptions(mailOptions);
                if (data.isCreate()) {
                    ConfigService.createOrganization(o);
                } else if (data.isEdit()) {
                    ConfigService.updateOrganization(o);
                }
            }
            context.setRedirectPage("ss:organizationlist");
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (OrganizationException ex) {
            data.setError(ex.getMessage());
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        String action = context.getRequest().getParameter("do");
        String organizationId = context.getRequest().getParameter("id");
        try {
            if ("deletecertificate".equals(action)) {
                Organization org = ConfigService.getOrganization(organizationId);
                if (org != null) {
                    org.setSigning(false);
                    org.setCertificate(null);
                    org.setCertificateKey(null);
                    ConfigService.updateOrganization(org);
                    context.setRedirectPage("ss:organization", "edit&id=" + organizationId);
                }
            } else if ("deleteimage".equals(action)) {
                MetaData md;
                Organization org = ConfigService.getOrganization(organizationId);
                if (org != null && (md = org.getMetaDataByKey("image.id")) != null) {
                    BirdFile bf = BirdUtil.getFile(context, md.getValue());
                    if (bf != null) {
                        bf.delete();
                    }
                    md.setDeleted(true);
                    md.setDirty(true);
                    ConfigService.updateOrganization(org);
                    context.setRedirectPage("ss:organization", "edit&id=" + organizationId);
                }
            } else if ("form-builder-file".equals(action)) {
                this.generateFormBuilderConnectionFile(organizationId, context);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (OrganizationException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isOpen() || data.isEdit()) {
                Organization org = ConfigService.getOrganization(data.getID());
                if (org != null) {
                    Endpoint ep;
                    BirdFile bf;
                    data.put("name", org.getSubject());
                    data.put("alias", org.getAlias());
                    data.put("cssfile", org.getCssFile());
                    data.put("footer", org.getFooter());
                    data.put("is-signing", (Object)org.isSigning());
                    data.put("is-enabled", (Object)org.isEnabled());
                    data.put("is-remote", (Object)org.isRemoteTemplatesEnabled());
                    data.put("is-service-account", (Object)org.isServiceAccountEnabled());
                    data.put("service-email", org.getServiceAccountEmail());
                    data.put("customclass", org.getCustomClass());
                    data.put("ApplicationConfirmation", (Object)org.isMailOptionEnabled(Organization.MailPreference.ApplicationConfirmation));
                    data.put("CaseStatusUpdates", (Object)org.isMailOptionEnabled(Organization.MailPreference.CaseStatusUpdates));
                    data.put("NewCaseDocuments", (Object)org.isMailOptionEnabled(Organization.MailPreference.NewCaseDocuments));
                    data.put("CaseReminders", (Object)org.isMailOptionEnabled(Organization.MailPreference.CaseReminders));
                    data.put("ContactNotifications", (Object)org.isMailOptionEnabled(Organization.MailPreference.ContactNotifications));
                    data.put("TaskReminders", (Object)org.isMailOptionEnabled(Organization.MailPreference.TaskReminders));
                    if (org.isSigning()) {
                        data.put("certkey", org.getCertificateKey());
                    }
                    if (org.isSigning() || org.getCertificate() != null && org.getCertificateKey() != null) {
                        data.put("contains-certificate", (Object)true);
                    } else {
                        data.put("contains-certificate", (Object)false);
                    }
                    MetaData mLogo = org.getMetaDataByKey("image.id");
                    boolean isLogo = mLogo != null;
                    data.put("is-logo", (Object)isLogo);
                    if (isLogo && (bf = BirdUtil.getFile(context, mLogo.getValue())) != null) {
                        String imagePath = context.getRequest().getContextPath() + "/web/files/" + bf.getName() + "/" + bf.getFilename();
                        data.put("logo-path", imagePath);
                    }
                    if ((ep = org.getEndpoint()) != null) {
                        data.put("servertype", ep.getGoproType().toString());
                        data.put("hostname", ep.getHostname());
                        data.put("username", ep.getUsername());
                        data.put("password", ep.getPassword());
                        data.put("broker-destination", ep.getBrokerDestinationId());
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        block9: {
            String[] booleanKeys;
            for (String key : booleanKeys = new String[]{"is-logo", "is-enabled", "is-remote", "is-service-account", "ApplicationConfirmation", "CaseStatusUpdates", "NewCaseDocuments", "CaseReminders", "TaskReminders", "ContactNotifications", "is-signing", "contains-certificate"}) {
                data.put(key, (Object)data.getBoolean(key));
            }
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
            if (data.getString("name").equals("")) {
                data.setError(rb.getString("org.name"));
                return false;
            }
            if (data.getString("alias").equals("")) {
                data.setError(rb.getString("org.alias"));
                return false;
            }
            if (data.getBoolean("is-service-account") && !StringUtil.isValidEmail(data.getString("service-email"))) {
                data.setError(rb.getString("org.email"));
                return false;
            }
            try {
                boolean existingCertificate = data.getBoolean("contains-certificate");
                if (existingCertificate || !data.getBoolean("is-signing")) break block9;
                InputStream in = data.getInputStream("certificate");
                if (in == null || in.available() == 0) {
                    data.setError("Signature file must be included");
                    return false;
                }
                try {
                    SignatureUtil.validateCertificate(in, data.getString("certkey"));
                }
                catch (SelfServiceException ex) {
                    data.setError("Error with Certificate: " + ex.getMessage());
                    return false;
                }
            }
            catch (IOException ex) {
                throw new BirdException((Exception)ex);
            }
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        String brokerClientId;
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        for (RemoteGoPro.GoPro gp : RemoteGoPro.GoPro.values()) {
            Element dsEl = el.addElement("datastore");
            dsEl.addAttribute("id", gp.toString());
            dsEl.addElement("name").setText(RemoteGoPro.getDataStoreTitle(gp));
        }
        List<String> cssfiles = BirdUtil.getCustomFiles(context, "css");
        if (cssfiles.size() > 0) {
            Element elCss = el.addElement("birdfiles");
            for (String cssfile : cssfiles) {
                elCss.addElement("file").setText("files/" + cssfile);
            }
        }
        if ((brokerClientId = SelfServiceEngine.getConfig("broker.selfservice.id", null)) != null) {
            el.addElement("broker-client-id").setText(brokerClientId);
        }
        boolean isSigning = ModuleHelper.isClassAvailable(SelfServiceEngine.getConfig(IPDFSigningProvider.class.getName()));
        el.addElement("signing").setText(Boolean.toString(isSigning));
    }

    private void processFileLogo(WebContext context, Form data, InputStream in, Organization org) throws BirdException {
        try {
            BirdFile bf;
            int imageSize = 110;
            byte[] imageBytes = BirdUtil.resizeImage(in, 110);
            ByteArrayInputStreamEx bis = new ByteArrayInputStreamEx(imageBytes);
            MetaData mLogo = org.getMetaDataByKey("image.id");
            if (mLogo != null && (bf = BirdUtil.getFile(context, mLogo.getValue())) != null) {
                bf.setBody((InputStream)bis);
                bf.setFilename(data.getFilename("logo"));
                bf.save();
                return;
            }
            String name = "logo-" + org.getAlias();
            String fileId = BirdUtil.createFile(context, (InputStream)bis, name, data.getFilename("logo"), true);
            MetaData md = org.getMetaDataByKey("image.id");
            if (md != null) {
                md.setValue(fileId);
                md.setDirty(true);
            } else {
                md = new MetaData();
                md.setKey("image.id");
                md.setValue(fileId);
                org.getMetadata().add(md);
            }
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new BirdException((Exception)ex);
            }
        }
    }

    private void generateFormBuilderConnectionFile(String organizationId, WebContext context) throws BirdException {
        try {
            Organization org = ConfigService.getOrganization(organizationId);
            if (org != null) {
                Element root = DocumentHelper.createElement((String)"gopro");
                Document doc = DocumentHelper.createDocument((Element)root);
                String privateKey = LicenceService.getServerId() + "_G0$Pro#.S3lf";
                String remotePasskey = SignatureUtil.encryptString(org.getId(), privateKey);
                root.addAttribute("id", org.getId());
                root.addElement("name").setText(org.getSubject());
                root.addElement("alias").setText(org.getAlias());
                root.addElement("token").setText(remotePasskey);
                root.addElement("created").setText(LocaleUtil.formatDate(Calendar.getInstance().getTimeInMillis()));
                Element el = root.addElement("selfservice");
                el.addElement("title").setText(SelfServiceEngine.getConfig("web.title"));
                Dom4JUtil.addElement(el, "webmaster", SelfServiceEngine.getConfig("web.webmaster"));
                String endpoint = SelfServiceEngine.getConfig("web.domain");
                if (!endpoint.endsWith("/")) {
                    endpoint = endpoint + "/";
                }
                endpoint = endpoint + "services/FormTemplateService";
                el.addElement("endpoint").setText(endpoint);
                el.addElement("wsdl").setText(endpoint + "?wsdl");
                byte[] file = doc.asXML().getBytes("UTF-8");
                String filename = "gopro-ss-" + org.getSubject() + ".xml";
                HttpServletResponse response = context.getResponseExclusive();
                response.setContentLength(file.length);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "private, max-age=15");
                response.getOutputStream().write(file);
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
        catch (SocketException org) {
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

