/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.StatusList;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.exceptions.ConfigException;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class WebList
extends WebForm {
    public WebList() {
        this.add(new Field("name", true));
        this.add(new Field("description"));
        this.add(new Field("default_id"));
        this.add(new Field("is_statuslist", 2));
        this.add(new Field("save_action"));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            List list = null;
            if (data.isCreate()) {
                list = new List();
            } else if (data.isEdit()) {
                list = ConfigService.getList(data.getID());
            }
            if ((data.isCreate() || data.isEdit()) && list != null && list != null) {
                if ("00ED1DFEB2098F050000012274E564AF".equals(list.getId())) {
                    String defaultNotSubmitted = data.getString("default_not_submitted_id");
                    String defaultSubmitted = data.getString("default_submitted_id");
                    MetaData metaNotSubmitted = list.getMetaDataByKey("caselist.notsubmitted");
                    MetaData metaSubmitted = list.getMetaDataByKey("caselist.submitted");
                    if (metaNotSubmitted == null) {
                        metaNotSubmitted = new MetaData("caselist.notsubmitted", defaultNotSubmitted);
                        metaNotSubmitted.setReferenceId(list.getId());
                        list.getMetadata().add(metaNotSubmitted);
                    } else {
                        metaNotSubmitted.setValue(defaultNotSubmitted);
                        metaNotSubmitted.setDirty(true);
                    }
                    if (metaSubmitted == null) {
                        metaSubmitted = new MetaData("caselist.submitted", defaultSubmitted);
                        metaSubmitted.setReferenceId(list.getId());
                        list.getMetadata().add(metaSubmitted);
                    } else {
                        metaSubmitted.setValue(defaultSubmitted);
                        metaSubmitted.setDirty(true);
                    }
                }
                list.setSubject(data.getString("name"));
                list.setDescription(data.getString("description"));
                if (!"".equals(data.getString("default_id"))) {
                    list.setDefaultId(data.getString("default_id"));
                }
                if (data.isCreate()) {
                    ConfigService.createList(list);
                } else if (data.isEdit()) {
                    ConfigService.updateList(list);
                }
            }
            String saveaction = data.getString("save_action");
            if (data.isCreate()) {
                context.setRedirectPage("ss:list", "edit&id=" + list.getId());
            } else if (data.isEdit() && "save".equals(saveaction)) {
                context.setRedirectPage("ss:list", "edit&id=" + list.getId());
            } else if ("save-close".equals(saveaction)) {
                context.setRedirectPage("ss:lists");
            }
        }
        catch (ConfigException ex) {
            data.setError(ex.getMessage());
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        try {
            Element el = context.getRootElement().addElement("static");
            List list = ConfigService.getList(data.getID());
            if (list != null) {
                for (ListItem item : list.getListItems()) {
                    if (item.isDeleted()) continue;
                    el.add(item.getXml());
                }
            }
            for (StatusListItem.Status status : StatusListItem.Status.values()) {
                el.addElement("statustype").setText(status.toString());
            }
            if (list != null && "00ED1DFEB2098F050000012274E564AF".equals(list.getId())) {
                MetaData metaNotSubmitted = list.getMetaDataByKey("caselist.notsubmitted");
                MetaData metaSubmitted = list.getMetaDataByKey("caselist.submitted");
                if (metaNotSubmitted != null && StringUtil.isValid(metaNotSubmitted.getValue())) {
                    el.addElement("default_notsubmitted").setText(metaNotSubmitted.getValue());
                }
                if (metaSubmitted != null && StringUtil.isValid(metaSubmitted.getValue())) {
                    el.addElement("default_submitted").setText(metaSubmitted.getValue());
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isOpen() || data.isEdit()) {
                List list = ConfigService.getList(data.getID());
                if (list != null) {
                    data.put("name", list.getSubject());
                    data.put("description", list.getDescription());
                    data.put("default_id", list.getDefaultId());
                    data.put("is_statuslist", (Object)(list instanceof StatusList));
                    data.put("is_caselist", (Object)(list instanceof StatusList && "00ED1DFEB2098F050000012274E564AF".equals(list.getId()) ? 1 : 0));
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        if (data.getString("name").equals("")) {
            data.setError(rb.getString("list.name"));
            return false;
        }
        return true;
    }
}

