/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public class WebCompany
extends WebForm {
    public WebCompany() {
        this.add(new Field("name"));
        this.add(new Field("address"));
        this.add(new Field("city"));
        this.add(new Field("postcode"));
        this.add(new Field("state"));
        this.add(new Field("country"));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            Company com = null;
            if (data.isCreate()) {
                com = new Company();
            } else if (data.isEdit()) {
                com = UserService.getCompany(data.getID());
            }
            if ((data.isCreate() || data.isEdit()) && com != null) {
                if (data.isCreate()) {
                    com.setName(data.getString("name"));
                }
                Address address = null;
                if (data.isCreate()) {
                    address = new Address();
                    com.setAddress(address);
                } else {
                    address = com.getAddress();
                }
                address.setStreetName(data.getString("address", null));
                address.setCity(data.getString("city", null));
                address.setPostcode(data.getString("postcode", null));
                address.setState(data.getString("state", null));
                address.setCountry(data.getString("country", null));
                if (data.isCreate()) {
                    UserService.createCompany(com);
                } else if (data.isEdit()) {
                    UserService.updateCompany(com);
                }
            }
            context.setRedirectPage("ss:companylist");
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            data.setError(ex.getMessage());
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            Company com;
            if ((data.isOpen() || data.isEdit()) && (com = UserService.getCompany(data.getID())) != null) {
                data.put("name", com.getName());
                if (com.getAddress() != null) {
                    data.put("address", com.getAddress().getStreetName());
                    data.put("city", com.getAddress().getCity());
                    data.put("postcode", com.getAddress().getPostcode());
                    data.put("state", com.getAddress().getState());
                    data.put("country", com.getAddress().getCountry());
                }
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        String[] fields;
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        if ("".equals(data.getString("name"))) {
            data.setError(rb.getString("com.name"));
            return false;
        }
        for (String field : fields = new String[]{"address", "city", "country", "state"}) {
            if (!data.getString(field).equals("")) continue;
            String rbKey = "user." + field;
            data.setError(rb.getString(rbKey));
            return false;
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        try {
            Company com;
            if (data.isEdit() && (com = UserService.getCompany(data.getID())) != null) {
                for (User cu : com.getContacts()) {
                    el.add(cu.getXml());
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

