/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.excel.ExcelData;
import net.gopro.selfservice.excel.ExcelDataRow;
import net.gopro.selfservice.excel.ExcelWriter;
import net.gopro.selfservice.pages.admin.WebBaseList;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class WebCaseList
extends WebBaseList {
    @Override
    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        try {
            if (!this.isFilter()) {
                this.createSortedOrganizationList(null);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doFilter(WebContext context, String filter, String key) throws BirdException {
        String[] keydata = key.split("-");
        if (keydata.length == 2) {
            String templateId = keydata[0];
            String organizationId = keydata[1];
            this.getStaticElement().addAttribute("tid", templateId);
            this.getStaticElement().addAttribute("oid", organizationId);
            try {
                boolean isExcel;
                this.createSortedOrganizationList(organizationId);
                List<FormCase> caseList = CaseService.getCasesByFormTemplate(templateId);
                BaseDocumentUtil.removeDeletedDocuments(caseList);
                for (FormCase fc : caseList) {
                    if (!fc.getOrganizationId().equals(organizationId)) continue;
                    Element el = fc.getXml();
                    User user = UserService.getUser(fc.getCreatedById());
                    if (user != null) {
                        el.addElement("fullname").setText(user.getFullname());
                    }
                    this.getRootElement().add(el);
                }
                this.setSortKey("refnumber");
                String organizationName = "";
                String casetypeName = "";
                Organization o = ConfigService.getOrganization(organizationId);
                FormTemplate f = FormService.getFormTemplate(templateId, false);
                if (o != null) {
                    organizationName = o.getSubject();
                }
                if (f != null) {
                    casetypeName = f.getSubject();
                }
                String title = organizationName + " / " + casetypeName;
                this.getStaticElement().addElement("title").setText(title);
                boolean bl = isExcel = context.getRequest().getParameter("excel") != null;
                if (isExcel) {
                    ResourceBundle rb = LocaleUtil.getResourceBundle("admin.admin", context.getSession().getLocale());
                    ExcelData excel = new ExcelData(title);
                    excel.setSheetName(casetypeName);
                    ArrayList<ExcelDataRow> rl = new ArrayList<ExcelDataRow>();
                    rl.add(new ExcelDataRow("refnumber", rb.getString("list.casenumber")));
                    rl.add(new ExcelDataRow("casenumber", "GoPro " + rb.getString("list.casenumber")));
                    rl.add(new ExcelDataRow("fullname", rb.getString("list.owner")));
                    rl.add(new ExcelDataRow("subject", rb.getString("list.name")));
                    rl.add(new ExcelDataRow("created", rb.getString("list.created"), ExcelDataRow.RowType.DATE));
                    rl.add(new ExcelDataRow("modified", rb.getString("list.modified"), ExcelDataRow.RowType.DATE));
                    rl.add(new ExcelDataRow("status", rb.getString("list.status")));
                    List excelList = this.getRootElement().selectNodes("//case", "refnumber");
                    excel.loadFromXml(rl, excelList);
                    ExcelWriter.write(context, excel);
                }
            }
            catch (SelfServiceException ex) {
                throw new BirdException((Exception)ex);
            }
        }
    }

    @Override
    protected void doDelete(WebContext context, String documentId) throws BirdException {
    }

    private void createSortedOrganizationList(String templateId) throws SelfServiceException {
        List<Organization> orgList = ConfigService.getOrganizations();
        if (orgList != null && orgList.size() > 0) {
            for (Organization org : orgList) {
                List<FormTemplate> templateList = FormService.getFormTemplates(org.getId());
                if (templateList == null || templateList.size() <= 0) continue;
                Element el = this.getStaticElement().addElement("organization");
                el.addElement("name").setText(org.getSubject());
                el.addElement("id").setText(org.getId());
                Element templateEl = el.addElement("templates");
                for (FormTemplate ft : templateList) {
                    Element fel = ft.getXml();
                    if (ft.isDeleted()) {
                        fel.addAttribute("status", "deleted");
                    } else if (!ft.isVisible()) {
                        fel.addAttribute("status", "hidden");
                    } else {
                        fel.addAttribute("status", "visible");
                    }
                    fel.addElement("shorttitle").setText(StringUtil.shortenText(ft.getSubject(), 40));
                    if (templateId != null && ft.getId().equals(templateId)) {
                        fel.addAttribute("selected", "true");
                    }
                    templateEl.add(fel);
                }
            }
        }
    }
}

