/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Announcement;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.services.MessageService;
import net.gopro.selfservice.services.TargetgroupService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public class WebAnnouncement
extends WebForm {
    public WebAnnouncement() {
        this.add(new Field("targetgroup", 0, true));
        this.add(new Field("internal", 2));
        this.add(new Field("email", 2));
        this.add(new Field("sent", 2));
        this.add(new Field("title", 0, true));
        this.add(new Field("body", 0, true));
        this.add(new Field("hasgroups", 2));
        this.add(new Field("sendit", 2));
        this.add(new Field("company_id", 0));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            Announcement ann = null;
            if (data.isCreate()) {
                ann = new Announcement();
            } else if (data.isEdit()) {
                ann = MessageService.getAnnouncement(data.getID());
            }
            if (data.isCreate() || data.isEdit()) {
                ann.setSubject(data.getString("title"));
                ann.setBody(data.getString("body"));
                ann.setEmail(data.getBoolean("email"));
                ann.setInternal(data.getBoolean("internal"));
                boolean send = data.getBoolean("sendit");
                if (data.isCreate()) {
                    ann.setTargetGroupId(data.getString("targetgroup"));
                    MessageService.createAnnouncement(ann, send);
                } else if (data.isEdit()) {
                    if (!ann.isCompanyAnnouncement()) {
                        ann.setTargetGroupId(data.getString("targetgroup"));
                    }
                    MessageService.updateAnnouncement(ann, send);
                }
            }
            context.setRedirectPage("ss:announcementlist");
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (CommunicationException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (MessageException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            Announcement ann;
            if ((data.isOpen() || data.isEdit()) && (ann = MessageService.getAnnouncement(data.getID())) != null) {
                data.put("title", ann.getSubject());
                data.put("body", ann.getBody());
                data.put("internal", (Object)ann.isInternal());
                data.put("email", (Object)ann.isEmail());
                data.put("sent", (Object)ann.isSent());
                data.put("is_company", (Object)ann.isCompanyAnnouncement());
                data.put("targetgroup", ann.getTargetGroupId());
                if (ann.isCompanyAnnouncement()) {
                    TargetGroup tg = TargetgroupService.getTargetGroup(ann.getTargetGroupId(), false);
                    data.put("company_id", tg.getCompanyId());
                }
            }
            List<TargetGroup> tList = TargetgroupService.getTargetGroups();
            List<Company> companyList = UserService.getCompaniesWithContacts();
            BaseDocumentUtil.removeDeletedDocuments(tList);
            if (tList.isEmpty() && companyList.isEmpty()) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
                data.setError(rb.getString("ann.target"));
                data.put("hasgroups", (Object)false);
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        String[] booleanKeys;
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        for (String key : booleanKeys = new String[]{"internal", "email", "is_company"}) {
            data.put(key, (Object)data.getBoolean(key));
        }
        String targetAudienceId = data.getString("targetgroup");
        data.put("targetgroup", targetAudienceId);
        data.put("company_id", targetAudienceId);
        if (data.getString("title").equals("")) {
            data.setError(rb.getString("ann.title"));
            return false;
        }
        if (data.getString("body").equals("")) {
            data.setError(rb.getString("ann.body"));
            return false;
        }
        boolean isEmail = data.getBoolean("email");
        boolean isInternal = data.getBoolean("internal");
        if (!isEmail && !isInternal) {
            data.setError(rb.getString("ann.delivery"));
            return false;
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        try {
            Element el = context.getRootElement().addElement("static");
            List<TargetGroup> tgList = TargetgroupService.getTargetGroups();
            Iterator<TargetGroup> it = tgList.iterator();
            while (it.hasNext()) {
                TargetGroup group = it.next();
                if (!TargetGroup.Generator.CONTACTS.equals((Object)group.getGenerator())) continue;
                it.remove();
            }
            List<Company> companyList = UserService.getCompaniesWithContacts();
            if (data.isCreate()) {
                BaseDocumentUtil.removeDeletedDocuments(tgList);
            } else {
                Company com;
                TargetGroup group;
                Announcement ann = MessageService.getAnnouncement(data.getID());
                it = tgList.iterator();
                while (it.hasNext()) {
                    TargetGroup tg = it.next();
                    if (!tg.isDeleted() || tg.getId().equals(ann.getTargetGroupId())) continue;
                    it.remove();
                }
                if (ann.isCompanyAnnouncement() && (group = TargetgroupService.getTargetGroup(ann.getTargetGroupId(), false)).getCompanyId() != null && (com = UserService.getCompany(group.getCompanyId())) != null && (com.isDeleted() || com.getContacts().size() == 0)) {
                    companyList.add(com);
                }
            }
            for (TargetGroup tg : tgList) {
                el.add(tg.getXml());
            }
            for (Company com : companyList) {
                el.add(com.getXml());
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

