/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import is.hugvit.bird.WebContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.Principal;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.impl.renderers.GoProFormHelper;
import net.gopro.selfservice.impl.renderers.GoProFormRenderer;
import net.gopro.selfservice.impl.renderers.GoProFormV1Processor;
import net.gopro.selfservice.impl.renderers.IGoProFormProcessor;
import net.gopro.selfservice.pdf.FOPTransformer;
import net.gopro.selfservice.pdf.PDFProperties;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.FormQueryUtil;
import net.gopro.selfservice.util.SaxReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class GoProFormV1Renderer
extends GoProFormRenderer {
    @Override
    protected String transformDocument(WebContext context, FormTemplateFile xml, FormTemplateFile xsl) throws SelfServiceException {
        try {
            ByteArrayInputStream xmlFile = new ByteArrayInputStream(xml.getStream());
            StreamSource sXml = new StreamSource(xmlFile);
            StreamSource sXsl = null;
            if (this.overrideXsl()) {
                InputStream in = null;
                String targetLocation = null;
                targetLocation = xsl.getTag().equals((Object)FormTemplateFile.Tag.EDIT) ? "/WEB-INF/" + SelfServiceEngine.getConfig("goproforms.v1.xsl.edit") : "/WEB-INF/" + SelfServiceEngine.getConfig("goproforms.v1.xsl.read");
                in = context.getSession().getServletContext().getResourceAsStream(targetLocation);
                if (in == null) {
                    throw new SelfServiceException("The XSL template " + targetLocation + " is missing!");
                }
                sXsl = new StreamSource(in);
            } else {
                ByteArrayInputStream xslFile = new ByteArrayInputStream(xsl.getStream());
                sXsl = new StreamSource(xslFile);
            }
            StringWriter strWriter = new StringWriter();
            TransformerFactory tFactory = null;
            if (SelfServiceEngine.getBirdSession().getConfig().containsKey("xsl_class")) {
                try {
                    String className = (String)SelfServiceEngine.getBirdSession().getConfig().get("xsl_class");
                    tFactory = (TransformerFactory)Class.forName(className).newInstance();
                }
                catch (Exception ex) {
                    tFactory = TransformerFactory.newInstance();
                }
            } else {
                TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
            }
            Transformer transformer = tFactory.newTransformer(sXsl);
            transformer.transform(sXml, new StreamResult(strWriter));
            return strWriter.toString();
        }
        catch (Exception ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    protected byte[] transFormToPDF(PDFProperties properties, Document doc, FormTemplateExtras.XSLFoType fo) throws SelfServiceException {
        FOPTransformer trans = new FOPTransformer(properties);
        return trans.transFormToPDF(doc, fo, GoProFormTemplate.GoProFormType.GOPRO_FORM_V1);
    }

    @Override
    protected IGoProFormProcessor getFormProcessor() throws SelfServiceException {
        return new GoProFormV1Processor();
    }

    @Override
    protected void computeValues(WebContext context, FormTemplate ft, FormTemplateFile ff) throws SelfServiceException {
        try {
            Principal principal = context.getRequest().getUserPrincipal();
            User user = UserService.getUserByUsername(principal.getName());
            Company com = null;
            SAXReader reader = SaxReader.createReader();
            ByteArrayInputStream is = new ByteArrayInputStream(ff.getStream());
            Document doc = reader.read((InputStream)is);
            is.close();
            String xpathQuery = "//SECTIONS/SECTION/FIELDS//VALUE";
            List<Element> list = FormQueryUtil.selectNodes(doc, "//SECTIONS/SECTION/FIELDS//VALUE", false);
            if (list != null && list.size() > 0) {
                for (Element el : list) {
                    String val = el.getText();
                    if (val == null || !val.startsWith("[") || !val.endsWith("]")) continue;
                    String value = "";
                    if (val.toLowerCase().startsWith("[form.")) {
                        value = GoProFormHelper.getComputedValue(val, ft);
                    } else if (val.contains("COMPANY") && user.isContact()) {
                        if (com == null) {
                            com = UserService.getCompany(user.getContactCompanyIds().get(0));
                        }
                        if (com != null) {
                            value = GoProFormHelper.getComputedValue(val, com, GoProFormTemplate.GoProFormType.GOPRO_FORM_V1);
                        }
                    } else {
                        value = GoProFormHelper.getComputedValue(val, user, GoProFormTemplate.GoProFormType.GOPRO_FORM_V1);
                    }
                    if (value == null) {
                        value = "";
                    }
                    el.setText(value);
                }
                ff.setStream(doc.asXML().getBytes("UTF-8"));
            }
        }
        catch (DocumentException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UserException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SAXException ex) {
            throw new SelfServiceException(ex);
        }
    }
}

