/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.util.SaxReader;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class BaseGoProFormProcessor {
    protected static Logger logger = Logger.getLogger(BaseGoProFormProcessor.class);

    protected void sanitizeMapValues(Hashtable map) {
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = map.get(key);
            if (!(value instanceof String)) continue;
            value = StringUtil.stripNonValidXMLCharacters(StringUtil.stripHTML((String)value));
            map.put(key, value);
        }
    }

    protected final FormTemplateFile getTemplateDataFile(FormTemplate template) throws SelfServiceException {
        if (template == null) {
            throw new SelfServiceException("Form template is null");
        }
        FormTemplateFile dataFile = template.getFormTemplateFile(FormTemplateFile.Tag.DATA);
        if (dataFile == null) {
            throw new SelfServiceException("The formtemplate does not include a Data File.");
        }
        return dataFile;
    }

    protected final Document getDocumentFromTemplate(FormTemplateFile file) throws SelfServiceException {
        try {
            Document doc;
            ByteArrayInputStream in = null;
            SAXReader reader = SaxReader.createReader();
            try {
                in = new ByteArrayInputStream(file.getStream());
                doc = reader.read((InputStream)in);
            }
            catch (DocumentException ex) {
                throw new SelfServiceException((Exception)((Object)ex));
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    throw new SelfServiceException(ex);
                }
            }
            return doc;
        }
        catch (SAXException ex) {
            throw new SelfServiceException(ex);
        }
    }

    protected String extractFilename(Object[] objArray, int type) {
        String filename = null;
        if (objArray != null && type >= 0 && type <= 3) {
            filename = (String)objArray[type];
        }
        return filename;
    }

    protected String getFilename(Object value) {
        String filename = null;
        if (value instanceof Vector) {
            Vector vector = (Vector)value;
            for (Object element : vector) {
                Object[] objArray = (Object[])element;
                filename = this.extractFilename(objArray, 0);
            }
        } else {
            Object[] objArray = (Object[])value;
            filename = this.extractFilename(objArray, 0);
        }
        return filename;
    }
}

