/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import is.hugvit.bird.licence.Licence;
import is.hugvit.bird.licence.LicenceModule;
import is.hugvit.bird.licence.LicenceService;
import is.hugvit.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.IConfigEngine;
import net.gopro.selfservice.IQueueEngine;
import net.gopro.selfservice.IRegistrationFilter;
import net.gopro.selfservice.ISecurityEngine;
import net.gopro.selfservice.ITargetGroupEngine;
import net.gopro.selfservice.IUserEngine;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.UserDalc;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.RecoveryTicket;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.UserRole;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.data.gopro.GoProCompanyReference;
import net.gopro.selfservice.data.gopro.GoProContactReference;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.data.targetgroup.TargetGroupUser;
import net.gopro.selfservice.exceptions.AuthenticationException;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.RegistrationException;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.filters.UserFilter;
import net.gopro.selfservice.impl.BaseImpl;
import net.gopro.selfservice.util.AdminUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.PBKDF2PasswordUtil;
import net.gopro.selfservice.util.PasswordUtil;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.util.ThreadContext;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class UserImpl
extends BaseImpl
implements IUserEngine,
ISecurityEngine {
    private static final Logger logger = Logger.getLogger(UserImpl.class);
    protected IConfigEngine configEngine;
    protected ITargetGroupEngine targetgroupEngine;
    protected IQueueEngine queueEngine;
    protected UserDalc dalc;

    public UserImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.dalc = new UserDalc();
        this.configEngine = EngineFactory.getConfigEngine();
        this.targetgroupEngine = EngineFactory.getTargetGroupEngine();
        this.queueEngine = EngineFactory.getQueueEngine();
    }

    @Override
    public User getUser(String userId) throws SelfServiceException {
        try {
            User user = null;
            if (this.isValid(userId) && (user = this.dalc.getUser(userId)) != null) {
                user.getGoproClientReferences().addAll(this.dalc.getClientReferences(user.getId()));
                this.setMetaData(user, this.dalc, false);
                user.getTargetGroups().addAll(this.targetgroupEngine.getTargetGroupsByUser(user.getId()));
            }
            return user;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public User getUserByIdNumber(String idNumber) throws SelfServiceException {
        try {
            User user = null;
            if (this.isValid(idNumber) && (user = this.dalc.getUserByIdNumber(idNumber)) != null) {
                user.getGoproClientReferences().addAll(this.dalc.getClientReferences(user.getId()));
                this.setMetaData(user, this.dalc, false);
                user.getTargetGroups().addAll(this.targetgroupEngine.getTargetGroupsByUser(user.getId()));
            }
            return user;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createCompany(Company com) throws SelfServiceException {
        this.throwIfNull(com, "Company is null");
        try {
            this.throwIfNotValid(com.getName(), "The company name is missing");
            this.assertStringLength(com.getName(), 255);
            this.checkDocumentId(com);
            this.dalc.createCompany(com);
            this.createMetaData(com, this.dalc);
            this.logAction(com.getId(), AuditLogEntry.DataType.COMPANY, AuditLogEntry.Action.CREATE);
            for (GoProCompanyReference ref : com.getGoproCompanyReferences()) {
                ref.setCompanyId(com.getId());
                this.createGoProCompanyReference(ref);
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<Company> getCompanies() throws SelfServiceException {
        try {
            return this.dalc.getCompanies();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<Company> getCompaniesWithContacts() throws SelfServiceException {
        try {
            return this.dalc.getCompaniesWithContacts();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<Company> getCompaniesByOrganization(String organizationId) throws SelfServiceException {
        try {
            return this.dalc.getCompaniesByOrganization(organizationId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<Company> getCompaniesByAccountManager(String accountManagerId) throws SelfServiceException {
        try {
            ArrayList<Company> list = new ArrayList<Company>();
            User accountManager = this.getUser(accountManagerId);
            if (accountManager != null) {
                HashSet<String> companyIds = new HashSet<String>();
                if (accountManager.getContactList().size() > 0) {
                    for (Contact contact : accountManager.getContactList()) {
                        companyIds.add(contact.getCompanyId());
                    }
                }
                ArrayList<String> targetGroupIds = new ArrayList<String>();
                for (TargetGroup group : accountManager.getTargetGroups()) {
                    targetGroupIds.add(group.getId());
                }
                if (targetGroupIds.size() > 0) {
                    UserFilter userFilter = new UserFilter();
                    userFilter.setAccountManagerId(accountManagerId);
                    userFilter.setClientStatus(UserFilter.ClientStatus.ALL);
                    List<User> userList = this.dalc.getUsersByTargetGroup(userFilter, targetGroupIds);
                    for (User contactUser : userList) {
                        User u = this.getUser(contactUser.getId());
                        if (!u.isContact()) continue;
                        for (Contact con : u.getContactList()) {
                            companyIds.add(con.getCompanyId());
                        }
                    }
                }
                if (companyIds.size() > 0) {
                    list.addAll(this.dalc.getCompaniesByIds(companyIds));
                }
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Company getCompany(String companyId) throws UserException, SelfServiceException {
        try {
            Company com = this.dalc.getCompany(companyId);
            if (com != null) {
                com.getGoproCompanyReferences().addAll(this.dalc.getCompanyReferences(com.getId()));
                com.getContacts().addAll(this.dalc.getContacts(com.getId(), false));
                this.setMetaData(com, this.dalc);
            }
            return com;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateCompany(Company com) throws SelfServiceException {
        this.throwIfNull(com, "Company is null");
        try {
            this.throwIfNotValid(com.getName(), "The company name is missing");
            this.assertStringLength(com.getName(), 255);
            com.setDateModified(new Date().getTime());
            this.dalc.updateCompany(com);
            this.updateMetaData(com, this.dalc);
            this.logAction(com.getId(), AuditLogEntry.DataType.COMPANY, AuditLogEntry.Action.UPDATE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createUser(User user) throws UserException, SelfServiceException {
        this.throwIfNull(user, "User is null");
        try {
            this.throwIfNotValid(user.getUsername(), "Username is missing");
            this.throwIfNotValid(user.getEmail(), "Email is missing");
            this.throwIfNotValid(user.getFullname(), "The fullname is missing");
            this.throwIfNotValid(user.getPassword(), "Password is missing");
            this.throwIfNotValid(user.getPassword().length() >= 4, "Minimal password length is 4 characters");
            this.throwIfNotValid(StringUtil.isValidEmail(user.getEmail()), "The supplied email [" + user.getEmail() + "] is invalid");
            this.assertStringLength(user.getUsername(), 128);
            this.assertStringLength(user.getFullname(), 256);
            this.assertStringLength(user.getEmail(), 128);
            this.assertStringLength(user.getPassword(), 128);
            this.assertStringLength(user.getHomephoneNumber(), 32);
            this.assertStringLength(user.getMobilephoneNumber(), 32);
            if (user.getAddress() != null) {
                this.assertStringLength(user.getAddress().getStreetName(), 128);
                this.assertStringLength(user.getAddress().getCity(), 128);
                this.assertStringLength(user.getAddress().getPostcode(), 24);
                this.assertStringLength(user.getAddress().getState(), 128);
                this.assertStringLength(user.getAddress().getCountry(), 128);
            }
            if (user.getUserRoles().size() == 0) {
                throw new UserException("No user roles have been assigned to the user!");
            }
            User existingUser = this.getUserByUsername(user.getUsername());
            if (existingUser instanceof User) {
                throw new UserException("The username " + user.getUsername() + " is already registered");
            }
            if (this.getUserByEmail(user.getEmail()) instanceof User) {
                throw new UserException("The email " + user.getEmail() + " is already registered.");
            }
            if (!user.getContactList().isEmpty()) {
                for (Contact contact : user.getContactList()) {
                    this.throwIfNotValid(contact.getCompanyId(), "Company Id for the user is missing");
                    Company com = this.getCompany(contact.getCompanyId());
                    this.throwIfNotValid(com != null, "The Company specified does not exist!");
                }
            }
            if (!this.isWithinLicensedUserCount()) {
                throw new SelfServiceException("The registered user count has exceeded the current licence.");
            }
            IRegistrationFilter filter = this.getRegistrationFilter();
            if (filter != null && filter instanceof IRegistrationFilter) {
                try {
                    filter.validate(user);
                }
                catch (RegistrationException ex) {
                    throw new UserException(ex);
                }
            }
            this.checkDocumentId(user);
            if (user.getPassword().length() != 128) {
                user.setPassword(PBKDF2PasswordUtil.hashPassword(user.getPassword()));
            }
            this.dalc.createUser(user);
            this.createMetaData(user, this.dalc);
            this.logAction(user.getId(), AuditLogEntry.DataType.USER, AuditLogEntry.Action.CREATE);
            if (user.getTargetGroups().size() > 0) {
                for (TargetGroup group : user.getTargetGroups()) {
                    String groupRole = null;
                    for (TargetGroupUser tgu : group.getGroupUsers()) {
                        if (!tgu.getUserId().equals(user.getId()) || tgu.getRolename() == null) continue;
                        groupRole = tgu.getRolename();
                        break;
                    }
                    TargetGroupUser tgu = new TargetGroupUser(group.getId(), user.getId(), groupRole);
                    this.targetgroupEngine.createTargetGroupUser(tgu);
                }
            }
            for (GoProClientBaseReference ref : user.getGoproClientReferences()) {
                ref.setUserId(user.getId());
                this.createGoProClientReference(ref);
            }
            if (!user.getContactList().isEmpty()) {
                for (Contact contact : user.getContactList()) {
                    contact.setUserId(user.getId());
                    this.createContact(contact);
                }
            }
            if (filter != null && filter instanceof IRegistrationFilter) {
                filter.onRegistrationCompleted(user);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new UserException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (TargetGroupException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createUserRole(UserRole role) throws UserException, SelfServiceException {
        this.throwIfNull(role, "The user role is null");
        try {
            this.throwIfNotValid(role.getSubject(), "The role name is missing");
            List<UserRole> roleList = this.getUserRoles();
            for (UserRole ur : roleList) {
                if (!ur.getSubject().equalsIgnoreCase(role.getSubject())) continue;
                throw new UserException("The rolename " + ur.getSubject() + " already exists");
            }
            this.checkDocumentId(role);
            this.dalc.createUserRole(role);
            this.createMetaData(role, this.dalc);
            this.logAction(role.getId(), AuditLogEntry.DataType.USERROLE, AuditLogEntry.Action.CREATE);
        }
        catch (IllegalArgumentException ex) {
            throw new UserException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteCompany(String companyId) throws UserException, SelfServiceException {
        Company comp = this.getCompany(companyId);
        if (comp == null) {
            throw new UserException("Invalid company Id");
        }
        comp.setDeleted(true);
        this.updateCompany(comp);
        this.logAction(comp.getId(), AuditLogEntry.DataType.COMPANY, AuditLogEntry.Action.DELETE);
    }

    @Override
    public void deleteUser(String userId) throws UserException, SelfServiceException {
        User user = this.getUser(userId);
        if (user == null) {
            throw new UserException("The selected user was not found");
        }
        user.setDeleted(true);
        user.setTriggerGoProUpdate(false);
        this.updateUser(user);
        this.logAction(user.getId(), AuditLogEntry.DataType.USER, AuditLogEntry.Action.DELETE);
    }

    @Override
    public User getUserByEmail(String email) throws SelfServiceException {
        try {
            User user = this.dalc.getUserByEmail(email, false);
            if (user != null) {
                user.getGoproClientReferences().addAll(this.dalc.getClientReferences(user.getId()));
                this.setMetaData(user, this.dalc, false);
                user.getTargetGroups().addAll(this.targetgroupEngine.getTargetGroupsByUser(user.getId()));
            }
            return user;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public User getUserByUsername(String username) throws SelfServiceException {
        try {
            User user = this.dalc.getUserByUsername(username, false);
            if (user != null) {
                user.getGoproClientReferences().addAll(this.dalc.getClientReferences(user.getId()));
                this.setMetaData(user, this.dalc, false);
                user.getTargetGroups().addAll(this.targetgroupEngine.getTargetGroupsByUser(user.getId()));
            }
            return user;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public User getUserByGoProClientReferenceId(String goproReferenceId) throws SelfServiceException {
        try {
            User user = null;
            if (StringUtil.isValid(goproReferenceId) && (user = this.dalc.getUserByGoProClientReferenceId(goproReferenceId)) != null) {
                user.getGoproClientReferences().addAll(this.dalc.getClientReferences(user.getId()));
                this.setMetaData(user, this.dalc, false);
                user.getTargetGroups().addAll(this.targetgroupEngine.getTargetGroupsByUser(user.getId()));
            }
            return user;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public UserRole getUserRole(String roleId) throws SelfServiceException {
        try {
            for (UserRole role : this.getUserRoles()) {
                if (!role.getId().equals(roleId)) continue;
                this.setMetaData(role, this.dalc);
                return role;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<UserRole> getUserRoles() throws SelfServiceException {
        try {
            return this.dalc.getUserRoles();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateUser(User user) throws UserException, SelfServiceException {
        try {
            User otherUser;
            this.throwIfNull(user, "User is null");
            this.throwIfNotValid(user.getUsername(), "Username is missing");
            this.throwIfNotValid(user.getEmail(), "Email is missing");
            this.throwIfNotValid(user.getFullname(), "The fullname is missing");
            this.throwIfNotValid(user.getPassword(), "Password is missing");
            this.throwIfNotValid(user.getPassword().length() >= 4, "Minimal password length is 4 characters");
            this.throwIfNotValid(user.getId(), "User Id is not valid");
            this.throwIfNotValid(user.getUserRoles().size() > 0, "User must have at least 1 role");
            this.throwIfNotValid(StringUtil.isValidEmail(user.getEmail()), "The supplied email is invalid");
            this.assertStringLength(user.getUsername(), 128);
            this.assertStringLength(user.getFullname(), 256);
            this.assertStringLength(user.getEmail(), 128);
            this.assertStringLength(user.getPassword(), 128);
            this.assertStringLength(user.getHomephoneNumber(), 32);
            this.assertStringLength(user.getMobilephoneNumber(), 32);
            if (user.getAddress() != null) {
                this.assertStringLength(user.getAddress().getStreetName(), 128);
                this.assertStringLength(user.getAddress().getCity(), 128);
                this.assertStringLength(user.getAddress().getPostcode(), 24);
                this.assertStringLength(user.getAddress().getState(), 128);
                this.assertStringLength(user.getAddress().getCountry(), 128);
            }
            if ((otherUser = this.getUserByEmail(user.getEmail())) instanceof User && !otherUser.getId().equals(user.getId())) {
                throw new UserException("The email " + user.getEmail() + " is already registered.");
            }
            user.setDateModified(new Date().getTime());
            this.dalc.updateUser(user);
            this.updateMetaData(user, this.dalc);
            for (Contact contact : user.getContactList()) {
                if (!contact.isDirty()) continue;
                this.updateContact(contact);
            }
            if (user.getTargetGroups().size() > 0) {
                for (TargetGroup targetGroup : user.getTargetGroups()) {
                    TargetGroupUser tgu = new TargetGroupUser(targetGroup.getId(), user.getId());
                    this.targetgroupEngine.createTargetGroupUser(tgu);
                }
            }
            if (user.isTriggerGoProUpdate() && user.getGoproClientReferences().size() > 0) {
                for (GoProClientBaseReference ref : user.getGoproClientReferences()) {
                    Organization org = this.configEngine.getOrganization(ref.getOrganizationId());
                    if (org == null || org.isDeleted() || !org.isEnabled()) continue;
                    this.createQueueEntry(user, org);
                }
            }
            this.logAction(user.getId(), AuditLogEntry.DataType.USER, AuditLogEntry.Action.UPDATE);
        }
        catch (IllegalArgumentException ex) {
            throw new UserException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (TargetGroupException ex) {
            throw new SelfServiceException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createContact(Contact contact) throws SelfServiceException {
        try {
            Contact existingContact;
            BirdUserPrincipal principal;
            this.throwIfNull(contact, "Contact is null");
            this.throwIfNotValid(contact.getUserId(), "The userId of the contact is missing");
            this.throwIfNotValid(contact.getCompanyId(), "The company Id of the contact is missing");
            User user = this.dalc.getUser(contact.getUserId());
            this.throwIfNull(user, "The userId defined is invalid, no user was found");
            Company comp = this.dalc.getCompany(contact.getCompanyId());
            this.throwIfNull(comp, "The companyId defined is invalid, no company was found");
            if (StringUtil.isValid(contact.getEmail())) {
                this.throwIfNotValid(StringUtil.isValidEmail(contact.getEmail()), "The supplied email [" + contact.getEmail() + "] is invalid");
            }
            if (contact.getAssignedById() == null && (principal = ThreadContext.getCurrentUser()) != null) {
                contact.setAssignedById(principal.getUserId());
            }
            if ((existingContact = this.dalc.getContact(contact.getUserId(), contact.getCompanyId())) != null) {
                if (!existingContact.isDeleted()) throw new SelfServiceException("User id already assigned as contact for this company");
                existingContact.setDeleted(false);
                this.updateContact(existingContact);
                contact = existingContact;
                return;
            } else {
                contact.setDateCreated(new Date().getTime());
                contact.setDateModified(contact.getDateCreated());
                this.checkDocumentId(contact);
                this.dalc.createContact(contact);
                this.logAction(user.getId(), AuditLogEntry.DataType.CONTACT, AuditLogEntry.Action.CREATE);
                this.createMetaData(contact, this.dalc);
            }
            return;
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Contact getContact(String contactId) throws SelfServiceException {
        try {
            Contact contact = this.dalc.getContact(contactId);
            if (contact != null) {
                this.createMetaData(contact, this.dalc);
            }
            return contact;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Contact getContactByEmail(String email) throws SelfServiceException {
        this.throwIfNull(email, "The email address can not be null");
        try {
            Contact contact = this.dalc.getContactByEmail(email);
            if (contact != null) {
                this.createMetaData(contact, this.dalc);
            }
            return contact;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateContact(Contact contact) throws SelfServiceException {
        try {
            this.throwIfNull(contact, "Contact is null");
            this.throwIfNotValid(contact.getUserId(), "The userId of the contact is missing");
            this.throwIfNotValid(contact.getCompanyId(), "The company Id of the contact is missing");
            User user = this.dalc.getUser(contact.getUserId());
            this.throwIfNull(user, "The userId defined is invalid, no user was found");
            Company comp = this.dalc.getCompany(contact.getCompanyId());
            this.throwIfNull(comp, "The companyId defined is invalid, no company was found");
            if (StringUtil.isValid(contact.getEmail())) {
                this.throwIfNotValid(StringUtil.isValidEmail(contact.getEmail()), "The supplied email [" + contact.getEmail() + "] is invalid");
            }
            Contact initialContact = this.dalc.getContact(contact.getId());
            contact.setDateModified(new Date().getTime());
            this.dalc.updateContact(contact);
            this.updateMetaData(contact, this.dalc);
            this.logAction(user.getId(), AuditLogEntry.DataType.CONTACT, AuditLogEntry.Action.UPDATE);
            if (!initialContact.isDeleted() && contact.isDeleted()) {
                this.logAction(user.getId(), AuditLogEntry.DataType.CONTACT, AuditLogEntry.Action.DELETE);
                EngineFactory.getCaseEngine().purgeContactAccessControl(contact);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteContact(String contactId) throws SelfServiceException {
        Contact contact = this.getContact(contactId);
        if (contact == null) {
            throw new SelfServiceException("Invalid contact Id");
        }
        contact.setDeleted(true);
        contact.setManager(false);
        this.updateContact(contact);
    }

    @Override
    public void updateUserRole(UserRole role) throws UserException, SelfServiceException {
        this.throwIfNull(role, "The role is null");
        try {
            this.throwIfNotValid(role.getSubject(), "The role name is missing");
            this.throwIfNotValid(role.getId(), "Role Id is missing");
            if (UserRole.isSystemRole(role.getId())) {
                throw new UserException("System roles cannot be updated");
            }
            this.dalc.updateUserRole(role);
            this.logAction(role.getId(), AuditLogEntry.DataType.USERROLE, AuditLogEntry.Action.UPDATE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new UserException(ex);
        }
    }

    @Override
    public List<User> getContacts(String companyId) throws UserException, SelfServiceException {
        try {
            this.throwIfNotValid(companyId, "Company Id is null");
            List<User> list = this.dalc.getContacts(companyId, true);
            return list;
        }
        catch (IllegalArgumentException ex) {
            throw new UserException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<User> getUsers(UserFilter filter) throws SelfServiceException {
        try {
            this.throwIfNull(filter, "The user filter cannot be null");
            ArrayList<User> list = new ArrayList<User>();
            if (filter.getAccountManagerId() != null) {
                list.addAll(this.getUsersByAccountManager(filter));
            } else {
                list.addAll(this.dalc.getUsers(filter));
            }
            if (filter.getResultOffset() > 0 && list.size() > filter.getResultOffset()) {
                if (filter.getMaxResults() > 0) {
                    int toIndex = filter.getResultOffset() + filter.getMaxResults();
                    if (toIndex > list.size()) {
                        toIndex = list.size();
                    }
                    return list.subList(filter.getResultOffset(), toIndex);
                }
                return list.subList(filter.getResultOffset(), list.size());
            }
            if (filter.getMaxResults() > 0 && list.size() > filter.getMaxResults()) {
                return list.subList(0, filter.getMaxResults());
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<User> getUsers(List<String> userIds) throws SelfServiceException {
        try {
            ArrayList<User> list = new ArrayList<User>();
            if (!userIds.isEmpty()) {
                list.addAll(this.dalc.getUsers(userIds));
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createGoProClientReference(GoProClientBaseReference ref) throws SelfServiceException {
        this.throwIfNull(ref, "Client reference is null");
        try {
            this.throwIfNotValid(ref.getUserId(), "The user Id for the reference is missing");
            this.throwIfNotValid(ref.getOrganizationId(), "The organization Id is missing");
            this.throwIfNotValid(ref.getGoproId(), "The GoPro Id is missing");
            if (ref instanceof GoProContactReference) {
                this.throwIfNotValid(((GoProContactReference)ref).getContactId(), "The contact Id is missing");
            }
            this.checkDocumentId(ref);
            this.dalc.createGoProClientReference(ref);
            this.createMetaData(ref, this.dalc);
            this.logAction(ref.getId(), AuditLogEntry.DataType.GOPRO_CLIENT_REF, AuditLogEntry.Action.CREATE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateGoProClientReference(GoProClientBaseReference ref) throws SelfServiceException {
        this.throwIfNull(ref, "Client reference is null");
        try {
            this.throwIfNotValid(ref.getId(), "The Reference Id for the reference is missing");
            this.throwIfNotValid(ref.getUserId(), "The user Id for the reference is missing");
            this.throwIfNotValid(ref.getOrganizationId(), "The organization Id is missing");
            this.throwIfNotValid(ref.getGoproId(), "The GoPro client Id is missing");
            ref.setDateModified(new Date().getTime());
            this.dalc.updateGoProClientReference(ref);
            this.logAction(ref.getId(), AuditLogEntry.DataType.GOPRO_CLIENT_REF, AuditLogEntry.Action.UPDATE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateGoProCompanyReference(GoProCompanyReference ref) throws SelfServiceException {
        this.throwIfNull(ref, "Company reference is null");
        try {
            this.throwIfNotValid(ref.getId(), "The Reference Id for the reference is missing");
            this.throwIfNotValid(ref.getOrganizationId(), "The organization Id is missing");
            this.throwIfNotValid(ref.getGoproCompanyId(), "The GoPro company Id is missing");
            ref.setDateModified(new Date().getTime());
            this.dalc.updateGoProCompanyReference(ref);
            this.logAction(ref.getId(), AuditLogEntry.DataType.GOPRO_COMPANY_REF, AuditLogEntry.Action.UPDATE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createGoProCompanyReference(GoProCompanyReference ref) throws SelfServiceException {
        this.throwIfNull(ref, "Company reference is null");
        try {
            this.throwIfNotValid(ref.getCompanyId(), "The company Id is missing");
            this.throwIfNotValid(ref.getGoproCompanyId(), "The GoPro company Id is missing");
            this.throwIfNotValid(ref.getOrganizationId(), "The organization Id is invalid");
            Organization o = this.configEngine.getOrganization(ref.getOrganizationId());
            this.throwIfNull(o, "The supplied organization Id is invalid");
            this.checkDocumentId(ref);
            this.dalc.createGoProCompanyReference(ref);
            this.createMetaData(ref, this.dalc);
            this.logAction(ref.getId(), AuditLogEntry.DataType.GOPRO_COMPANY_REF, AuditLogEntry.Action.CREATE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteCompanyContact(String companyId, String userId) throws SelfServiceException, UserException {
        try {
            this.throwIfNotValid(companyId, "The company Id is missing");
            this.throwIfNotValid(userId, "The UserId is missing");
            User user = this.getUser(userId);
            Company com = this.getCompany(companyId);
            this.throwIfNull(user, "No user was found with the supplied Id");
            this.throwIfNull(com, "No company was found with the supplied Id");
            for (Contact contact : user.getContactList()) {
                if (!contact.getCompanyId().equals(companyId)) continue;
                this.deleteContact(contact.getId());
                break;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public User authenticate(String username, String password) throws AuthenticationException, SelfServiceException {
        if (!this.isValid(username) || !this.isValid(password)) {
            throw new AuthenticationException("Authentication failed.  Insufficient credentials submitted.");
        }
        User user = this.getUserByUsername(username);
        if (user == null) {
            throw new AuthenticationException("Authentication failed. User " + username + " does not exist.");
        }
        boolean matchesPassword = PBKDF2PasswordUtil.matchesPassword(password, user);
        boolean updateUser = false;
        if (!matchesPassword && PasswordUtil.matchesPassword(password, user)) {
            user.setPassword(PBKDF2PasswordUtil.hashPassword(password));
            user.setTriggerGoProUpdate(false);
            updateUser = true;
            matchesPassword = true;
        }
        if (matchesPassword) {
            if (user.isDeleted()) {
                throw new AuthenticationException("Authentication failed. The user: " + username + " has been deleted.");
            }
            if (!user.isVerified()) {
                throw new AuthenticationException("Authentication failed. The user has not been verified");
            }
            this.logAction(user.getId(), AuditLogEntry.DataType.USER, AuditLogEntry.Action.LOGIN);
            if (updateUser) {
                try {
                    this.updateUser(user);
                }
                catch (UserException ex) {
                    throw new SelfServiceException(ex);
                }
            }
            return user;
        }
        if (user != null) {
            this.logAction(user.getId(), AuditLogEntry.DataType.USER, AuditLogEntry.Action.FAILED_LOGIN);
        }
        throw new AuthenticationException("Authentication failed for user: " + username);
    }

    @Override
    public User authenticate(X509Certificate certificate) throws AuthenticationException, SelfServiceException {
        throw new AuthenticationException("Not yet Implemented");
    }

    @Override
    public List<Company> searchCompanies(String keyword) throws SelfServiceException {
        try {
            if (keyword == null || "".equals(keyword)) {
                return new ArrayList<Company>();
            }
            return this.dalc.searchCompanies(keyword);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Company getCompanyByName(String companyName) throws SelfServiceException {
        try {
            Company com = this.dalc.getCompanyByName(companyName);
            if (com != null) {
                com.getGoproCompanyReferences().addAll(this.dalc.getCompanyReferences(com.getId()));
                this.setMetaData(com, this.dalc);
            }
            return com;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createRecoveryTicket(RecoveryTicket ticket) throws SelfServiceException {
        try {
            this.throwIfNull(ticket, "Ticket cannot be null");
            this.throwIfNotValid(ticket.getUserId(), "The user Id for the ticket is missing");
            this.throwIfNotValid(ticket.getRequestIp(), "The request IP is missing");
            this.checkDocumentId(ticket);
            this.dalc.createRecoveryTicket(ticket);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public RecoveryTicket getRecoveryTicket(String ticketId) throws SelfServiceException {
        try {
            return this.dalc.getRecoveryTicket(ticketId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateRecoveryTicket(RecoveryTicket ticket) throws SelfServiceException {
        try {
            this.throwIfNull(ticket, "Ticket cannot be null");
            this.throwIfNotValid(ticket.getUserId(), "The user Id for the ticket is missing");
            this.throwIfNotValid(ticket.getRequestIp(), "The request IP is missing");
            this.throwIfNotValid(ticket.getId(), "The ticket Id is missing");
            ticket.setDateModified(new Date().getTime());
            this.dalc.updateRecoveryTicket(ticket);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public byte[] getUserProfileImage(String userId) throws SelfServiceException {
        try {
            byte[] image = null;
            User user = this.getUser(userId);
            if (user != null) {
                BirdDatabase db;
                BirdFile file;
                String metadataKey = "profileimage.id";
                MetaData meta = user.getMetaDataByKey("profileimage.id");
                if (meta != null && (file = (db = SelfServiceEngine.getBirdSession().getDatabase()).getFileByID(meta.getValue())) != null && (file = db.getFileByName(file.getName())) != null && file.getBody() != null) {
                    image = IOUtils.toByteArray((InputStream)file.getBody());
                }
            }
            return image;
        }
        catch (BirdException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private List<User> getUsersByAccountManager(UserFilter filter) throws SelfServiceException {
        try {
            ArrayList<User> list = new ArrayList<User>();
            User accountManager = this.getUser(filter.getAccountManagerId());
            if (accountManager != null) {
                if (accountManager.getContactList().size() > 0) {
                    for (Contact contact : accountManager.getContactList()) {
                        list.addAll(this.getContacts(contact.getCompanyId()));
                    }
                }
                ArrayList<String> targetGroupIds = new ArrayList<String>();
                for (TargetGroup group : accountManager.getTargetGroups()) {
                    targetGroupIds.add(group.getId());
                }
                if (targetGroupIds.size() > 0) {
                    list.addAll(this.dalc.getUsersByTargetGroup(filter, targetGroupIds));
                }
            }
            return list;
        }
        catch (UserException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private boolean isWithinLicensedUserCount() throws SelfServiceException {
        try {
            Log log = SelfServiceEngine.getLogger();
            int licensedUsers = 2;
            boolean isDemo = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("web.demo"));
            if (isDemo) {
                licensedUsers = 10;
            } else {
                Licence licence = null;
                try {
                    licence = LicenceService.getLicence();
                }
                catch (RuntimeException ex) {
                    licence = this.getLicense();
                }
                if (licence == null || !licence.isValid()) {
                    log.debug("Invalid licence or no licence available ");
                    return false;
                }
                LicenceModule lic = licence.getLicenceByModuleName("Self Service Module");
                if (lic == null) {
                    log.debug("No licence for module: Self Service Module");
                    return false;
                }
                licensedUsers = lic.getNumberOfUsers();
                log.debug("Licence valid for " + licensedUsers + " users.");
            }
            int currentUserCount = this.dalc.getUserCount();
            if (licensedUsers * 90 / 100 <= currentUserCount) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
                String subject = rb.getString("license.reminder.subject");
                String body = rb.getString("license.reminder.body");
                try {
                    AdminUtil.sendErrorReport(subject, body);
                }
                catch (CommunicationException ex) {
                    logger.warn((Object)"Could not notify administrator", (Throwable)ex);
                }
            }
            return licensedUsers >= currentUserCount;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (BirdException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }

    private Licence getLicense() throws SelfServiceException {
        try {
            Licence lic = null;
            InputStream in = this.dalc.getLicenseFile();
            String serverId = this.dalc.getLicenceServiceId();
            if (in != null && StringUtil.isValid(serverId)) {
                lic = new Licence(in, serverId);
            }
            return lic;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (DocumentException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (RuntimeException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private final IRegistrationFilter getRegistrationFilter() throws SelfServiceException {
        String className = SelfServiceEngine.getConfig(IRegistrationFilter.class.getName());
        if (StringUtil.isValid(className)) {
            return EngineFactory.getCustomEngine(IRegistrationFilter.class);
        }
        return null;
    }

    private final boolean createQueueEntry(User user, Organization org) throws SelfServiceException {
        if (RemoteGoPro.isNOPDataStore(org.getEndpoint().getGoproType())) {
            return false;
        }
        List<RoutingQueueEntry> queueList = this.queueEngine.getRoutingQueue();
        for (RoutingQueueEntry entry : queueList) {
            if (!entry.getDocumentId().equals(user.getId()) || !entry.getOrganizationId().equals(org.getId())) continue;
            return false;
        }
        RoutingQueueEntry entry = new RoutingQueueEntry(user.getId(), org.getId(), RoutingQueueEntry.DocumentType.CONTACT);
        return this.queueEngine.createRoutingQueueEntry(entry);
    }
}

