/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.IConfigEngine;
import net.gopro.selfservice.ISearchEngine;
import net.gopro.selfservice.IUserEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.SearchDalc;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.filters.DocumentFilter;
import net.gopro.selfservice.filters.DocumentSearchFilter;
import net.gopro.selfservice.filters.MetaDataSearchFilter;
import net.gopro.selfservice.impl.BaseImpl;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;

public class SearchImpl
extends BaseImpl
implements ISearchEngine {
    protected SearchDalc dalc;
    protected IConfigEngine configEngine;
    protected IUserEngine userEngine;

    public SearchImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.dalc = new SearchDalc();
        this.configEngine = EngineFactory.getConfigEngine();
        this.userEngine = EngineFactory.getUserEngine();
    }

    @Override
    public List<BaseDocument> searchDocuments(DocumentSearchFilter filter) throws SelfServiceException {
        this.throwIfNull(filter, "Search filter cannot be null");
        BirdUserPrincipal userContext = this.getUserContext();
        if (filter.getDocumentTypes().size() == 0) {
            throw new SelfServiceException("No Document Types have been specified.");
        }
        if (filter.getSearchKeyword() == null || "".equals(filter.getSearchKeyword())) {
            throw new SelfServiceException("No search keyword has been set.");
        }
        if (filter.getDocumentTypes().contains(BaseCase.class)) {
            filter.addDocumentType(Case.class);
            filter.addDocumentType(FormCase.class);
        }
        if (filter.getDocumentTypes().contains(SubDocument.class)) {
            filter.addDocumentType(Memo.class);
            filter.addDocumentType(ExternalDocument.class);
            filter.addDocumentType(Email.class);
        }
        if (filter.getDocumentTypes().contains(ExternalDocument.class)) {
            filter.addDocumentType(ApplicationForm.class);
            filter.addDocumentType(Attachment.class);
            filter.addDocumentType(CompletedFormDocument.class);
        }
        ArrayList<BaseDocument> resultList = new ArrayList<BaseDocument>();
        try {
            for (Class<? extends BaseDocument> clazz : filter.getDocumentTypes()) {
                if (clazz.equals(Memo.class)) {
                    List<Memo> memoList = this.dalc.searchMemos(filter, userContext.getUserId());
                    resultList.addAll(memoList);
                    continue;
                }
                if (clazz.equals(Email.class)) {
                    List<Email> emailList = this.dalc.searchEmails(filter, userContext.getUserId());
                    resultList.addAll(emailList);
                    continue;
                }
                if (clazz.equals(FormTemplate.class)) {
                    List<FormTemplate> templateList = this.dalc.searchFormTemplates(filter);
                    if (templateList.size() > 0) {
                        this.processFormTemplates(templateList);
                    }
                    resultList.addAll(templateList);
                    continue;
                }
                if (clazz.equals(Case.class) || clazz.equals(FormCase.class)) {
                    List<BaseCase> caseList = this.dalc.searchCases(filter, clazz, userContext.getUserId());
                    resultList.addAll(caseList);
                    continue;
                }
                if (clazz.equals(ApplicationForm.class) || clazz.equals(Attachment.class) || clazz.equals(CompletedFormDocument.class)) {
                    List<ExternalDocument> externalList = this.dalc.searchExternalDocuments(filter, clazz, userContext.getUserId());
                    resultList.addAll(externalList);
                    continue;
                }
                if (!clazz.equals(Message.class)) continue;
                List<Message> messageList = this.dalc.searchMessages(filter, userContext.getUserId());
                resultList.addAll(messageList);
            }
            Iterator it = resultList.iterator();
            while (it.hasNext()) {
                BaseDocument doc = (BaseDocument)it.next();
                if (filter.getDeletionStatus().equals((Object)DocumentSearchFilter.DeletionStatus.DELETED)) {
                    if (!doc.isDeleted()) {
                        it.remove();
                        continue;
                    }
                } else if (filter.getDeletionStatus().equals((Object)DocumentSearchFilter.DeletionStatus.NOT_DELETED) && doc.isDeleted()) {
                    it.remove();
                    continue;
                }
                if (filter.getDateFrom() != null && doc.getDateCreated() < filter.getDateFrom().getTime()) {
                    it.remove();
                    continue;
                }
                if (filter.getDateTo() == null || doc.getDateCreated() <= filter.getDateTo().getTime()) continue;
                it.remove();
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        return resultList;
    }

    @Override
    public List<BaseDocument> getDocuments(DocumentFilter filter) throws SelfServiceException {
        this.throwIfNull(filter, "DocumentFilter cannot be null");
        try {
            filter.validate();
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        if (filter.getDocumentTypes().contains(BaseCase.class)) {
            filter.addDocumentType(Case.class);
            filter.addDocumentType(FormCase.class);
        }
        if (filter.getDocumentTypes().contains(SubDocument.class)) {
            filter.addDocumentType(Memo.class);
            filter.addDocumentType(ExternalDocument.class);
            filter.addDocumentType(Email.class);
        }
        if (filter.getDocumentTypes().contains(ExternalDocument.class)) {
            filter.addDocumentType(ApplicationForm.class);
            filter.addDocumentType(Attachment.class);
            filter.addDocumentType(CompletedFormDocument.class);
        }
        ArrayList<BaseDocument> resultList = new ArrayList<BaseDocument>();
        try {
            for (Class<? extends BaseDocument> clazz : filter.getDocumentTypes()) {
                if (clazz.equals(Case.class) || clazz.equals(FormCase.class)) {
                    List<BaseCase> caseList = this.dalc.getCases(filter, clazz);
                    resultList.addAll(caseList);
                    continue;
                }
                if (clazz.equals(Memo.class)) {
                    List<Memo> memoList = this.dalc.getMemos(filter);
                    resultList.addAll(memoList);
                    continue;
                }
                if (!clazz.equals(Email.class)) continue;
                List<Email> emailList = this.dalc.getEmails(filter);
                resultList.addAll(emailList);
            }
            List<Class<? extends BaseDocument>> externalDocumentTypes = filter.getExternalDocumentTypes();
            if (externalDocumentTypes.size() > 0) {
                List<ExternalDocument> externalList = this.dalc.getExternalDocuments(filter, externalDocumentTypes);
                resultList.addAll(externalList);
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        return resultList;
    }

    @Override
    public List<BaseDocument> searchDocumentsByMetadata(MetaDataSearchFilter filter) throws SelfServiceException {
        if (filter.getDocumentTypes().size() == 0) {
            throw new SelfServiceException("No document type has been specified");
        }
        if (!StringUtil.isValid(filter.getMetadataKey()) && !StringUtil.isValid(filter.getMetadataValue())) {
            throw new SelfServiceException("Metadata search must contain either a key or value.");
        }
        try {
            ArrayList<BaseDocument> list = new ArrayList<BaseDocument>();
            for (Class<? extends BaseDocument> clazz : filter.getDocumentTypes()) {
                List<String> documentIds = this.dalc.searchByMetaData(clazz, filter);
                if (documentIds.size() <= 0) continue;
                if (User.class.equals(clazz)) {
                    for (String userId : documentIds) {
                        User user = this.userEngine.getUser(userId);
                        if (user == null) continue;
                        list.add(user);
                    }
                    continue;
                }
                if (Company.class.equals(clazz)) {
                    for (String companyId : documentIds) {
                        Company company = this.userEngine.getCompany(companyId);
                        if (company == null) continue;
                        list.add(company);
                    }
                    continue;
                }
                list.addAll(this.dalc.getDocumentsByIds(clazz, documentIds));
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UserException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<ExternalDocument> getUserDocuments(String userId) throws SelfServiceException {
        try {
            User user = this.userEngine.getUser(userId);
            this.throwIfNull(user, "The specified user was not found!");
            return this.dalc.getUserDocuments(user);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void processFormTemplates(List<FormTemplate> list) throws SelfServiceException {
        try {
            List<Organization> organizationList = this.configEngine.getOrganizations();
            Hashtable<String, Hashtable<String, String>> mapping = this.dalc.getFormTemplateMapping();
            for (FormTemplate template : list) {
                Hashtable<String, String> map = mapping.get(template.getId());
                if (map == null) continue;
                for (String organizationId : map.keySet()) {
                    Organization o = (Organization)BaseDocumentUtil.getDocumentFromList(organizationId, organizationList);
                    template.getOrganizations().add(o);
                    template.getLinkMap().put(organizationId, map.get(organizationId));
                }
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }
}

