/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import net.gopro.selfservice.ILogEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.LogDalc;
import net.gopro.selfservice.data.AuditLog;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.DetailedLogEntry;
import net.gopro.selfservice.filters.AuditLogFilter;
import net.gopro.selfservice.util.ThreadContext;

public class LogImpl
implements ILogEngine {
    protected LogDalc dalc;

    public LogImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.dalc = new LogDalc();
    }

    @Override
    public void createLogEntry(AuditLogEntry entry) throws SelfServiceException {
        if (entry != null) {
            try {
                if (entry.getUserId() == null) {
                    BirdUserPrincipal principal = ThreadContext.getCurrentUser();
                    if (principal != null) {
                        entry.setUserId(principal.getUserId());
                        entry.setIp(principal.getIp());
                    } else if (entry.getAction().equals((Object)AuditLogEntry.Action.LOGIN)) {
                        entry.setUserId(entry.getDocumentId());
                    } else {
                        entry.setUserId("00000000000000000000000000000000");
                    }
                }
                this.dalc.createLogEntry(entry);
            }
            catch (SQLException ex) {
                throw new SelfServiceException(ex);
            }
        }
    }

    @Override
    public AuditLog getAuditLog(AuditLogFilter filter) throws SelfServiceException {
        if (filter == null) {
            throw new SelfServiceException("Filter object cannot be null");
        }
        if (!filter.isValid()) {
            throw new SelfServiceException("No data has been added to the filter!");
        }
        try {
            return this.dalc.getAuditLog(filter);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public AuditLog getAuditLog(long dateFrom, long dateTo) throws SelfServiceException {
        AuditLogFilter filter = new AuditLogFilter();
        filter.setDateFilter(new Date(dateFrom), new Date(dateTo));
        return this.getAuditLog(filter);
    }

    @Override
    public AuditLog getAuditLog(long dateFrom, long dateTo, AuditLogEntry.DataType dataType) throws SelfServiceException {
        AuditLogFilter filter = new AuditLogFilter();
        filter.addDataType(dataType);
        filter.setDateFilter(new Date(dateFrom), new Date(dateTo));
        return this.getAuditLog(filter);
    }

    @Override
    public AuditLog getCaseHistory(String caseId) throws SelfServiceException {
        try {
            AuditLog log = new AuditLog();
            List<DetailedLogEntry> logEntries = this.dalc.getCaseHistory(caseId);
            for (DetailedLogEntry entry : logEntries) {
                if (!this.isEntryRelevant(entry)) continue;
                log.getEntries().add(entry);
            }
            return log;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private boolean isEntryRelevant(DetailedLogEntry entry) {
        if ((AuditLogEntry.DataType.EXTERNAL_DOCUMENT.equals((Object)entry.getDataType()) || AuditLogEntry.DataType.COMPLETED_FORM.equals((Object)entry.getDataType())) && (AuditLogEntry.Action.UPDATE.equals((Object)entry.getAction()) || AuditLogEntry.Action.CREATE.equals((Object)entry.getAction()) || AuditLogEntry.Action.DOWNLOAD.equals((Object)entry.getAction()))) {
            return false;
        }
        return !AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS.equals((Object)entry.getAction());
    }
}

