/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import is.hugvit.log.Log;
import java.util.Date;
import net.gopro.gdf.data.ClientBaseRefType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.ExternalDocumentType;
import net.gopro.gdf.data.ExternalDocumentVersionType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.types.CommunicationCodeType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.gdf.helpers.GDFMetadata;

public final class GDFExternalDocument {
    private static final Log logger = SelfServiceEngine.getLogger();

    public static final ExternalDocumentType createExternalDocumentType(DocumentService service, String goproParentId, ExternalDocument exDoc, User user, GoProClientBaseReference clientRef) throws GdfServiceException {
        ExternalDocumentType doc = GDFExternalDocument.initialize(service, goproParentId);
        doc.setID("00000000-0000-0000-0000-000000000000");
        doc.setSubject(exDoc.getSubject());
        doc.setBody(exDoc.getBody());
        doc.setOriginalDate(new Date(exDoc.getDateCreated()));
        doc.setCreationDate(new Date(exDoc.getDateCreated()));
        doc.setModifiedDate(new Date(exDoc.getDateModified()));
        doc.setDirection(CommunicationCodeType.INCOMING);
        doc.setPersonalSensitive(exDoc.isPersonalSensitive());
        doc.setNumberOfVersions(1);
        if (doc.getStatus() == null) {
            ListValueRefType lStatus = new ListValueRefType();
            lStatus.setName("");
            doc.setStatus(lStatus);
        }
        ClientBaseRefType originatorRef = new ClientBaseRefType();
        originatorRef.setID(clientRef.getGoproId());
        originatorRef.setName(user.getFullname());
        doc.setOriginator(originatorRef);
        FileAttachmentType ft = new FileAttachmentType();
        ft.setStream(exDoc.getStream());
        ft.setFileName(exDoc.getFilename());
        ft.setFileSize(exDoc.getFilesize());
        ft.setMimeType(exDoc.getMimetype());
        ExternalDocumentVersionType version = new ExternalDocumentVersionType();
        version.setAttachment(ft);
        version.setID("00000000-0000-0000-0000-000000000000");
        version.setCreationDate(new Date(exDoc.getDateCreated()));
        version.setSubject(exDoc.getSubject());
        doc.setCurrentVersion(version);
        GDFMetadata.setMetadata(exDoc, (DocumentBaseType)doc);
        MetaDataType mt = new MetaDataType();
        mt.setName("SelfServiceId");
        mt.setValue(exDoc.getId());
        mt.setValueType(MetaValueType.STRING);
        doc.addMetaDataEntry(mt);
        return doc;
    }

    private static final ExternalDocumentType initialize(DocumentService service, String parentId) throws GdfServiceException {
        DocumentCollectionType dc = service.getDocumentInitiationData(parentId, 1025, null);
        if (dc == null || dc.getDocumentsCount() == 0) {
            return new ExternalDocumentType();
        }
        return (ExternalDocumentType)dc.getDocument(0);
    }
}

