/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import is.hugvit.log.Log;
import java.util.Arrays;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.CompanyRefType;
import net.gopro.gdf.data.ConjunctionListType;
import net.gopro.gdf.data.ContactType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.IndividualRefType;
import net.gopro.gdf.data.NameType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.GoProCompanyReference;
import net.gopro.selfservice.data.gopro.GoProIndividualReference;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.GDFDataHelper;
import net.gopro.selfservice.util.StringUtil;

public final class GDFContact {
    private static final Log logger = SelfServiceEngine.getLogger();

    public static String createContact(DocumentService service, Organization destination, User user, Company com, GoProIndividualReference individualRef, GoProCompanyReference companyRef) throws GoProDataStoreException {
        String contactId = null;
        try {
            try {
                String existingGoProContactlId = GDFContact.lookupContact(service, destination, user, companyRef);
                if (StringUtil.isValid(existingGoProContactlId)) {
                    return existingGoProContactlId;
                }
            }
            catch (GdfServiceException ex) {
                logger.warn("Error in Contact lookup: " + ex.getMessage() + ".  Will continue to create contact.");
            }
            ContactType contactType = GDFContact.createContactType(service, user, com, individualRef, companyRef);
            DocumentCollectionType coll = new DocumentCollectionType();
            coll.addDocument((DocumentBaseType)contactType);
            String[] ids = service.createDocuments(coll);
            if (ids == null || ids.length != 1) {
                throw new GoProDataStoreException("Invalid response from GDF Service");
            }
            contactId = ids[0];
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
        return contactId;
    }

    private static ContactType createContactType(DocumentService service, User user, Company com, GoProIndividualReference individualRef, GoProCompanyReference companyRef) throws GdfServiceException, GoProDataStoreException {
        ContactType contactType = (ContactType)GDFDataHelper.getDocumentInitiationData(service, 1010, companyRef.getGoproCompanyId(), null);
        if (contactType == null) {
            throw new GoProDataStoreException("GDF Initiation data for Contact is missing or invalid!");
        }
        contactType.setID("00000000-0000-0000-0000-000000000000");
        contactType.setSubject(user.getFullname());
        CompanyRefType ref = new CompanyRefType();
        ref.setID(companyRef.getGoproCompanyId());
        ref.setName(com.getName());
        contactType.setCompany(ref);
        NameType name = new NameType();
        name.setFirstName(user.getFirstName());
        name.setLastName(user.getLastName());
        name.setMiddleName(user.getMiddleName());
        name.setInitials(user.getInitials());
        IndividualRefType indRef = new IndividualRefType();
        indRef.setID(individualRef.getGoproId());
        indRef.setName(user.getFullname());
        contactType.setPersonalInformation(indRef);
        contactType.removeAllEmailAddresses();
        for (Contact contact : user.getContactList()) {
            if (!contact.getCompanyId().equals(companyRef.getCompanyId()) || contact.getEmail() == null) continue;
            contactType.addEmailAddress(contact.getEmail());
            break;
        }
        contactType.setIDNumber(user.getUsername());
        return contactType;
    }

    private static final String lookupContact(DocumentService service, Organization destination, User user, GoProCompanyReference companyRef) throws GdfServiceException {
        if (Boolean.parseBoolean(SelfServiceEngine.getConfig("datastore.force.contacts"))) {
            logger.info("Force new clients enabled, matching client search in GoPro disabled.");
            return null;
        }
        String contactId = null;
        ConjunctionListType filterList = new ConjunctionListType();
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1010);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        if (RemoteGoPro.GoPro.GOPRO_NET.equals((Object)destination.getEndpoint().getGoproType())) {
            filter.addFilterParentID(companyRef.getGoproCompanyId());
        } else {
            BinaryFilterExpressionType companyFilter = new BinaryFilterExpressionType();
            companyFilter.setPropertyName("_company[CompanyRefType]._ID");
            companyFilter.setOperator(FilterOperatorType.EQUAL);
            companyFilter.setValue((Object)companyRef.getGoproCompanyId());
            filterList.addElement((FilterExpressionType)companyFilter);
        }
        BinaryFilterExpressionType nameFilter = new BinaryFilterExpressionType();
        nameFilter.setPropertyName("_subject");
        nameFilter.setOperator(FilterOperatorType.EQUAL);
        nameFilter.setValue((Object)user.getFullname());
        BinaryFilterExpressionType emailFilter = new BinaryFilterExpressionType();
        emailFilter.setPropertyName("_emailAddresses");
        emailFilter.setOperator(FilterOperatorType.CONTAINSONE);
        emailFilter.setInValues(Arrays.asList(user.getEmail()));
        filterList.addElement((FilterExpressionType)nameFilter);
        filterList.addElement((FilterExpressionType)emailFilter);
        filter.setCustomFilter((FilterExpressionType)filterList);
        FlexibleDataSetType dataset = service.getDocumentHeaders(filter);
        if (dataset != null && dataset.getData().getRowsCount() > 0) {
            contactId = dataset.getData().getRow(0).getID();
            logger.info("Found existing Contact in the Remote GoPro");
        } else {
            logger.info("Contact does not already exist in the Remote GoPro, needs to be created.");
        }
        return contactId;
    }
}

