/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import is.hugvit.log.Log;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.CompanyType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.GDFDataHelper;
import net.gopro.selfservice.gdf.helpers.GDFAddress;

public final class GDFCompany {
    private static final Log logger = SelfServiceEngine.getLogger();

    public static final String createCompany(DocumentService service, Company com) throws GoProDataStoreException {
        String goproId = null;
        try {
            goproId = GDFCompany.lookupCompany(service, com);
            if (goproId != null) {
                return goproId;
            }
            CompanyType comType = GDFCompany.createCompanyType(service, com);
            DocumentCollectionType coll = new DocumentCollectionType();
            coll.addDocument((DocumentBaseType)comType);
            String[] ids = service.createDocuments(coll);
            if (ids == null || ids.length != 1) {
                throw new GoProDataStoreException("Invalid response from GDF Service");
            }
            goproId = ids[0];
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
        return goproId;
    }

    private static final CompanyType createCompanyType(DocumentService service, Company com) throws GoProDataStoreException, GdfServiceException {
        CompanyType type = (CompanyType)GDFDataHelper.getDocumentInitiationData(service, 1008, null, null);
        type.setSubject(com.getName());
        AddressType addressType = GDFAddress.createAddressType(service, com.getAddress());
        if (type.getAddressesCount() == 1) {
            type.setAddress(0, addressType);
        } else {
            type.addAddress(addressType);
        }
        return type;
    }

    private static String lookupCompany(DocumentService service, Company com) throws GoProDataStoreException, GdfServiceException {
        String companyId = null;
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1008);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        BinaryFilterExpressionType nameFilter = new BinaryFilterExpressionType();
        nameFilter.setPropertyName("_subject");
        nameFilter.setOperator(FilterOperatorType.EQUAL);
        nameFilter.setValue((Object)com.getName());
        filter.setCustomFilter((FilterExpressionType)nameFilter);
        FlexibleDataSetType dataset = service.getDocumentHeaders(filter);
        if (dataset != null && dataset.getData().getRowsCount() > 0) {
            companyId = dataset.getData().getRow(0).getID();
            logger.info("Found existing Company in the Remote GoPro");
        } else {
            logger.info("Company does not already exist in the Remote GoPro, needs to be created.");
        }
        return companyId;
    }
}

