/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.JsonException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.gopro.gdf.data.CaseTemplateType;
import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.data.CompanyType;
import net.gopro.gdf.data.ContactType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.DocumentType;
import net.gopro.gdf.data.ExternalDocumentType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.FolderType;
import net.gopro.gdf.data.IndividualType;
import net.gopro.gdf.data.ListType;
import net.gopro.gdf.data.MemoType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.ReferenceType;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.util.json.JsonSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;
import org.json.JSONObject;

public class RestHelper {
    public static final Logger logger = Logger.getLogger(RestHelper.class);

    public static IndividualType getIndividual(Organization org, String individualId) throws GoProDataStoreException {
        try {
            Endpoint ep = org.getEndpoint();
            String path = "Client/Data/Individual/" + individualId;
            Invocation.Builder builder = RestHelper.getBuilder(ep, path, "application/json");
            Response response = builder.accept(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                if (json != null) {
                    return (IndividualType)ser.deserialize(json.toString(), IndividualType.class);
                }
            } else {
                if (response.getStatus() == 404) {
                    return null;
                }
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get individual", response));
            }
            return null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static ContactType getContact(Organization org, String contactId) throws GoProDataStoreException {
        try {
            Endpoint ep = org.getEndpoint();
            String path = "Client/Data/Contact/" + contactId;
            Invocation.Builder builder = RestHelper.getBuilder(ep, path, "application/json");
            Response response = builder.accept(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                if (json != null) {
                    return (ContactType)ser.deserialize(json.toString(), ContactType.class);
                }
            } else {
                if (response.getStatus() == 404) {
                    return null;
                }
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get contact", response));
            }
            return null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String createIndividual(Organization org, IndividualType ind) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Individual/Create";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)ind));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Individual/Create", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return ((String)response.readEntity(String.class)).replace("\"", "");
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Create individual", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String createFolder(Organization org, FolderType folder) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Folder/Create";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)folder));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Folder/Create", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return ((String)response.readEntity(String.class)).replace("\"", "");
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Create folder", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String createReference(Organization org, ReferenceType refType) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Reference/Create";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)refType));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Reference/Create", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return ((String)response.readEntity(String.class)).replace("\"", "");
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Create reference", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String createExternalDocument(Organization org, ExternalDocumentType docType) throws GoProDataStoreException {
        try {
            JSONObject job = RestHelper.uploadFile(org, docType.getCurrentVersion().getAttachment());
            docType.getCurrentVersion().setAttachment(new FileAttachmentType());
            String path = "Client/Data/Document/Create";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)docType));
            form.param("filekey", job.getString("containerId"));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Document/Create", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return ((String)response.readEntity(String.class)).replace("\"", "");
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Create document", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    private static JSONObject uploadFile(Organization org, FileAttachmentType file) throws GoProDataStoreException {
        try {
            String path = "Client/Data/File/Upload";
            String requestUrl = org.getEndpoint().getHostname() + "Client/Data/File/Upload";
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost postRequest = new HttpPost(requestUrl);
            postRequest.addHeader("cookie", RestHelper.getAuthCookie(org.getEndpoint()));
            HttpEntity requestEntity = MultipartEntityBuilder.create().addBinaryBody("file", file.getStream(), ContentType.APPLICATION_OCTET_STREAM, URLEncoder.encode(file.getFileName(), "UTF-8")).addTextBody("containerId", "").build();
            postRequest.setEntity(requestEntity);
            HttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new GoProDataStoreException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)response.getEntity().getContent(), (Writer)writer, (String)"UTF-8");
            return new JSONObject(writer.toString());
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String createMemo(Organization org, MemoType refType) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Memo/Create";
            JsonSerializer ser = new JsonSerializer(true);
            Form form = new Form();
            form.param("document", ser.serialize((Object)refType));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Memo/Create", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return ((String)response.readEntity(String.class)).replace("\"", "");
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Create folder", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String createCase(Organization org, CaseType caseType) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Case/Create";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)caseType));
            form.param("notificationNewCaseWorker", Boolean.toString(true));
            form.param("notificationNewInstruction", Boolean.toString(false));
            form.param("assignToResponsibleEmployeeOU", Boolean.toString(true));
            form.param("startReview", Boolean.toString(false));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Case/Create", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return ((String)response.readEntity(String.class)).replace("\"", "");
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Create case", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String createContact(Organization org, ContactType contact) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Contact/Create";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)contact));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Contact/Create", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return ((String)response.readEntity(String.class)).replace("\"", "");
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Create contact", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String createCompany(Organization org, CompanyType com) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Company/Create";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)com));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Company/Create", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return ((String)response.readEntity(String.class)).replace("\"", "");
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Create company", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String updateIndividual(Organization org, IndividualType ind) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Individual/Update";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)ind));
            form.param("pushAclToSubRecords", Boolean.toString(false));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Individual/Update", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return (String)response.readEntity(String.class);
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Update individual", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String updateCase(Organization org, CaseType caseType) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Case/Update";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)caseType));
            form.param("pushAclToSubRecords", Boolean.toString(false));
            form.param("pushJournalKeyToSubRecords", Boolean.toString(false));
            form.param("notificationNewCaseWorker", Boolean.toString(false));
            form.param("notificationNewInstruction", Boolean.toString(false));
            form.param("assignToResponsibleEmployeeOU", Boolean.toString(false));
            form.param("startReview", Boolean.toString(false));
            form.param("pushKeywordsToSubRecords", Boolean.toString(false));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Case/Update", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return (String)response.readEntity(String.class);
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Update case", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String updateFolder(Organization org, FolderType folderType) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Folder/Update";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)folderType));
            form.param("pushAclToSubRecords", Boolean.toString(false));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Folder/Update", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return (String)response.readEntity(String.class);
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Update folder", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static String updateContact(Organization org, ContactType contact) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Contact/Update";
            JsonSerializer ser = new JsonSerializer();
            Form form = new Form();
            form.param("document", ser.serialize((Object)contact));
            form.param("pushAclToSubRecords", Boolean.toString(false));
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/Contact/Update", "application/json");
            Response response = builder.accept(new String[]{"text/plain"}).post(entity);
            if (response.getStatus() == 200) {
                return (String)response.readEntity(String.class);
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Update contact", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static FlexibleDataSetType query(Organization org, DocumentFilterType filter) throws GoProDataStoreException {
        try {
            JsonSerializer ser = new JsonSerializer(true);
            String path = "Client/Data/View/Query";
            Form form = new Form();
            form.param("id", "00000000-0000-0000-0000-000000000000");
            form.param("getFilterValues", String.valueOf(false));
            form.param("filter", ser.serialize((Object)filter));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"########### QUERY ##############");
                logger.trace((Object)filter.toXMLString());
                logger.trace((Object)"--------------------------------");
                logger.trace((Object)ser.serialize((Object)filter));
                logger.trace((Object)"########### ##### ##############");
            }
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Data/View/Query", "application/json");
            Response response = builder.accept(new String[]{"application/json"}).post(entity);
            if (response.getStatus() == 200) {
                JSONObject json = RestHelper.toJSON(response);
                if (RemoteGoPro.GoPro.GOPRO_NET.equals((Object)org.getEndpoint().getGoproType()) && json.has("results")) {
                    return (FlexibleDataSetType)ser.deserialize(json.getJSONObject("results").toString(), FlexibleDataSetType.class);
                }
                return (FlexibleDataSetType)ser.deserialize(json.toString(), FlexibleDataSetType.class);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"## Filter causing error ###");
                logger.debug((Object)filter.toXMLString());
                logger.debug((Object)"-----------------------------------");
                logger.debug((Object)ser.serialize((Object)filter));
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("View query", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static ExternalDocumentType getExternalDocument(Organization org, String documentId, boolean getStream) throws GoProDataStoreException {
        try {
            Endpoint ep = org.getEndpoint();
            String path = String.format("Client/Data/Document/%s/%s", documentId, Boolean.valueOf(getStream).toString());
            Invocation.Builder builder = RestHelper.getBuilder(ep, path, "application/json");
            Response response = builder.accept(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                if (json != null) {
                    return (ExternalDocumentType)ser.deserialize(json.toString(), ExternalDocumentType.class);
                }
            } else {
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get document", response));
            }
            return null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static ListType getList(Organization org, String listKey) throws GoProDataStoreException {
        try {
            String path = "Client/Configuration/List/GetList";
            Form form = new Form();
            form.param("listId", listKey);
            form.param("id", "00000000-0000-0000-0000-000000000000");
            form.param("organisationId", "00000000-0000-0000-0000-000000000000");
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), "Client/Configuration/List/GetList", "application/json");
            Response response = builder.accept(new String[]{"application/json"}).post(entity);
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer(true);
                JSONObject json = RestHelper.toJSON(response);
                if (json != null) {
                    return (ListType)ser.deserialize(json.toString(), ListType.class);
                }
            } else {
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get List using key: " + listKey, response));
            }
            return null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static CompanyType getCompany(Organization org, String companyId) throws GoProDataStoreException {
        try {
            Endpoint ep = org.getEndpoint();
            String path = "Client/Data/Company/" + companyId;
            logger.debug((Object)("Get company by id: " + companyId));
            Invocation.Builder builder = RestHelper.getBuilder(ep, path, "application/json");
            Response response = builder.accept(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                if (json != null) {
                    return (CompanyType)ser.deserialize(json.toString(), CompanyType.class);
                }
            } else {
                if (response.getStatus() == 404) {
                    return null;
                }
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get company", response));
            }
            return null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static MemoType getMemo(Organization org, String memoId) throws GoProDataStoreException {
        try {
            Endpoint ep = org.getEndpoint();
            String path = "Client/Data/Memo/" + memoId;
            logger.debug((Object)("Get memo by id: " + memoId));
            Invocation.Builder builder = RestHelper.getBuilder(ep, path, "application/json");
            Response response = builder.accept(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                if (json != null) {
                    return (MemoType)ser.deserialize(json.toString(), MemoType.class);
                }
            } else {
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get memo", response));
            }
            return null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static FolderType getFolder(Organization org, String folderId) throws GoProDataStoreException {
        try {
            Endpoint ep = org.getEndpoint();
            String path = "Client/Data/Folder/" + folderId;
            logger.debug((Object)("Get folder by id: " + folderId));
            Invocation.Builder builder = RestHelper.getBuilder(ep, path, "application/json");
            Response response = builder.accept(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                if (json != null) {
                    return (FolderType)ser.deserialize(json.toString(), FolderType.class);
                }
            } else {
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get folder", response));
            }
            return null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static CaseType getCase(Organization org, String caseId) throws GoProDataStoreException {
        try {
            Endpoint ep = org.getEndpoint();
            String path = "Client/Data/Case/" + caseId;
            Invocation.Builder builder = RestHelper.getBuilder(ep, path, "application/json");
            Response response = builder.accept(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                if (json != null) {
                    return (CaseType)ser.deserialize(json.toString(), CaseType.class);
                }
            } else {
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get case", response));
            }
            return null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static List<CaseTemplateType> getCaseTemplates(Organization org) throws GoProDataStoreException {
        try {
            ArrayList<CaseTemplateType> list = new ArrayList<CaseTemplateType>();
            Endpoint ep = org.getEndpoint();
            String path = "Client/Configuration/Case/TemplateTree/General";
            Invocation.Builder builder = RestHelper.getBuilder(ep, "Client/Configuration/Case/TemplateTree/General", "application/json");
            Response response = builder.accept(new String[]{"application/json"}).get();
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                FlexibleDataSetType dataset = (FlexibleDataSetType)ser.deserialize(json.toString(), FlexibleDataSetType.class);
                for (FlexibleDataRowType row : dataset.getData().getRows()) {
                    String templateName = row.getColumnValue(2);
                    if (!StringUtil.isValid(templateName)) continue;
                    CaseTemplateType caseTemplate = new CaseTemplateType();
                    caseTemplate.setID(row.getID());
                    caseTemplate.setSubject(templateName);
                    caseTemplate.setDescription(row.getColumnValue(3));
                    list.add(caseTemplate);
                }
            } else {
                throw new GoProDataStoreException(RestHelper.parseErrorResponse("Get CaseTemplates", response));
            }
            return list;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    private static JSONObject toJSON(Response response) {
        String res = (String)response.readEntity(String.class);
        if (res != null && !res.equalsIgnoreCase("null")) {
            return new JSONObject(res);
        }
        return null;
    }

    public static final <T> T getDocumentInitiationData(Organization org, int documentType, String parentId, String templateId) throws GoProDataStoreException {
        try {
            String path = "Client/Data/Crud/Initiate";
            Form form = new Form();
            form.param("docType", String.valueOf(documentType));
            form.param("parentId", StringUtil.isValid(parentId) ? parentId : "");
            form.param("templateId", StringUtil.isValid(templateId) ? templateId : "");
            Entity entity = Entity.form((Form)form);
            Invocation.Builder builder = RestHelper.getBuilder(org.getEndpoint(), path, "application/json");
            Response response = builder.accept(new String[]{"application/json"}).post(entity);
            if (response.getStatus() == 200) {
                JsonSerializer ser = new JsonSerializer();
                JSONObject json = RestHelper.toJSON(response);
                DocumentBaseType doc = (DocumentBaseType)ser.deserialize(json.toString(), DocumentBaseType.class);
                return (T)doc;
            }
            throw new GoProDataStoreException(RestHelper.parseErrorResponse("Document InitiationData", response));
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    public static Invocation.Builder getBuilder(Endpoint endpoint, String urlPath, String mediaType) throws GoProDataStoreException {
        ClientConfig config = new ClientConfig();
        Client client = ClientBuilder.newClient((Configuration)config);
        WebTarget target = client.target(endpoint.getHostname());
        Invocation.Builder builder = target.path(urlPath).request(new String[]{mediaType});
        if (RemoteGoPro.GoPro.GOPRO_NET.equals((Object)endpoint.getGoproType())) {
            String authCookie = RestHelper.getAuthCookie(endpoint);
            return builder.header("Cookie", (Object)authCookie);
        }
        return builder;
    }

    private static String getAuthCookie(Endpoint endpoint) throws GoProDataStoreException {
        String authCookie = null;
        if (RemoteGoPro.GoPro.GOPRO_NET.equals((Object)endpoint.getGoproType())) {
            JSONObject job = new JSONObject();
            job.put("_type", (Object)"UserCredentialsType");
            job.put("username", (Object)endpoint.getUsername());
            job.put("password", (Object)endpoint.getPassword());
            Form form = new Form();
            form.param("credentials", job.toString());
            Entity entity = Entity.form((Form)form);
            Response authenticateResponse = RestHelper.authenticate(endpoint, (Entity<Form>)entity);
            if (authenticateResponse.getStatus() == 200) {
                MultivaluedMap headers = authenticateResponse.getHeaders();
                List<String> cookieKeys = Arrays.asList("ASP.NET_SessionId", ".ASPXAUTH");
                ArrayList<String> combinedCookies = new ArrayList<String>();
                List list = (List)headers.get((Object)"Set-Cookie");
                for (Object o : list) {
                    for (String cookieString : o.toString().split(";")) {
                        String[] cookiePair = cookieString.split("=");
                        if (cookiePair.length != 2) continue;
                        String key = cookiePair[0];
                        String val = cookiePair[1];
                        if ("".equals(val) || !cookieKeys.contains(key)) continue;
                        combinedCookies.add(cookieString);
                    }
                }
                authCookie = combinedCookies.stream().collect(Collectors.joining(";"));
            } else {
                throw new GoProDataStoreException("Authentication failed, server status: " + authenticateResponse.getStatus());
            }
        }
        return authCookie;
    }

    public static HashMap<String, Object> getAuthenticationHeaders(Endpoint endpoint) throws GoProDataStoreException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (RemoteGoPro.GoPro.GOPRO_NET.equals((Object)endpoint.getGoproType())) {
            JSONObject job = new JSONObject();
            job.put("_type", (Object)"UserCredentialsType");
            job.put("username", (Object)endpoint.getUsername());
            job.put("password", (Object)endpoint.getPassword());
            Form form = new Form();
            form.param("credentials", job.toString());
            Entity entity = Entity.form((Form)form);
            Response authenticateResponse = RestHelper.authenticate(endpoint, (Entity<Form>)entity);
            MultivaluedMap multivaluedMap = authenticateResponse.getHeaders();
        }
        return map;
    }

    private static Response authenticate(Endpoint endpoint, Entity<Form> entity) throws GoProDataStoreException {
        if (endpoint == null) {
            throw new GoProDataStoreException("No Endpoint is defined with the organization");
        }
        try {
            ClientConfig config = new ClientConfig();
            Client client = ClientBuilder.newClient((Configuration)config);
            WebTarget target = client.target(endpoint.getHostname());
            Response response = target.path("Client/Access/Login").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new String[]{"application/json"}).post(entity);
            if (response.getStatus() == 200) {
                return response;
            }
            throw new GoProDataStoreException("Invalid user/pass, response from server: " + response.getStatus());
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    private static String parseErrorResponse(String methodMessage, Response response) {
        try {
            JSONObject errObj = RestHelper.toJSON(response);
            if (errObj.has("message")) {
                return String.format("Error in: %s. Server message: %s", methodMessage, errObj.getString("message"));
            }
        }
        catch (JsonException jsonException) {
            // empty catch block
        }
        return String.format("Error in: %s. Status code: %d", methodMessage, response.getStatus());
    }

    public static void cleanUpMetadata(DocumentType caseType) {
        ArrayList<String> keyList = new ArrayList<String>();
        Iterator it = caseType.iterateMetaDataEntries();
        while (it.hasNext()) {
            MetaDataType meta = (MetaDataType)it.next();
            if (keyList.contains(meta.getName())) {
                it.remove();
                continue;
            }
            keyList.add(meta.getName());
        }
    }
}

