/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.filters;

import java.util.HashSet;
import java.util.Set;
import net.gopro.selfservice.data.BaseDocument;

public class MetaDataSearchFilter {
    private Set<Class<? extends BaseDocument>> documentTypes = new HashSet<Class<? extends BaseDocument>>();
    private String metadataKey;
    private String metadataValue;
    private FilterOperator operator = FilterOperator.EQUALS;

    public MetaDataSearchFilter(String key, String value) {
        this.metadataKey = key;
        this.metadataValue = value;
    }

    public MetaDataSearchFilter(String key, String value, FilterOperator operator) {
        this.metadataKey = key;
        this.metadataValue = value;
        this.operator = operator;
    }

    public void addDocumentType(Class<? extends BaseDocument> classType) {
        this.documentTypes.add(classType);
    }

    public Set<Class<? extends BaseDocument>> getDocumentTypes() {
        return this.documentTypes;
    }

    public String getMetadataKey() {
        return this.metadataKey;
    }

    public String getMetadataValue() {
        return this.metadataValue;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterOperator operator) {
        this.operator = operator;
    }

    public static enum FilterOperator {
        EQUALS,
        LIKE,
        ISNULL,
        ISNOTNULL;

    }
}

