/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.filters;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.data.BaseDocument;

public final class DocumentSearchFilter {
    private Set<Class<? extends BaseDocument>> documentTypes = new HashSet<Class<? extends BaseDocument>>();
    private DeletionStatus deletionStatus;
    private String documentOwnerId;
    private String documentTemplateId;
    private String searchKeyword;
    private Date dateFrom;
    private Date dateTo;
    private List<String> targetgroupIds = new ArrayList<String>();
    private List<String> companyIds = new ArrayList<String>();

    public DocumentSearchFilter() {
        this.deletionStatus = DeletionStatus.NOT_DELETED;
    }

    public DocumentSearchFilter(String userId, String keyword) {
        this.deletionStatus = DeletionStatus.NOT_DELETED;
        this.documentOwnerId = userId;
        this.searchKeyword = keyword;
    }

    public void addDocumentType(Class<? extends BaseDocument> classType) {
        this.documentTypes.add(classType);
    }

    public Set<Class<? extends BaseDocument>> getDocumentTypes() {
        return this.documentTypes;
    }

    public DeletionStatus getDeletionStatus() {
        return this.deletionStatus;
    }

    public void setDeletionStatus(DeletionStatus deletionStatus) {
        this.deletionStatus = deletionStatus;
    }

    public String getDocumentOwnerId() {
        return this.documentOwnerId;
    }

    public void setDocumentOwnerId(String documentOwnerId) {
        this.documentOwnerId = documentOwnerId;
    }

    public String getSearchKeyword() {
        return this.searchKeyword;
    }

    public void setSearchKeyword(String searchKeyword) {
        this.searchKeyword = searchKeyword;
    }

    public String getDocumentTemplateId() {
        return this.documentTemplateId;
    }

    public void setDocumentTemplateId(String documentTemplateId) {
        this.documentTemplateId = documentTemplateId;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public List<String> getTargetgroupIds() {
        return this.targetgroupIds;
    }

    public List<String> getCompanyIds() {
        return this.companyIds;
    }

    public static enum DeletionStatus {
        DELETED,
        NOT_DELETED,
        ALL;

    }
}

