/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.filters;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.util.StringUtil;

public class DocumentFilter {
    private Set<Class<? extends BaseDocument>> documentTypes = new HashSet<Class<? extends BaseDocument>>();
    private DeletionStatus deletionStatus = DeletionStatus.NOT_DELETED;
    private String ownerId;
    private String companyId;
    private String formTemplateId;
    private String caseTemplateId;
    private String organizationId;
    private String targetgroupId;
    private Date createdDateFrom;
    private Date createdDateTo;
    private Date modifiedDateFrom;
    private Date modifiedDateTo;
    private Date completedDateFrom;
    private Date completedDateTo;
    private boolean isSigned = false;
    private Date signingCompletedDateFrom;
    private Date signingCompletedDateTo;

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getFormTemplateId() {
        return this.formTemplateId;
    }

    public void setFormTemplateId(String formTemplateId) {
        this.formTemplateId = formTemplateId;
    }

    public String getCaseTemplateId() {
        return this.caseTemplateId;
    }

    public void setCaseTemplateId(String caseTemplateId) {
        this.caseTemplateId = caseTemplateId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public boolean validate() throws IllegalArgumentException {
        String[] lookupIds;
        if (this.documentTypes.isEmpty()) {
            throw new IllegalArgumentException("No document type has been selected for the filter");
        }
        if (this.isSigned()) {
            return true;
        }
        for (String id : lookupIds = new String[]{this.ownerId, this.companyId, this.formTemplateId, this.caseTemplateId, this.organizationId, this.targetgroupId}) {
            if (!StringUtil.isValid(id)) continue;
            return true;
        }
        throw new IllegalArgumentException("No lookup type has been defined. Use ownerId, companyId, casetemplateId, formtemplate, organizationId or targetgroupId");
    }

    public Set<Class<? extends BaseDocument>> getDocumentTypes() {
        return this.documentTypes;
    }

    public void addDocumentType(Class<? extends BaseDocument> classType) {
        this.documentTypes.add(classType);
    }

    public DeletionStatus getDeletionStatus() {
        return this.deletionStatus;
    }

    public void setDeletionStatus(DeletionStatus deletionStatus) {
        this.deletionStatus = deletionStatus;
    }

    public String getTargetgroupId() {
        return this.targetgroupId;
    }

    public void setTargetgroupId(String targetgroupId) {
        this.targetgroupId = targetgroupId;
    }

    public Date getCreatedDateFrom() {
        return this.createdDateFrom;
    }

    public void setCreatedDateFrom(Date createdDateFrom) {
        this.createdDateFrom = createdDateFrom;
    }

    public Date getCreatedDateTo() {
        return this.createdDateTo;
    }

    public void setCreatedDateTo(Date createdDateTo) {
        this.createdDateTo = createdDateTo;
    }

    public Date getModifiedDateFrom() {
        return this.modifiedDateFrom;
    }

    public void setModifiedDateFrom(Date modifiedDateFrom) {
        this.modifiedDateFrom = modifiedDateFrom;
    }

    public Date getModifiedDateTo() {
        return this.modifiedDateTo;
    }

    public void setModifiedDateTo(Date modifiedDateTo) {
        this.modifiedDateTo = modifiedDateTo;
    }

    public Date getCompletedDateFrom() {
        return this.completedDateFrom;
    }

    public void setCompletedDateFrom(Date completedDateFrom) {
        this.completedDateFrom = completedDateFrom;
    }

    public Date getCompletedDateTo() {
        return this.completedDateTo;
    }

    public void setCompletedDateTo(Date completedDateTo) {
        this.completedDateTo = completedDateTo;
    }

    public Date getSigningCompletedDateFrom() {
        return this.signingCompletedDateFrom;
    }

    public void setSigningCompletedDateFrom(Date signingCompletedDateFrom) {
        this.signingCompletedDateFrom = signingCompletedDateFrom;
    }

    public Date getSigningCompletedDateTo() {
        return this.signingCompletedDateTo;
    }

    public void setSigningCompletedDateTo(Date signingCompletedDateTo) {
        this.signingCompletedDateTo = signingCompletedDateTo;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public void setSigned(boolean isSigned) {
        this.isSigned = isSigned;
    }

    public List<Class<? extends BaseDocument>> getExternalDocumentTypes() {
        ArrayList<Class<? extends BaseDocument>> list = new ArrayList<Class<? extends BaseDocument>>();
        for (Class<? extends BaseDocument> clazz : this.documentTypes) {
            if (!clazz.equals(ApplicationForm.class) && !clazz.equals(Attachment.class) && !clazz.equals(CompletedFormDocument.class)) continue;
            list.add(clazz);
        }
        return list;
    }

    public static enum DeletionStatus {
        DELETED,
        NOT_DELETED,
        ALL;

    }
}

