/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.filters;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.gopro.selfservice.data.AuditLogEntry;

public final class AuditLogFilter {
    private Set<String> userIds = new HashSet<String>();
    private Set<AuditLogEntry.Action> actions = new HashSet<AuditLogEntry.Action>();
    private Set<AuditLogEntry.DataType> datatypes = new HashSet<AuditLogEntry.DataType>();
    private String documentId = null;
    private String formTemplateId = null;
    private String caseTemplateId = null;
    private boolean isDetailedResults = false;
    private long dateFrom = 0L;
    private long dateTo = 0L;

    public final String getDocumentId() {
        return this.documentId;
    }

    public final void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public final Set<String> getUserIds() {
        return this.userIds;
    }

    public final Set<AuditLogEntry.Action> getActions() {
        return this.actions;
    }

    public final Set<AuditLogEntry.DataType> getDatatypes() {
        return this.datatypes;
    }

    public final long getDateFrom() {
        return this.dateFrom;
    }

    public final long getDateTo() {
        return this.dateTo;
    }

    public void addAction(AuditLogEntry.Action action) {
        this.actions.add(action);
    }

    public void removeAction(AuditLogEntry.Action action) {
        this.actions.remove((Object)action);
    }

    public void addUserId(String userId) {
        this.userIds.add(userId);
    }

    public void removeUserId(String userId) {
        this.userIds.remove(userId);
    }

    public void addDataType(AuditLogEntry.DataType datatype) {
        this.datatypes.add(datatype);
    }

    public void removeDataType(AuditLogEntry.DataType datatype) {
        this.datatypes.remove((Object)datatype);
    }

    public void setDateFilter(Date dateFrom, Date dateTo) {
        if (dateFrom != null) {
            this.dateFrom = dateFrom.getTime();
        }
        if (dateTo != null) {
            this.dateTo = dateTo.getTime();
        }
    }

    public boolean isDetailedResults() {
        return this.isDetailedResults;
    }

    public void setDetailedResults(boolean isDetailedResults) {
        this.isDetailedResults = isDetailedResults;
    }

    public void setFormTemplateId(String formtemplate) {
        this.formTemplateId = formtemplate;
    }

    public String getFormTemplateId() {
        return this.formTemplateId;
    }

    public String getCaseTemplateId() {
        return this.caseTemplateId;
    }

    public void setCaseTemplateId(String caseTemplateId) {
        this.caseTemplateId = caseTemplateId;
    }

    public boolean isValid() {
        return this.getActions().size() != 0 || this.getDatatypes().size() != 0 || this.getDocumentId() != null || this.getUserIds().size() != 0 || this.getDateFrom() != 0L || this.getDateTo() != 0L;
    }
}

