/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.datastore;

import is.hugvit.bird.BirdFile;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.data.CompanyType;
import net.gopro.gdf.data.ConjunctionListType;
import net.gopro.gdf.data.ContactType;
import net.gopro.gdf.data.DocumentBaseRefType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.DocumentType;
import net.gopro.gdf.data.ExternalDocumentType;
import net.gopro.gdf.data.ExternalDocumentVersionType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.FolderType;
import net.gopro.gdf.data.IResponseObjectType;
import net.gopro.gdf.data.IndividualType;
import net.gopro.gdf.data.ListType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ListValueType;
import net.gopro.gdf.data.MemoType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.NameType;
import net.gopro.gdf.data.PhoneNumberType;
import net.gopro.gdf.data.ReferenceType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.data.UserType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.selfservice.IGoProDataStore;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.data.gopro.GoProCompanyReference;
import net.gopro.selfservice.data.gopro.GoProContactReference;
import net.gopro.selfservice.data.gopro.GoProIndividualReference;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.datastore.GoProDataStore;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.gdf.GDFDataHelper;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.gdf.helpers.GDFMetadata;
import net.gopro.selfservice.gdf.helpers.RESTAddress;
import net.gopro.selfservice.gdf.helpers.RESTCase;
import net.gopro.selfservice.gdf.helpers.RESTCompany;
import net.gopro.selfservice.gdf.helpers.RESTContact;
import net.gopro.selfservice.gdf.helpers.RESTExternalDocument;
import net.gopro.selfservice.gdf.helpers.RESTIndividual;
import net.gopro.selfservice.gdf.helpers.RESTMemo;
import net.gopro.selfservice.gdf.helpers.RESTPhoneNumber;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;
import org.json.JSONObject;

public abstract class RESTDataStore
extends GoProDataStore
implements IGoProDataStore,
ClientRequestFilter {
    private static final Logger logger = Logger.getLogger(RESTDataStore.class);

    @Override
    public String getInfo() {
        return "GoPro REST DataStore using JSON/REST";
    }

    protected abstract Response authenticate(Organization var1) throws GoProDataStoreException;

    protected UserPrincipal getGoProUser(Organization org) throws GoProDataStoreException {
        UserPrincipal up;
        block5: {
            up = null;
            Endpoint ep = org.getEndpoint();
            if (ep == null) {
                throw new GoProDataStoreException("No Endpoint is defined with the organization");
            }
            logger.debug((Object)("Connection check: " + this.getInfo() + " : " + org.getEndpoint().getHostname() + "Client/Access/Login"));
            try {
                ClientConfig config = new ClientConfig();
                Client client = ClientBuilder.newClient((Configuration)config);
                WebTarget target = client.target(ep.getHostname());
                JSONObject job = new JSONObject();
                job.put("_type", (Object)"UserCredentialsType");
                job.put("username", (Object)ep.getUsername());
                job.put("password", (Object)ep.getPassword());
                Form form = new Form();
                form.param("credentials", job.toString());
                Entity entity = Entity.form((Form)form);
                Response response = target.path("Client/Access/Login").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new String[]{"application/json"}).post(entity);
                if (response.getStatus() == 200) {
                    JSONObject jb = this.toJSON(response);
                    if (jb.has("_type") && jb.getString("_type").equals("CurrentContextObject") && jb.has("currentuser")) {
                        JSONObject userObj = jb.getJSONObject("currentuser");
                        up = new UserPrincipal();
                        UserType profile = new UserType();
                        profile.setSubject(userObj.getString("subject"));
                        profile.setLoginName(userObj.getString("loginName"));
                        up.setUserProfile(profile);
                    }
                    break block5;
                }
                throw new GoProDataStoreException("Invalid user/pass, response from server: " + response.getStatus());
            }
            catch (Exception ex) {
                throw new GoProDataStoreException(ex);
            }
        }
        return up;
    }

    @Override
    public boolean testConnection(Organization org) throws GoProDataStoreException {
        try {
            UserPrincipal up = this.getGoProUser(org);
            return up != null;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    @Override
    public String createCase(BaseCase bc) throws GoProDataStoreException {
        try {
            String goproCaseId = null;
            Organization destination = ConfigService.getOrganization(bc.getOrganizationId());
            User user = this.getDocumentOwner(bc.getCreatedById(), bc, destination);
            UserPrincipal up = this.getGoProUser(destination);
            if (up == null || up.getUserProfile() == null) {
                throw new GoProDataStoreException("The GoPro user that Self Service uses was not found!");
            }
            GoProClientBaseReference clientRef = null;
            if (bc.isCompanyCase()) {
                Contact deletedContact;
                clientRef = user.getGoProContactReference(destination.getId(), bc.getContactId());
                if (clientRef == null && (deletedContact = UserService.getContact(bc.getContactId())) != null && deletedContact.isDeleted()) {
                    this.logger(1, "User has been removed as a contact: " + user.getFullname() + ". Link user back to the company to complete case creation!");
                }
            } else {
                clientRef = user.getGoProIndividualReference(destination.getId());
            }
            if (clientRef == null) {
                throw new SelfServiceException("The GoPro Contact/Individual reference for user " + user.getId() + " was not found!");
            }
            CaseType caseType = RESTCase.createCaseType(destination, (FormCase)bc);
            RESTCase.setCaseTypeACL(caseType, user, up, clientRef, destination);
            if (RemoteGoPro.GoPro.GOPRO_NET.equals((Object)destination.getEndpoint().getGoproType())) {
                caseType.setModifiedDate(null);
            }
            boolean isLinkedCase = false;
            boolean isResponseFolder = false;
            String linkedParentCaseId = null;
            if (bc instanceof FormCase && ((FormCase)bc).getParentId() != null) {
                String parentCaseId = ((FormCase)bc).getParentId();
                logger.debug((Object)("Current case is a secondary case. Parent Case Id: " + parentCaseId));
                BaseCase parentCase = CaseService.getCase(parentCaseId);
                if (parentCase == null) {
                    throw new SelfServiceException("Invalid parent Case ID! Parent Case not found, id: " + parentCaseId);
                }
                if (parentCase.isSent() && parentCase.getGoProId() != null) {
                    FormTemplate.SecondaryCaseHandling handling = FormTemplate.SecondaryCaseHandling.CREATE_AND_LINK;
                    if (parentCase instanceof FormCase) {
                        String formTemplateId = ((FormCase)parentCase).getFormtemplateId();
                        FormTemplate ft = FormService.getFormTemplate(formTemplateId, false);
                        handling = ft.getSecondaryHandling();
                    } else {
                        CaseTemplate ct = CaseService.getCaseTemplate(parentCase.getCaseTemplateId());
                        handling = ct.getSecondaryHandling();
                    }
                    if (FormTemplate.SecondaryCaseHandling.CREATE_AND_LINK.equals((Object)handling)) {
                        logger.debug((Object)"Secondary case handling: Create and link cases together");
                        isLinkedCase = true;
                        linkedParentCaseId = parentCase.getGoProId();
                    } else if (FormTemplate.SecondaryCaseHandling.RESPONSE.equals((Object)handling)) {
                        logger.debug((Object)"Secondary case handling: Create as a response under parent Case");
                        linkedParentCaseId = parentCase.getGoProId();
                        isResponseFolder = true;
                    }
                } else {
                    throw new SelfServiceException("The parent Case: " + parentCase.getSubject() + " has not yet been created in GoPro.");
                }
            }
            if (isResponseFolder) {
                String folderId = this.createGoProResponseFolder(destination, linkedParentCaseId, caseType, bc.getId());
                logger.debug((Object)("Created placeholder folder for secondary application. Folder Id: " + folderId));
                return folderId;
            }
            goproCaseId = RestHelper.createCase(destination, caseType);
            if (isLinkedCase && this.createGoProCaseReference(destination, linkedParentCaseId, goproCaseId)) {
                logger.debug((Object)"Created reference to Parent Case in GoPro");
            }
            logger.info((Object)("Case Created: id: " + goproCaseId));
            return goproCaseId;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new GoProDataStoreException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String updateCase(BaseCase bc) throws GoProDataStoreException {
        try {
            Organization destination = ConfigService.getOrganization(bc.getOrganizationId());
            UserPrincipal up = this.getGoProUser(destination);
            if (up == null || up.getUserProfile() == null) {
                throw new GoProDataStoreException("The GoPro user that Self Service uses was not found!");
            }
            CaseType caseType = RestHelper.getCase(destination, bc.getGoProId());
            if (caseType == null) {
                if (!(bc instanceof FormCase) || ((FormCase)bc).getParentId() == null) throw new SelfServiceException("The Case to be updated was not found in the target GoPro.  CaseId: " + bc.getGoProId());
                FolderType folderType = RestHelper.getFolder(destination, bc.getGoProId());
                if (folderType == null) throw new SelfServiceException("The Case or Folder to be updated was not found in the target GoPro.  Record Id: " + bc.getGoProId());
                caseType = folderType;
            }
            caseType.setCompletedDate(new Date(bc.getDateCompleted()));
            caseType.setSubject(bc.getSubject());
            String lookupListType = caseType instanceof CaseType ? "CaseStatuses" : "FolderStatuses";
            ListType goproStatusList = RestHelper.getList(destination, lookupListType);
            List statusList = ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
            StatusListItem statusItem = (StatusListItem)statusList.getListItem(bc.getStatusId());
            if (statusItem != null) {
                ListValueType listType = GDFDataHelper.getListValueType(Arrays.asList(statusItem.getSubject(), statusItem.getAlias()), goproStatusList);
                if (listType != null) {
                    ListValueRefType lStatus = new ListValueRefType();
                    lStatus.setID(listType.getID());
                    lStatus.setName(listType.getName());
                    caseType.setStatus(lStatus);
                } else if (goproStatusList != null && goproStatusList.getDefaultValue() != null) {
                    caseType.setStatus(goproStatusList.getDefaultValue());
                } else {
                    this.logger(2, "The GoPro Case Template does not have the Case Status: " + statusItem.getSubject() + ".  And the default status could not be set!");
                }
            }
            RestHelper.cleanUpMetadata((DocumentType)caseType);
            GDFMetadata.updateMetadata(bc, (DocumentBaseType)caseType);
            caseType.removeAllHistoryEntries();
            if (caseType instanceof CaseType) {
                return RestHelper.updateCase(destination, caseType);
            }
            if (!(caseType instanceof FolderType)) throw new GdfServiceException("Invalid document type from server");
            return RestHelper.updateFolder(destination, (FolderType)caseType);
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
    }

    @Override
    public String createSubDocument(SubDocument doc, BaseCase parent) throws GoProDataStoreException {
        try {
            String goproDocumentId = null;
            String parentId = parent.getGoProId();
            if (doc.getParentId() != null && !doc.getParentId().equals(doc.getCaseId())) {
                SubDocument parentResponse = CaseService.getSubDocument(doc.getParentId(), false);
                if (parentResponse != null && StringUtil.isValid(parentResponse.getGoProId())) {
                    parentId = parentResponse.getGoProId();
                } else {
                    throw new SelfServiceException("Parent Response document was not found, or has not been created in the Target GoPro.");
                }
            }
            Organization destination = ConfigService.getOrganization(parent.getOrganizationId());
            User user = this.getDocumentOwner(doc.getCreatedById(), parent, destination);
            GoProClientBaseReference clientRef = null;
            if (parent.isCompanyCase() && user.isContactForCompany(parent.getCompanyId())) {
                Contact contact = user.getContactByCompanyId(parent.getCompanyId());
                if (contact == null) {
                    throw new SelfServiceException("User is not a contact for the company which owns the Case!");
                }
                clientRef = user.getGoProContactReference(parent.getOrganizationId(), contact.getId());
            } else {
                clientRef = user.getGoProIndividualReference(destination.getId());
            }
            if (clientRef == null) {
                throw new SelfServiceException("The GoPro Contact Reference for user " + user.getId() + " was not found!");
            }
            if (doc instanceof Memo) {
                MetaDataType mAgent;
                MemoType memoType = RESTMemo.createMemoType(destination, parentId, (Memo)doc, user, clientRef);
                memoType.setParentID(parentId);
                if (parent instanceof FormCase && (mAgent = this.getAgentData(doc, (FormCase)parent)) != null) {
                    memoType.addMetaDataEntry(mAgent);
                }
                if (memoType.getOriginator() != null) {
                    memoType.setInvolvedParty(memoType.getOriginator());
                }
                goproDocumentId = RestHelper.createMemo(destination, memoType);
            } else if (doc instanceof ExternalDocument) {
                MetaDataType mAgent;
                ExternalDocumentType externalDocType = RESTExternalDocument.createExternalDocumentType(destination, parentId, (ExternalDocument)doc, user, clientRef);
                externalDocType.setParentID(parentId);
                if (parent instanceof FormCase && (mAgent = this.getAgentData(doc, (FormCase)parent)) != null) {
                    externalDocType.addMetaDataEntry(mAgent);
                }
                if (externalDocType.getOriginator() != null) {
                    externalDocType.setInvolvedParty(externalDocType.getOriginator());
                }
                goproDocumentId = RestHelper.createExternalDocument(destination, externalDocType);
            }
            if (goproDocumentId == null) {
                throw new GoProDataStoreException("Error creating document, no ID returned from GoPro");
            }
            return goproDocumentId;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
        catch (UserException ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    @Override
    public java.util.List<? extends SubDocument> getIncomingDocuments(Organization org) throws GoProDataStoreException {
        try {
            java.util.List<Memo> memoList;
            ArrayList<SubDocument> incomingList = new ArrayList<SubDocument>();
            long lastAttachmentSynchronization = this.getLastSyncTime(GoProDataStore.LocalType.ATTACHMENT, org);
            long lastMemoSynchronization = this.getLastSyncTime(GoProDataStore.LocalType.MEMO, org);
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            this.logger(1, "[" + org.getSubject() + "] Memo query: last modified used: " + df.format(new Date(lastMemoSynchronization)));
            this.logger(1, "[" + org.getSubject() + "] Attachment query: last modified used: " + df.format(new Date(lastAttachmentSynchronization)));
            java.util.List<ExternalDocument> attachmentList = this.getIncomingAttachments(org, lastAttachmentSynchronization);
            this.logger(1, "Incoming attachments for: " + org.getSubject() + ": " + attachmentList.size());
            if (attachmentList.size() > 0) {
                incomingList.addAll(attachmentList);
                long nextAttachmentTimeFilter = this.getNewestDocumentDate(attachmentList);
                logger.debug((Object)String.format("Of %d incoming docs: highest last modified: %s", attachmentList.size(), df.format(new Date(nextAttachmentTimeFilter))));
                logger.debug((Object)String.format("Current metadata date: %s", df.format(new Date(lastAttachmentSynchronization))));
                if (nextAttachmentTimeFilter > lastAttachmentSynchronization) {
                    lastAttachmentSynchronization = nextAttachmentTimeFilter;
                    logger.debug((Object)"## Attachment date updated ##");
                }
            }
            if ((memoList = this.getIncomingMemos(org, lastMemoSynchronization)).size() > 0) {
                this.logger(1, "Incoming memos for : " + org.getSubject() + " : " + memoList.size());
                incomingList.addAll(memoList);
                long nextMemoTimeFilter = this.getNewestDocumentDate(memoList);
                if (nextMemoTimeFilter > lastMemoSynchronization) {
                    lastMemoSynchronization = nextMemoTimeFilter;
                }
            }
            try {
                this.updateSyncTime(GoProDataStore.LocalType.ATTACHMENT, org, lastAttachmentSynchronization);
                this.updateSyncTime(GoProDataStore.LocalType.MEMO, org, lastMemoSynchronization);
            }
            catch (SelfServiceException ex) {
                this.logger(3, "Error updating Sync time: " + ex.getMessage());
            }
            return incomingList;
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
    }

    @Override
    public Map<BaseDocument, String> getStatusUpdates(Organization org) throws GoProDataStoreException {
        try {
            Date latestReponseDate;
            Date latestFolderDate;
            Date latestCaseDate;
            HashMap<BaseDocument, String> updateMap = new HashMap<BaseDocument, String>();
            UserPrincipal up = this.getGoProUser(org);
            if (up == null || up.getUserProfile() == null) {
                throw new GoProDataStoreException("The GoPro user that Self Service uses was not found!");
            }
            long lastCaseSynchronization = this.getLastSyncTime(GoProDataStore.LocalType.CASE, org);
            long lastFolderSynchronization = this.getLastSyncTime(GoProDataStore.LocalType.FOLDER, org);
            long lastReponseSynchronization = this.getLastSyncTime(GoProDataStore.LocalType.RESPONSE_DOCUMENTS, org);
            Calendar calCaseSync = Calendar.getInstance();
            calCaseSync.setTimeInMillis(lastCaseSynchronization);
            Calendar calFolderSync = Calendar.getInstance();
            calFolderSync.setTimeInMillis(lastFolderSynchronization);
            Calendar calResponseSync = Calendar.getInstance();
            calResponseSync.setTimeInMillis(lastReponseSynchronization);
            this.logger(0, org.getSubject() + " status update check: Cases: Last modified: " + calCaseSync.getTime().toGMTString());
            this.logger(0, org.getSubject() + " status update check: Folders: Last modified: " + calFolderSync.getTime().toGMTString());
            this.logger(0, org.getSubject() + " status update check: Responses: Last modified: " + calResponseSync.getTime().toGMTString());
            DocumentFilterType filter = new DocumentFilterType();
            filter.setID("00000000-0000-0000-0000-000000000000");
            filter.setSubject("");
            filter.setDocumentFormType(1005);
            filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
            filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
            filter.setLoadDefaultColumns(false);
            filter.setLoadColumns(Arrays.asList("_status[ListValueRefType]._objData[ListValueType]._name", "_modifiedDate"));
            filter.setSortColumn("_modifiedDate");
            filter.setSortDescending(false);
            filter.setStartRow(0);
            filter.setRowsCount(10000);
            BinaryFilterExpressionType dateFilter = new BinaryFilterExpressionType();
            dateFilter.setPropertyName("_modifiedDate");
            dateFilter.setOperator(FilterOperatorType.GREATER);
            dateFilter.setValue((Object)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(calCaseSync.getTime()));
            filter.setCustomFilter((FilterExpressionType)dateFilter);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)filter.toXMLString());
            }
            FlexibleDataSetType results = RestHelper.query(org, filter);
            long nextCaseSynchronization = lastCaseSynchronization;
            if (results != null && results.getData() != null && results.getData().getRowsCount() > 0 && (latestCaseDate = this.populateUpdatedDocuments(updateMap, results.getData().getRows(), org)) != null && latestCaseDate.getTime() > nextCaseSynchronization) {
                nextCaseSynchronization = latestCaseDate.getTime();
            }
            filter.setDocumentFormType(1045);
            filter.setLoadColumns(Arrays.asList("_status[ListValueRefType]._objData[ListValueType]._name", "_modifiedDate"));
            dateFilter.setPropertyName("_modifiedDate");
            dateFilter.setValue((Object)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(calFolderSync.getTime()));
            filter.setCustomFilter((FilterExpressionType)dateFilter);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)filter.toXMLString());
            }
            results = RestHelper.query(org, filter);
            long nextFolderSynchronization = lastFolderSynchronization;
            if (results != null && results.getData() != null && results.getData().getRowsCount() > 0 && (latestFolderDate = this.populateUpdatedDocuments(updateMap, results.getData().getRows(), org)) != null && latestFolderDate.getTime() > nextFolderSynchronization) {
                nextFolderSynchronization = latestFolderDate.getTime();
            }
            filter = new DocumentFilterType();
            filter.setID("00000000-0000-0000-0000-000000000000");
            filter.setSubject("");
            filter.setDocumentFormType(1003);
            filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
            filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
            filter.setLoadDefaultColumns(false);
            filter.setLoadColumns(Arrays.asList("_status[ListValueRefType]._objData[ListValueType]._name", "_modifiedDate"));
            filter.setSortColumn("_modifiedDate");
            filter.setSortDescending(false);
            dateFilter = new BinaryFilterExpressionType();
            dateFilter.setPropertyName("_modifiedDate");
            dateFilter.setOperator(FilterOperatorType.GREATER);
            dateFilter.setValue((Object)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(calResponseSync.getTime()));
            filter.setCustomFilter((FilterExpressionType)dateFilter);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)filter.toXMLString());
            }
            results = RestHelper.query(org, filter);
            long nextResponseSynchronization = lastReponseSynchronization;
            if (results != null && results.getData() != null && results.getData().getRowsCount() > 0 && (latestReponseDate = this.populateUpdatedDocuments(updateMap, results.getData().getRows(), org)) != null && latestReponseDate.getTime() > nextResponseSynchronization) {
                nextResponseSynchronization = latestReponseDate.getTime();
            }
            if (nextCaseSynchronization > lastCaseSynchronization) {
                this.updateSyncTime(GoProDataStore.LocalType.CASE, org, nextCaseSynchronization);
            }
            if (nextFolderSynchronization > lastFolderSynchronization) {
                this.updateSyncTime(GoProDataStore.LocalType.FOLDER, org, nextFolderSynchronization);
            }
            if (nextResponseSynchronization > lastReponseSynchronization) {
                this.updateSyncTime(GoProDataStore.LocalType.RESPONSE_DOCUMENTS, org, nextResponseSynchronization);
            }
            return updateMap;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    @Override
    public String getCaseNumber(String goproCaseId, Organization org) throws GoProDataStoreException {
        String goproCaseNumber = null;
        UserPrincipal up = this.getGoProUser(org);
        if (up == null || up.getUserProfile() == null) {
            throw new GoProDataStoreException("The GoPro user that Self Service uses was not found!");
        }
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1005);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        filter.setLoadDefaultColumns(false);
        filter.setLoadColumns(Arrays.asList("_caseNumber", "_documentNumber"));
        filter.addFilterDocumentID(goproCaseId);
        filter.setStartRow(0);
        filter.setRowsCount(10);
        FlexibleDataSetType results = RestHelper.query(org, filter);
        if (results != null && results.getData() != null && results.getData().getRowsCount() > 0) {
            for (FlexibleDataRowType row : results.getData().getRows()) {
                for (String caseNumer : row.getColumnValues()) {
                    if (!StringUtil.isValid(caseNumer)) continue;
                    goproCaseNumber = caseNumer;
                }
            }
        } else {
            filter = new DocumentFilterType();
            filter.setID("00000000-0000-0000-0000-000000000000");
            filter.setSubject("");
            filter.setDocumentFormType(1045);
            filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
            filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
            filter.setLoadDefaultColumns(false);
            filter.setLoadColumns(Arrays.asList("_topParentID"));
            filter.addFilterDocumentID(goproCaseId);
            results = RestHelper.query(org, filter);
            if (results != null && results.getData() != null && results.getData().getRowsCount() == 1) {
                return this.getCaseNumber(results.getData().getRow(0).getColumnValue(0), org);
            }
        }
        return goproCaseNumber;
    }

    @Override
    public String updateContact(User contact, GoProClientBaseReference ref) throws GoProDataStoreException {
        try {
            ContactType contactType;
            Organization destination = ConfigService.getOrganization(ref.getOrganizationId());
            if (ref instanceof GoProIndividualReference) {
                IndividualType ind = RestHelper.getIndividual(destination, ref.getGoproId());
                if (ind != null) {
                    ind.setSubject(contact.getFullname());
                    NameType name = new NameType();
                    name.setFirstName(contact.getFirstName());
                    name.setLastName(contact.getLastName());
                    name.setMiddleName(contact.getMiddleName());
                    name.setInitials(contact.getInitials());
                    ind.setName(name);
                    ind.removeAllEmailAddresses();
                    ind.addEmailAddress(contact.getEmail());
                    ind.removeAllPhoneNumbers();
                    java.util.List<PhoneNumberType> numberList = RESTPhoneNumber.createPhoneNumberTypes(destination, contact.getHomephoneNumber(), contact.getMobilephoneNumber());
                    for (PhoneNumberType pnt : numberList) {
                        ind.addPhoneNumber(pnt);
                    }
                    AddressType addressType = RESTAddress.createAddressType(destination, contact.getAddress());
                    if (ind.getAddressesCount() == 1) {
                        ind.setAddress(0, addressType);
                    } else {
                        ind.addAddress(addressType);
                    }
                    try {
                        if (StringUtil.isValid(contact.getProfileImage())) {
                            String filename = "profile-" + contact.getUsername();
                            BirdFile profileFile = SelfServiceEngine.getBirdSession().getDatabase().getFileByName(filename);
                            if (profileFile != null) {
                                byte[] image = IOUtils.toByteArray((InputStream)profileFile.getBody());
                                FileAttachmentType ft = new FileAttachmentType();
                                ft.setEncoding("UTF-8");
                                ft.setFileName(FilenameUtils.getName((String)contact.getProfileImage()));
                                ft.setFileSize((long)image.length);
                                ft.setMimeType("image/" + FilenameUtils.getExtension((String)ft.getFileName()).toLowerCase());
                                ft.setStream(image);
                                ind.setPhoto(ft);
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logger(2, "Could not retrieve profile image: " + ex.getMessage());
                    }
                    return RestHelper.updateIndividual(destination, ind);
                }
            } else if (ref instanceof GoProContactReference && (contactType = RestHelper.getContact(destination, ref.getGoproId())) != null) {
                Contact updatedContact = null;
                for (Contact ct : contact.getContactList()) {
                    if (!ct.getId().equals(((GoProContactReference)ref).getContactId())) continue;
                    updatedContact = ct;
                    break;
                }
                if (updatedContact != null) {
                    contactType.removeAllEmailAddresses();
                    if (updatedContact.getEmail() != null) {
                        contactType.addEmailAddress(updatedContact.getEmail());
                    }
                    RestHelper.updateContact(destination, contactType);
                    return contactType.getID();
                }
            }
            return null;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    protected String createRequestUrl(Organization org, String path) {
        return org.getEndpoint().getHostname() + path;
    }

    private JSONObject toJSON(Response response) {
        String jsonString = (String)response.readEntity(String.class);
        JSONObject job = new JSONObject(jsonString);
        return job;
    }

    private User getDocumentOwner(String userId, BaseCase bc, Organization organization) throws GoProDataStoreException, UserException, SelfServiceException {
        User user = UserService.getUser(userId);
        if (user == null) {
            throw new SelfServiceException("The document owner user account was not found.");
        }
        GoProIndividualReference goProIndividual = user.getGoProIndividualReference(organization.getId());
        if (goProIndividual != null && !this.isClientReferenceStillValid(organization, goProIndividual)) {
            this.logger(1, "Referenced client was not found in the target GoPro, a new one will be created.");
            goProIndividual.setDeleted(true);
            UserService.updateGoProClientReference(goProIndividual);
            user.getGoproClientReferences().remove(goProIndividual);
            goProIndividual = null;
        }
        if (goProIndividual == null) {
            String goproIndividualId = RESTIndividual.createIndividual(organization, user);
            goProIndividual = new GoProIndividualReference();
            goProIndividual.setUserId(user.getId());
            goProIndividual.setGoproId(goproIndividualId);
            goProIndividual.setOrganizationId(organization.getId());
            UserService.createGoProClientReference(goProIndividual);
            user.getGoproClientReferences().add(goProIndividual);
            IndividualType ind = RestHelper.getIndividual(organization, goproIndividualId);
            if (ind.getEmailAddressesCount() == 0) {
                ind.addEmailAddress(user.getEmail());
            }
            AddressType addressType = RESTAddress.createAddressType(organization, user.getAddress());
            if (ind.getAddressesCount() == 1) {
                ind.setAddress(0, addressType);
            } else {
                ind.addAddress(addressType);
            }
            RestHelper.updateIndividual(organization, ind);
            logger.info((Object)"Updated existing individual record in GoPro");
        }
        if (bc.isCompanyCase() && user.isContactForCompany(bc.getCompanyId())) {
            Contact contact;
            Company com = UserService.getCompany(bc.getCompanyId());
            GoProCompanyReference companyRef = com.getGoProCompanyReference(organization.getId());
            if (companyRef != null && !this.isCompanyReferenceStillValid(organization, companyRef)) {
                this.logger(1, "Referenced company (" + com.getName() + ") was not found in the target GoPro, a new one will be created.");
                String newGoProCompanyId = RESTCompany.createCompany(organization, com);
                companyRef.setGoproCompanyId(newGoProCompanyId);
                UserService.updateGoProCompanyReference(companyRef);
            }
            if (companyRef == null) {
                String goproCompanyId = RESTCompany.createCompany(organization, com);
                companyRef = new GoProCompanyReference();
                companyRef.setCompanyId(com.getId());
                companyRef.setGoproCompanyId(goproCompanyId);
                companyRef.setOrganizationId(organization.getId());
                UserService.createGoProCompanyReference(companyRef);
                com.getGoproCompanyReferences().add(companyRef);
            }
            if ((contact = user.getContactByCompanyId(bc.getCompanyId())) == null) {
                throw new SelfServiceException("Contact entry is missing or has been deleted for company: " + bc.getCompanyId());
            }
            String contactId = contact.getId();
            GoProContactReference contactRef = user.getGoProContactReference(organization.getId(), contactId);
            if (contactRef != null && !this.isClientReferenceStillValid(organization, contactRef)) {
                this.logger(1, "Referenced contact was not found in the target GoPro, a new one will be created.");
                contactRef.setDeleted(true);
                UserService.updateGoProClientReference(contactRef);
                user.getGoproClientReferences().remove(contactRef);
                contactRef = null;
            }
            if (contactRef == null) {
                String goproContactId = RESTContact.createContact(organization, user, com, goProIndividual, companyRef);
                contactRef = new GoProContactReference();
                contactRef.setUserId(user.getId());
                contactRef.setContactId(contactId);
                contactRef.setOrganizationId(organization.getId());
                contactRef.setGoproId(goproContactId);
                UserService.createGoProClientReference(contactRef);
                user.getGoproClientReferences().add(contactRef);
                this.logger(1, "Created GoPro Contact Reference");
            }
        }
        return user;
    }

    protected boolean isCompanyReferenceStillValid(Organization organization, GoProCompanyReference ref) throws GoProDataStoreException {
        CompanyType company = RestHelper.getCompany(organization, ref.getGoproCompanyId());
        return company != null;
    }

    protected boolean isClientReferenceStillValid(Organization organization, GoProClientBaseReference client) throws GoProDataStoreException {
        DocumentFilterType filter = new DocumentFilterType();
        filter.addFilterDocumentID(client.getGoproId());
        if (client instanceof GoProIndividualReference) {
            filter.setDocumentFormType(1009);
        } else if (client instanceof GoProContactReference) {
            filter.setDocumentFormType(1010);
        }
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        FlexibleDataSetType dataset = RestHelper.query(organization, filter);
        return dataset.getData().getRowsCount() == 1;
    }

    protected boolean createGoProCaseReference(Organization org, String parentCaseId, String caseId) throws GoProDataStoreException {
        ReferenceType ref = (ReferenceType)RestHelper.getDocumentInitiationData(org, 1004, parentCaseId, null);
        DocumentBaseRefType childRef = new DocumentBaseRefType();
        childRef.setID(caseId);
        ref.setInternalDocument(childRef);
        DocumentCollectionType coll = new DocumentCollectionType();
        coll.addDocument((DocumentBaseType)ref);
        String createLink1 = RestHelper.createReference(org, ref);
        ref = (ReferenceType)RestHelper.getDocumentInitiationData(org, 1004, caseId, null);
        childRef = new DocumentBaseRefType();
        childRef.setID(parentCaseId);
        ref.setInternalDocument(childRef);
        coll = new DocumentCollectionType();
        coll.addDocument((DocumentBaseType)ref);
        String createLink2 = RestHelper.createReference(org, ref);
        return createLink1 != null && createLink2 != null;
    }

    protected String createGoProResponseFolder(Organization organization, String parentCaseId, CaseType caseType, String localCaseId) throws GoProDataStoreException {
        FolderType folder = (FolderType)RestHelper.getDocumentInitiationData(organization, 1045, parentCaseId, null);
        folder.setSubject(caseType.getSubject());
        MetaDataType meta = new MetaDataType();
        meta.setName("SelfServiceId");
        meta.setValue(localCaseId);
        meta.setValueType(MetaValueType.STRING);
        folder.addMetaDataEntry(meta);
        for (MetaDataType me : caseType.getMetaDataEntries()) {
            if (me.getName().equals("SelfServiceId")) continue;
            folder.addMetaDataEntry(me);
        }
        return RestHelper.createFolder(organization, folder);
    }

    protected MetaDataType getAgentData(SubDocument sub, FormCase parentCase) throws SelfServiceException {
        String agent;
        MetaDataType ma = null;
        String formtemplateId = parentCase.getFormtemplateId();
        FormTemplate ft = FormService.getFormTemplate(formtemplateId, false);
        if (ft.getExtendedData() != null && (agent = ft.getExtendedData().getGoproAgent()) != null && !"".equals(agent)) {
            ma = new MetaDataType();
            ma.setName("$GoProWebServicesAgent");
            ma.setValueType(MetaValueType.STRING);
            ma.setValue(agent);
        }
        return ma;
    }

    private final java.util.List<ExternalDocument> getIncomingAttachments(Organization organization, long lastSyncTime) throws GoProDataStoreException, GdfServiceException {
        try {
            FlexibleDataSetType attachmentDocs;
            List statusList = ConfigService.getList("0009A47DD30D261C0000012110DFE58C");
            ArrayList<ExternalDocument> attachmentList = new ArrayList<ExternalDocument>();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(lastSyncTime);
            DocumentFilterType filter = this.getIncomingDocumentsHeaderFilter(cal, 1025);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"## Get incoming documents filter ###");
                logger.trace((Object)filter.toXMLString());
            }
            if ((attachmentDocs = RestHelper.query(organization, filter)) != null && attachmentDocs.getData() != null && attachmentDocs.getData().getRowsCount() > 0) {
                ArrayList<String> attachmentIdlist = new ArrayList<String>();
                for (FlexibleDataRowType row : attachmentDocs.getData().getRows()) {
                    if (row.getDocumentType() != 1025) continue;
                    attachmentIdlist.add(row.getID());
                }
                for (String attachmentID : attachmentIdlist) {
                    BaseCase parentCase;
                    ExternalDocumentType externalDoc;
                    SubDocument existingDoc = CaseService.getSubDocumentByGoProId(attachmentID);
                    if (existingDoc != null || (externalDoc = RestHelper.getExternalDocument(organization, attachmentID, true)) == null) continue;
                    ExternalDocumentVersionType version = externalDoc.getCurrentVersion();
                    FileAttachmentType fileData = null;
                    if (version != null) {
                        fileData = version.getAttachment();
                    }
                    if ((parentCase = this.getParentCase(externalDoc.getTopParentID(), organization)) != null) {
                        byte[] stream;
                        String parentId = null;
                        boolean isParentUnResolved = false;
                        boolean isSecondaryParent = false;
                        if (externalDoc.getParentID() != null && !externalDoc.getParentID().equals(parentCase.getGoProId())) {
                            try {
                                SubDocument parentDocument = CaseService.getSubDocumentByGoProId(externalDoc.getParentID());
                                if (parentDocument != null) {
                                    parentId = parentDocument.getId();
                                    if (!parentDocument.getCaseId().equals(parentCase.getId())) {
                                        isSecondaryParent = true;
                                    }
                                } else {
                                    String resolvedId = this.resolveSecondaryParentId(parentCase, (IResponseObjectType)externalDoc);
                                    if (resolvedId != null) {
                                        logger.info((Object)("Resolved secondary parentId: " + resolvedId));
                                        parentId = resolvedId;
                                        isSecondaryParent = true;
                                    } else {
                                        parentId = externalDoc.getParentID();
                                    }
                                    isParentUnResolved = true;
                                }
                            }
                            catch (SelfServiceException parentDocument) {
                                // empty catch block
                            }
                        }
                        if ((stream = fileData.getStream()) == null || stream.length <= 0) continue;
                        Attachment in = new Attachment();
                        if (isSecondaryParent) {
                            in.setParentId(parentId);
                            BaseCase bcParent = CaseService.getCase(parentId);
                            if (bcParent != null) {
                                in.setCaseId(bcParent.getId());
                            } else {
                                SubDocument subParent = CaseService.getSubDocument(parentId, false);
                                if (subParent != null) {
                                    in.setCaseId(subParent.getCaseId());
                                }
                            }
                        } else {
                            in.setCaseId(parentCase.getId());
                            if (parentId != null) {
                                in.setParentId(parentId);
                                in.setParentIdDirty(isParentUnResolved);
                            }
                        }
                        logger.debug((Object)("Secondary: CaseId: " + in.getCaseId() + " parentId: " + in.getParentId()));
                        in.setFromGoPro(true);
                        in.setGoProId(externalDoc.getID());
                        in.setSent(true);
                        in.setSubject(externalDoc.getSubject());
                        in.setBody(externalDoc.getBody());
                        in.setDateCreated(externalDoc.getCreationDate().getTime());
                        in.setDateModified(externalDoc.getModifiedDate().getTime());
                        in.setFilename(fileData.getFileName());
                        in.setFilesize(fileData.getFileSize());
                        in.setMimetype(fileData.getMimeType());
                        in.setStream(stream);
                        if (externalDoc.getStatus() != null) {
                            in.setStatusId(this.getStatusId(statusList, externalDoc.getStatus().getName()));
                        }
                        if (parentCase instanceof Case) {
                            in.setCreatedById(parentCase.getCreatedById());
                        }
                        attachmentList.add(in);
                        continue;
                    }
                    this.logger(2, "No Parent Case was found for the incoming attachment. GoPro Id: " + externalDoc.getTopParentID());
                }
            }
            return attachmentList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new GoProDataStoreException(ex);
        }
    }

    private java.util.List<Memo> getIncomingMemos(Organization organization, long lastSyncTime) throws GoProDataStoreException, GdfServiceException {
        try {
            List statusList = ConfigService.getList("00F9E89D6203E1AB00000121159B3979");
            ArrayList<Memo> memoList = new ArrayList<Memo>();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(lastSyncTime);
            DocumentFilterType filter = this.getIncomingDocumentsHeaderFilter(cal, 1028);
            FlexibleDataSetType memoDocs = RestHelper.query(organization, filter);
            if (memoDocs.getData().getRowsCount() > 0) {
                ArrayList<String> memoIdlist = new ArrayList<String>();
                for (FlexibleDataRowType row : memoDocs.getData().getRows()) {
                    if (row.getDocumentType() != 1028) continue;
                    memoIdlist.add(row.getID());
                }
                for (String memoId : memoIdlist) {
                    SubDocument sub = CaseService.getSubDocument(memoId, false);
                    if (sub != null) {
                        logger.info((Object)String.format("Memo %s, already exists.  Skipping memo.", sub.getSubject()));
                        continue;
                    }
                    MemoType memoDoc = RestHelper.getMemo(organization, memoId);
                    if (memoDoc == null) continue;
                    BaseCase parentCase = this.getParentCase(memoDoc.getTopParentID(), organization);
                    String parentId = null;
                    boolean isParentUnResolved = false;
                    if (parentCase == null) continue;
                    boolean isSecondaryParent = false;
                    if (memoDoc.getParentID() != null && !memoDoc.getParentID().equals(parentCase.getGoProId())) {
                        logger.debug((Object)"Check for parent other than the Case.");
                        try {
                            SubDocument parentDocument = CaseService.getSubDocumentByGoProId(memoDoc.getParentID());
                            if (parentDocument != null) {
                                parentId = parentDocument.getId();
                                if (!parentDocument.getCaseId().equals(parentCase.getId())) {
                                    isSecondaryParent = true;
                                }
                            } else {
                                String resolvedId = this.resolveSecondaryParentId(parentCase, (IResponseObjectType)memoDoc);
                                if (resolvedId != null) {
                                    logger.debug((Object)("Resolved secondary parentId: " + resolvedId));
                                    parentId = resolvedId;
                                    isSecondaryParent = true;
                                } else {
                                    parentId = memoDoc.getParentID();
                                }
                                isParentUnResolved = true;
                            }
                        }
                        catch (SelfServiceException parentDocument) {
                            // empty catch block
                        }
                    }
                    Memo in = new Memo();
                    if (isSecondaryParent) {
                        in.setParentId(parentId);
                        BaseCase bcParent = CaseService.getCase(parentId);
                        if (bcParent != null) {
                            in.setCaseId(bcParent.getId());
                        } else {
                            SubDocument subParent = CaseService.getSubDocument(parentId, false);
                            if (subParent != null) {
                                in.setCaseId(subParent.getCaseId());
                            }
                        }
                    } else {
                        in.setCaseId(parentCase.getId());
                        if (parentId != null) {
                            in.setParentId(parentId);
                            in.setParentIdDirty(isParentUnResolved);
                        }
                    }
                    logger.debug((Object)("Secondary: CaseId: " + in.getCaseId() + " parentId: " + in.getParentId()));
                    in.setFromGoPro(true);
                    in.setGoProId(memoDoc.getID());
                    in.setSent(true);
                    in.setSubject(memoDoc.getSubject());
                    in.setBody(memoDoc.getBody());
                    in.setDateCreated(memoDoc.getCreationDate().getTime());
                    in.setDateModified(memoDoc.getModifiedDate().getTime());
                    if (memoDoc.getStatus() != null) {
                        in.setStatusId(this.getStatusId(statusList, memoDoc.getStatus().getName()));
                    }
                    if (parentCase instanceof Case) {
                        in.setCreatedById(parentCase.getCreatedById());
                    }
                    memoList.add(in);
                }
            }
            return memoList;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    private BaseCase getParentCase(String goproDocumentId, Organization org) throws GoProDataStoreException {
        try {
            if (!StringUtil.isValid(goproDocumentId)) {
                this.logger(2, "GetParentCase: The specified gopro document Id is null ");
                return null;
            }
            BaseCase bc = CaseService.getCaseByGoProId(goproDocumentId, org.getId());
            if (bc != null) {
                this.logger(1, "Found parent Case with local search");
                return bc;
            }
            CaseType caseType = RestHelper.getCase(org, goproDocumentId);
            if (caseType != null) {
                String localCaseId = null;
                for (MetaDataType meta : caseType.getMetaDataEntries()) {
                    if (!"CommunityId".equals(meta.getName()) && !"SelfServiceId".equals(meta.getName()) || !StringUtil.isValid(meta.getValue())) continue;
                    localCaseId = meta.getValue();
                    break;
                }
                if (localCaseId != null && (bc = CaseService.getCase(localCaseId)) != null) {
                    this.logger(1, "Found Parent Case with remote GoPro Lookup");
                    return bc;
                }
            }
            return null;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    private DocumentFilterType getIncomingDocumentsHeaderFilter(Calendar lastModified, int docType) {
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(docType);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        filter.setSortColumn("_modifiedDate");
        filter.setSortDescending(false);
        BinaryFilterExpressionType dateFilter = new BinaryFilterExpressionType();
        dateFilter.setPropertyName("_modifiedDate");
        dateFilter.setOperator(FilterOperatorType.GREATER);
        dateFilter.setValue((Object)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(lastModified));
        if (docType == 1005) {
            filter.setCustomFilter((FilterExpressionType)dateFilter);
        } else {
            ConjunctionListType filterList = new ConjunctionListType();
            BinaryFilterExpressionType citizenFilter = new BinaryFilterExpressionType();
            citizenFilter.setPropertyName("_publishTos");
            citizenFilter.setOperator(FilterOperatorType.CONTAINSONE);
            ArrayList<String> inValues = new ArrayList<String>();
            inValues.add("Self Service");
            citizenFilter.setInValues(inValues);
            filterList.addElement((FilterExpressionType)citizenFilter);
            filterList.addElement((FilterExpressionType)dateFilter);
            filter.setCustomFilter((FilterExpressionType)filterList);
        }
        return filter;
    }
}

