/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.datastore;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.IResponseObjectType;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.StatusList;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.datastore.BaseDataStore;
import net.gopro.selfservice.datastore.GDFDataStore;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;

public abstract class GoProDataStore
extends BaseDataStore {
    private static final Logger logger = Logger.getLogger(GDFDataStore.class);
    protected static final SimpleDateFormat dfIso = new SimpleDateFormat(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern());

    protected Date populateUpdatedDocuments(Map<BaseDocument, String> map, FlexibleDataRowType[] rows, Organization organization) throws SelfServiceException {
        StatusList caseStatusList = (StatusList)ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
        StatusList memoStatusList = (StatusList)ConfigService.getList("00F9E89D6203E1AB00000121159B3979");
        StatusList fileStatusList = (StatusList)ConfigService.getList("0009A47DD30D261C0000012110DFE58C");
        StatusList emailStatusList = (StatusList)ConfigService.getList("221003FD1A49F6E10000013775389FFF");
        Date latestModifiedDate = null;
        SimpleDateFormat isoDateFormat = new SimpleDateFormat(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
        for (FlexibleDataRowType row : rows) {
            SubDocument sub;
            String documentId = row.getID();
            String statusName = row.getColumnValue(0);
            Date dateModified = null;
            try {
                dateModified = dfIso.parse(row.getColumnValue(1));
            }
            catch (ParseException ex) {
                try {
                    dateModified = isoDateFormat.parse(row.getColumnValue(1));
                }
                catch (ParseException exx) {
                    this.logger(3, organization.getSubject() + " invalid date in column: " + row.getColumnValue(1));
                }
            }
            if (dateModified != null) {
                if (latestModifiedDate == null) {
                    latestModifiedDate = dateModified;
                } else if (dateModified.after(latestModifiedDate)) {
                    latestModifiedDate = dateModified;
                }
            }
            if (!StringUtil.isValid(statusName)) continue;
            if (row.getDocumentType() == 1005 || row.getDocumentType() == 1045) {
                BaseCase bc = CaseService.getCaseByGoProId(documentId, organization.getId());
                if (bc == null || !this.isUpdatedStatus((StatusListItem)caseStatusList.getListItem(bc.getStatusId()), statusName) || bc instanceof FormCase && !((FormCase)bc).isSent()) continue;
                map.put(bc, statusName);
                continue;
            }
            if (row.getDocumentType() == 1028) {
                sub = CaseService.getSubDocumentByGoProId(documentId);
                if (sub == null || !this.isUpdatedStatus((StatusListItem)memoStatusList.getListItem(sub.getStatusId()), statusName)) continue;
                map.put(sub, statusName);
                continue;
            }
            if (row.getDocumentType() == 1025) {
                sub = CaseService.getSubDocumentByGoProId(documentId);
                if (sub == null || !this.isUpdatedStatus((StatusListItem)fileStatusList.getListItem(sub.getStatusId()), statusName)) continue;
                map.put(sub, statusName);
                continue;
            }
            if (row.getDocumentType() != 1024 || (sub = CaseService.getSubDocumentByGoProId(documentId)) == null || !this.isUpdatedStatus((StatusListItem)emailStatusList.getListItem(sub.getStatusId()), statusName)) continue;
            map.put(sub, statusName);
        }
        return latestModifiedDate;
    }

    protected boolean isUpdatedStatus(StatusListItem currentStatus, String remoteStatus) {
        if (currentStatus != null && StringUtil.isValid(remoteStatus)) {
            return !remoteStatus.equalsIgnoreCase(currentStatus.getSubject()) && !remoteStatus.equalsIgnoreCase(currentStatus.getAlias());
        }
        return false;
    }

    protected final void updateSyncTime(LocalType documentType, Organization org, long syncTime) throws SelfServiceException {
        String dataKey = "sync." + documentType.toString().toLowerCase();
        MetaData meta = org.getMetaDataByKey(dataKey);
        if (meta != null && Long.valueOf(meta.getValue()) != syncTime) {
            meta.setValue(String.valueOf(syncTime));
            ConfigService.updateMetaData(meta);
            logger.debug((Object)String.format("Metadata updated: %s, value: %s", dataKey, String.valueOf(syncTime)));
        }
    }

    protected final long getLastSyncTime(LocalType documentType, Organization org) throws GoProDataStoreException {
        try {
            long lastSyncTime = org.getDateCreated();
            String dataKey = "sync." + documentType.toString().toLowerCase();
            MetaData meta = org.getMetaDataByKey(dataKey);
            if (meta != null) {
                try {
                    lastSyncTime = Long.valueOf(meta.getValue());
                }
                catch (NumberFormatException ex) {
                    this.logger(2, "Invalid sync time for " + documentType.toString() + " and " + org.getSubject());
                }
            } else {
                meta = new MetaData(dataKey, String.valueOf(lastSyncTime));
                meta.setDirty(true);
                meta.setReferenceId(org.getId());
                org.getMetadata().add(meta);
                ConfigService.createMetaData(meta);
            }
            return lastSyncTime;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    protected final long getNewestDocumentDate(java.util.List<? extends SubDocument> documentList) {
        long time = 0L;
        for (SubDocument subDocument : documentList) {
            if (subDocument.getDateModified() <= time) continue;
            time = subDocument.getDateModified();
        }
        return time;
    }

    protected String getStatusId(List statusList, String statusName) {
        for (ListItem statusItem : statusList.getListItems()) {
            if (!statusItem.getSubject().equalsIgnoreCase(statusName) && !statusItem.getAlias().equalsIgnoreCase(statusName)) continue;
            return statusItem.getId();
        }
        return null;
    }

    protected String resolveSecondaryParentId(BaseCase parentCase, IResponseObjectType doc) throws SelfServiceException {
        java.util.List<BaseCase> childCases = CaseService.getCasesByParentId(parentCase.getId());
        if (!childCases.isEmpty()) {
            for (BaseCase childCase : childCases) {
                if (!(childCase instanceof FormCase) || !childCase.isSent() || !doc.getParentID().equals(childCase.getGoProId())) continue;
                return childCase.getId();
            }
        }
        return null;
    }

    protected static enum LocalType {
        CASE,
        MEMO,
        ATTACHMENT,
        RESPONSE_DOCUMENTS,
        FOLDER;

    }
}

