/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.datastore;

import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.DocumentStateType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.datastore.GDFDataStore;
import net.gopro.selfservice.exceptions.GoProDataStoreException;

public class GoProCaseDataStore
extends GDFDataStore {
    private static final String BASE = "services/DocumentService";
    private static final String AUTH = "services/SecurityService";

    @Override
    protected String getBasedocumentServiceUrl() {
        return BASE;
    }

    @Override
    protected String getSecurityServiceUrl() {
        return AUTH;
    }

    @Override
    public String getInfo() {
        return "GoPro Case Datastore";
    }

    @Override
    public String getCaseNumber(String goproCaseId, Organization org) throws GoProDataStoreException {
        try {
            String goproCaseNumber = super.getCaseNumber(goproCaseId, org);
            if (goproCaseNumber != null) {
                return goproCaseNumber;
            }
            DocumentService service = this.getService(org);
            UserPrincipal up = this.getGoProUser(org);
            if (up == null || up.getUserProfile() == null) {
                throw new GoProDataStoreException("The GoPro user that Self Service uses was not found!");
            }
            DocumentFilterType filter = new DocumentFilterType();
            filter.setID("00000000-0000-0000-0000-000000000000");
            filter.setSubject("");
            filter.setDocumentFormType(1005);
            filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
            filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
            filter.addFilterDocumentID(goproCaseId);
            DocumentCollectionType coll = service.getDocuments(filter, DocumentStateType.UNCHANGED);
            if (coll != null && coll.getDocumentsCount() == 1) {
                CaseType caseType = (CaseType)coll.getDocument(0);
                goproCaseNumber = caseType.getCaseNumber();
            }
            return goproCaseNumber;
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
    }
}

