/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.datastore;

import net.gopro.selfservice.IGoProDataStore;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.datastore.BrokerDataStore;
import net.gopro.selfservice.datastore.GoProCaseDataStore;
import net.gopro.selfservice.datastore.GoProNetDataStore;
import net.gopro.selfservice.datastore.GoProNetRestDataStore;
import net.gopro.selfservice.datastore.GoProPortalDataStore;
import net.gopro.selfservice.datastore.NOPDataStore;
import net.gopro.selfservice.exceptions.GoProDataStoreException;

public final class DataStoreFactory {
    public static final IGoProDataStore getDataStore(Endpoint endpoint) throws GoProDataStoreException, SelfServiceException {
        switch (endpoint.getGoproType()) {
            case GOPRO_NET: {
                if (endpoint.getHostname().toLowerCase().endsWith("/rest/restservices/")) {
                    return new GoProNetRestDataStore();
                }
                return new GoProNetDataStore();
            }
            case GOPRO_CASE: {
                return new GoProCaseDataStore();
            }
            case GOPRO_BROKER: {
                return new BrokerDataStore();
            }
            case GOPRO_PORTAL: {
                return new GoProPortalDataStore();
            }
            case BROKER_PICKUP: {
                return new NOPDataStore();
            }
        }
        throw new SelfServiceException("Invalid datastore type");
    }
}

