/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.datastore;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.gopro.broker.client.BrokerClientService;
import net.gopro.broker.client.data.RoutingSlip;
import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.data.ClientBaseRefType;
import net.gopro.gdf.data.CompanyType;
import net.gopro.gdf.data.ContactType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.ExternalDocumentType;
import net.gopro.gdf.data.IndividualType;
import net.gopro.gdf.data.MemoType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.selfservice.IGoProDataStore;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.broker.BrokerGDFHelper;
import net.gopro.selfservice.broker.RoutingSlipHelper;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.datastore.BaseDataStore;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.validator.UrlValidator;

public class BrokerDataStore
extends BaseDataStore
implements IGoProDataStore {
    private static final String BASE = "services/BrokerService";

    @Override
    public boolean testConnection(Organization org) throws GoProDataStoreException {
        try {
            if (org.getEndpoint() == null || !StringUtil.isValid(org.getEndpoint().getHostname())) {
                throw new GoProDataStoreException("The hostname is missing or invalid");
            }
            String[] schemes = new String[]{"http", "https"};
            UrlValidator uval = new UrlValidator(schemes);
            if (!uval.isValid(org.getEndpoint().getHostname())) {
                throw new GoProDataStoreException("The hostname is invalid");
            }
            String url = org.getEndpoint().getHostname() + BASE + "?wsdl";
            BrokerClientService service = new BrokerClientService(url);
            return true;
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    @Override
    public String createCase(BaseCase bc) throws GoProDataStoreException {
        try {
            String brokerRequestId = null;
            Organization destination = ConfigService.getOrganization(bc.getOrganizationId());
            User user = UserService.getUser(bc.getCreatedById());
            CaseType caseType = BrokerGDFHelper.createCaseType((FormCase)bc);
            IndividualType indType = BrokerGDFHelper.createIndividualType(user);
            DocumentCollectionType coll = new DocumentCollectionType();
            coll.addDocument((DocumentBaseType)indType);
            if (bc.isCompanyCase()) {
                Company comp = UserService.getCompany(bc.getCompanyId());
                CompanyType companyType = BrokerGDFHelper.createCompanyType(comp);
                coll.addDocument((DocumentBaseType)companyType);
                Contact contact = UserService.getContact(bc.getContactId());
                ContactType contactType = BrokerGDFHelper.createContactType(contact, user);
                coll.addDocument((DocumentBaseType)contactType);
                ClientBaseRefType clientRef = new ClientBaseRefType();
                clientRef.setID(contactType.getID());
                clientRef.setName(contactType.getSubject());
                caseType.setInvolvedParty(clientRef);
            } else {
                ClientBaseRefType clientRef = new ClientBaseRefType();
                clientRef.setID(indType.getID());
                clientRef.setName(indType.getName().getFirstName() + " " + indType.getName().getLastName());
                caseType.setInvolvedParty(clientRef);
            }
            this.processSecondary(bc, caseType);
            RoutingSlip slip = RoutingSlipHelper.generateRoutingSlip(destination);
            slip.getSenderType().setName(user.getFullname());
            BrokerClientService client = this.getService(destination);
            coll.addDocument((DocumentBaseType)caseType);
            brokerRequestId = client.sendDocuments(slip, coll);
            return brokerRequestId;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
        catch (UserException ex) {
            throw new GoProDataStoreException(ex);
        }
    }

    @Override
    public String updateCase(BaseCase bc) throws GoProDataStoreException {
        return null;
    }

    @Override
    public String createSubDocument(SubDocument doc, BaseCase parent) throws GoProDataStoreException {
        try {
            SubDocument parentDoc;
            String brokerRequestId = null;
            Organization destination = ConfigService.getOrganization(parent.getOrganizationId());
            User user = UserService.getUser(doc.getCreatedById());
            String parentCaseId = parent.getGoProId();
            String parentId = parent.getGoProId();
            if (!doc.getParentId().equals(parentCaseId) && (parentDoc = CaseService.getSubDocument(doc.getParentId(), false)) != null && StringUtil.isValid(parentDoc.getGoProId())) {
                parentId = parentDoc.getGoProId();
            }
            RoutingSlip slip = RoutingSlipHelper.generateRoutingSlip(destination);
            slip.getSenderType().setName(user.getFullname());
            BrokerClientService client = this.getService(destination);
            DocumentCollectionType coll = new DocumentCollectionType();
            if (doc instanceof ExternalDocument) {
                ExternalDocumentType externalDocType = BrokerGDFHelper.createExternalDocumentType((ExternalDocument)doc, user);
                externalDocType.setID(doc.getId());
                externalDocType.setTopParentID(parentCaseId);
                externalDocType.setParentID(parentId);
                coll.addDocument((DocumentBaseType)externalDocType);
            } else if (doc instanceof Memo) {
                MemoType memo = BrokerGDFHelper.createMemoType((Memo)doc, user);
                memo.setID(doc.getId());
                memo.setTopParentID(parentCaseId);
                memo.setParentID(parentId);
                coll.addDocument((DocumentBaseType)memo);
            } else {
                throw new GoProDataStoreException("Sending " + doc.getClass().getName() + " is not supported.");
            }
            brokerRequestId = client.sendDocuments(slip, coll);
            return brokerRequestId;
        }
        catch (SelfServiceException ex) {
            throw new GoProDataStoreException(ex);
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
    }

    public List<SubDocument> getIncomingDocuments(Organization org) throws GoProDataStoreException {
        this.logger(2, "getIncomingDocuments is not implemented for Broker");
        ArrayList<SubDocument> list = new ArrayList<SubDocument>();
        return list;
    }

    @Override
    public Map<BaseDocument, String> getStatusUpdates(Organization org) throws GoProDataStoreException {
        this.logger(2, "getStatusUpdates is not implemented for Broker");
        return null;
    }

    @Override
    public String getCaseNumber(String goproCaseId, Organization org) throws GoProDataStoreException {
        this.logger(2, "getCaseNumber is not implemented for GoPro Broker");
        return null;
    }

    @Override
    public String getInfo() {
        return "GoPro Broker GDF Datastore";
    }

    private final BrokerClientService getService(Organization org) throws GoProDataStoreException {
        try {
            Endpoint endpoint = org.getEndpoint();
            if (endpoint == null) {
                throw new GoProDataStoreException("The Organization Endpoint is missing");
            }
            String hostname = endpoint.getHostname();
            String destinationId = endpoint.getBrokerDestinationId();
            String senderId = SelfServiceEngine.getConfig("broker.selfservice.id");
            if (!StringUtil.isValid(hostname)) {
                throw new GoProDataStoreException("The Broker hostname is missing!");
            }
            if (!StringUtil.isValid(destinationId)) {
                throw new GoProDataStoreException("The Broker destination Id for this organization is missing!");
            }
            if (!StringUtil.isValid(senderId)) {
                throw new GoProDataStoreException("The Broker Sender id is missing, please add the config key: \"broker.selfservice.id\" and try again.");
            }
            String url = hostname + BASE + "?wsdl";
            BrokerClientService service = new BrokerClientService(url);
            return service;
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    @Override
    public String updateContact(User contact, GoProClientBaseReference ref) throws GoProDataStoreException {
        this.logger(2, "updateContact is not implemented for Broker");
        return null;
    }

    private void processSecondary(BaseCase bc, CaseType caseType) throws SelfServiceException {
        if (this.isSecondaryApplication(bc)) {
            FormTemplate.SecondaryCaseHandling handling = this.getSecondaryCaseHandling(bc);
            MetaDataType meta = new MetaDataType();
            meta.setName("case.secondary");
            meta.setValue("true");
            meta.setValueType(MetaValueType.STRING);
            MetaDataType metaParent = new MetaDataType();
            metaParent.setName("secondary.parentId");
            metaParent.setValue(((FormCase)bc).getParentId());
            metaParent.setValueType(MetaValueType.STRING);
            MetaDataType metaHand = new MetaDataType();
            metaHand.setName("secondary.handling");
            metaHand.setValue(handling.toString());
            metaHand.setValueType(MetaValueType.STRING);
            caseType.addMetaDataEntry(meta);
            caseType.addMetaDataEntry(metaHand);
            caseType.addMetaDataEntry(metaParent);
        }
    }

    private boolean isSecondaryApplication(BaseCase bc) {
        return bc instanceof FormCase && ((FormCase)bc).getParentId() != null;
    }

    private FormTemplate.SecondaryCaseHandling getSecondaryCaseHandling(BaseCase bc) throws SelfServiceException {
        BaseCase parentCase = CaseService.getCase(((FormCase)bc).getParentId());
        if (parentCase instanceof FormCase) {
            String formTemplateId = ((FormCase)parentCase).getFormtemplateId();
            FormTemplate ft = FormService.getFormTemplate(formTemplateId, false);
            return ft.getSecondaryHandling();
        }
        CaseTemplate ct = CaseService.getCaseTemplate(parentCase.getCaseTemplateId());
        return ct.getSecondaryHandling();
    }
}

