/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.targetgroup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import net.gopro.selfservice.ITargetGroupGenerator;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.DirectoryUser;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;

public class FormApplicantsGenerator
implements ITargetGroupGenerator {
    private String formTemplateName = null;
    private String organizationName = null;
    private String statusName = null;

    @Override
    public java.util.List<DirectoryUser> getAudience(TargetGroup group) throws TargetGroupException {
        try {
            ArrayList<DirectoryUser> list = new ArrayList<DirectoryUser>();
            HashSet<String> userIds = new HashSet<String>();
            BaseDocument template = null;
            Organization organization = null;
            BaseDocument applicationStatus = null;
            java.util.List<FormTemplate> templateList = FormService.getFormTemplates();
            for (FormTemplate ft : templateList) {
                if (!ft.getSubject().equalsIgnoreCase(this.formTemplateName) && !ft.getId().equals(this.formTemplateName)) continue;
                template = ft;
                break;
            }
            if (template != null) {
                if (this.organizationName != null && !"".equals(this.organizationName)) {
                    java.util.List<Organization> organizationList = ConfigService.getOrganizations();
                    for (Organization o : organizationList) {
                        if (!o.getSubject().equalsIgnoreCase(this.organizationName) && !o.getId().equals(this.organizationName)) continue;
                        organization = o;
                        break;
                    }
                }
                if (this.statusName != null && !"".equals(this.statusName)) {
                    List statusList = ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
                    for (ListItem listItem : statusList.getListItems()) {
                        if (!listItem.getSubject().equalsIgnoreCase(this.statusName) && !listItem.getAlias().equalsIgnoreCase(this.statusName)) continue;
                        applicationStatus = listItem;
                        break;
                    }
                }
                java.util.List<FormCase> formCaseList = CaseService.getCasesByFormTemplate(template.getId());
                BaseDocumentUtil.removeDeletedDocuments(formCaseList);
                for (FormCase fc : formCaseList) {
                    if (organization != null && applicationStatus != null) {
                        if (!fc.getOrganizationId().equals(organization.getId()) || !fc.getStatusId().equals(applicationStatus.getId())) continue;
                        userIds.add(fc.getCreatedById());
                        continue;
                    }
                    if (organization != null) {
                        if (!fc.getOrganizationId().equals(organization.getId())) continue;
                        userIds.add(fc.getCreatedById());
                        continue;
                    }
                    if (applicationStatus != null) {
                        if (!fc.getStatusId().equals(applicationStatus.getId())) continue;
                        userIds.add(fc.getCreatedById());
                        continue;
                    }
                    userIds.add(fc.getCreatedById());
                }
                for (String userId : userIds) {
                    User user = UserService.getUser(userId);
                    if (user == null || user.isDeleted()) continue;
                    DirectoryUser du = new DirectoryUser();
                    du.setSelfServiceUserId(userId);
                    du.setFullName(user.getFullname());
                    du.setEmail(user.getEmail());
                    list.add(du);
                }
            }
            return list;
        }
        catch (SelfServiceException ex) {
            throw new TargetGroupException(ex);
        }
    }

    @Override
    public void getAudienceCallback(java.util.List<User> userList) throws TargetGroupException {
        Iterator<User> it = userList.iterator();
        while (it.hasNext()) {
            if (!it.next().isDeleted()) continue;
            it.remove();
        }
    }

    @Override
    public String getInfo() {
        return "Form applicants Target Group Generator";
    }

    @Override
    public Properties getPropertes() throws TargetGroupException {
        Properties p = new Properties();
        p.put("status", "The status of the application (optional)");
        p.put("organization", "The name of the organization (optional)");
        p.put("formtemplate", "The name of the form template");
        return p;
    }

    @Override
    public void setProperties(Properties prop) throws TargetGroupException {
        this.formTemplateName = prop.getProperty("formtemplate");
        if (this.formTemplateName == null) {
            throw new TargetGroupException("The parameter \"formtemplate\" is missing");
        }
        this.organizationName = prop.getProperty("organization");
        this.statusName = prop.getProperty("status");
    }
}

