/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import is.hugvit.util.Util;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.SelfServicePrincipal;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.UserRole;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.data.gopro.GoProContactReference;
import net.gopro.selfservice.data.gopro.GoProIndividualReference;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

@JsonIgnoreProperties(value={"password", "principal", "certificate", "triggerGoProUpdate", "contactCompanyIds", "goproClientReferences"})
public class User
extends BaseDocument {
    protected String username;
    protected String fullname;
    @JsonIgnore
    protected String password;
    protected String email;
    protected String idNumber;
    protected byte[] certificate;
    protected String homephoneNumber;
    protected String mobilephoneNumber;
    protected Address address;
    protected String profileImage;
    protected boolean isVerified;
    protected boolean isReadOnlyRestricted = false;
    protected boolean isMunicipalityUser = false;
    protected Communications communication = Communications.NONE;
    protected String locale;
    protected Set<UserRole> userRoles = new HashSet<UserRole>();
    protected Set<Contact> contactList = new HashSet<Contact>();
    @JsonIgnore
    protected Set<GoProClientBaseReference> goproClientReferences = new HashSet<GoProClientBaseReference>();
    protected Set<TargetGroup> targetGroups = new HashSet<TargetGroup>();
    @JsonIgnore
    protected boolean triggerGoProUpdate = true;

    public User() {
    }

    public User(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("user_id");
        this.username = rs.getString("username");
        this.fullname = rs.getString("fullname");
        this.password = rs.getString("password");
        this.email = rs.getString("email");
        this.idNumber = rs.getString("idnumber");
        this.certificate = rs.getBytes("certificate");
        this.homephoneNumber = rs.getString("homephone");
        this.mobilephoneNumber = rs.getString("mobilephone");
        this.isVerified = rs.getInt("is_verified") == 1;
        this.isReadOnlyRestricted = rs.getInt("is_readonly") == 1;
        this.communication = Communications.valueOf(rs.getString("communication"));
        this.profileImage = rs.getString("profileimage");
        this.locale = rs.getString("lang");
        this.address = new Address(rs);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        if (this.email != null) {
            return this.email.toLowerCase();
        }
        return this.email;
    }

    public void setEmail(String email) {
        if (email != null) {
            this.email = email.toLowerCase().trim();
        }
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    @JsonIgnore
    @JsonbTransient
    public X509Certificate getX509Certificate() throws CertificateException {
        X509Certificate cert = null;
        if (this.certificate != null && this.certificate.length > 0) {
            ByteArrayInputStream in = new ByteArrayInputStream(this.certificate);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(in);
        }
        return cert;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    public String getHomephoneNumber() {
        return this.homephoneNumber;
    }

    public void setHomephoneNumber(String homephone) {
        this.homephoneNumber = homephone;
    }

    public String getMobilephoneNumber() {
        return this.mobilephoneNumber;
    }

    public void setMobilephoneNumber(String mobilephone) {
        this.mobilephoneNumber = mobilephone;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public void setVerified(boolean isVerified) {
        this.isVerified = isVerified;
    }

    public boolean isMunicipalityUser() {
        return this.isMunicipalityUser;
    }

    public void setMunicipalityUser(boolean isMunicipalityUser) {
        this.isMunicipalityUser = isMunicipalityUser;
    }

    public boolean isReadOnlyRestricted() {
        return this.isReadOnlyRestricted;
    }

    public void setReadOnlyRestricted(boolean isReadOnlyRestricted) {
        this.isReadOnlyRestricted = isReadOnlyRestricted;
    }

    public Communications getCommunication() {
        return this.communication;
    }

    public void setCommunication(Communications communication) {
        this.communication = communication;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public final String getInitials() {
        String initials = "";
        StringTokenizer st = new StringTokenizer(this.fullname);
        while (st.hasMoreTokens()) {
            initials = initials + st.nextToken().substring(0, 1) + ".";
        }
        return initials;
    }

    public final String getFirstName() {
        StringTokenizer st = new StringTokenizer(this.fullname);
        if (st.countTokens() > 0) {
            return st.nextToken();
        }
        return "";
    }

    public final String getMiddleName() {
        String middlename = "";
        Vector v = Util.split((String)this.fullname, (String)" ");
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                if (i <= 0 || i >= v.size() - 1) continue;
                middlename = middlename + v.get(i) + " ";
            }
        }
        return middlename.trim();
    }

    public final String getLastName() {
        Vector v = Util.split((String)this.fullname, (String)" ");
        if (v != null && v.size() > 0) {
            return (String)v.get(v.size() - 1);
        }
        return "";
    }

    public Set<UserRole> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(Set<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    public Set<TargetGroup> getTargetGroups() {
        return this.targetGroups;
    }

    public Set<Contact> getContactList() {
        return this.contactList;
    }

    public boolean isTriggerGoProUpdate() {
        return this.triggerGoProUpdate;
    }

    public void setTriggerGoProUpdate(boolean triggerGoProUpdate) {
        this.triggerGoProUpdate = triggerGoProUpdate;
    }

    public boolean isContact() {
        if (this.contactList.size() == 0) {
            return false;
        }
        for (Contact contact : this.contactList) {
            if (!contact.isConfirmed()) continue;
            return true;
        }
        return false;
    }

    public boolean isContactManager() {
        if (this.contactList.size() == 0) {
            return false;
        }
        for (Contact contact : this.contactList) {
            if (!contact.isConfirmed() || !contact.isManager()) continue;
            return true;
        }
        return false;
    }

    @JsonbTransient
    public List<String> getContactCompanyIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (Contact contact : this.contactList) {
            if (!contact.isConfirmed() || contact.isDeleted()) continue;
            list.add(contact.getCompanyId());
        }
        return list;
    }

    public Contact getContactByCompanyId(String companyId) {
        for (Contact contact : this.contactList) {
            if (!contact.getCompanyId().equals(companyId) || contact.isDeleted()) continue;
            return contact;
        }
        return null;
    }

    public boolean isContactForCompany(String companyId) {
        for (Contact con : this.contactList) {
            if (!con.getCompanyId().equals(companyId) || con.isDeleted()) continue;
            return true;
        }
        return false;
    }

    public Set<GoProClientBaseReference> getGoproClientReferences() {
        return this.goproClientReferences;
    }

    public List<GoProClientBaseReference> getGoProClientReferences(String organizationId) {
        ArrayList<GoProClientBaseReference> refList = new ArrayList<GoProClientBaseReference>();
        for (GoProClientBaseReference ref : this.goproClientReferences) {
            if (!ref.getOrganizationId().equals(organizationId)) continue;
            refList.add(ref);
        }
        return refList;
    }

    public GoProIndividualReference getGoProIndividualReference(String organizationId) {
        for (GoProClientBaseReference ref : this.goproClientReferences) {
            if (!ref.getOrganizationId().equals(organizationId) || !(ref instanceof GoProIndividualReference)) continue;
            return (GoProIndividualReference)ref;
        }
        return null;
    }

    public GoProContactReference getGoProContactReference(String organizationId, String contactId) {
        for (GoProClientBaseReference ref : this.goproClientReferences) {
            if (!ref.getOrganizationId().equals(organizationId) || !(ref instanceof GoProContactReference) || !((GoProContactReference)ref).getContactId().equals(contactId)) continue;
            return (GoProContactReference)ref;
        }
        return null;
    }

    public final boolean isInRole(String roleId) {
        for (UserRole role : this.userRoles) {
            if (!role.getId().equals(roleId)) continue;
            return true;
        }
        return false;
    }

    public final boolean isInTargetGroup(String targetgroupId) {
        for (TargetGroup tg : this.targetGroups) {
            if (!tg.getId().equals(targetgroupId)) continue;
            return true;
        }
        return false;
    }

    public String getProfileImage() {
        return this.profileImage;
    }

    public void setProfileImage(String profileImage) {
        this.profileImage = profileImage;
    }

    @JsonIgnore
    @JsonbTransient
    public SelfServicePrincipal getPrincipal() {
        ArrayList<String> roles = new ArrayList<String>();
        for (UserRole role : this.userRoles) {
            roles.add(role.getSubject());
        }
        SelfServicePrincipal principal = new SelfServicePrincipal(this.username, this.password, roles);
        principal.setUserId(this.documentId);
        principal.setEmail(this.email);
        principal.setFullname(this.fullname);
        principal.setImage(false);
        principal.setLocale(this.locale);
        return principal;
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element rel;
        Element el = super.getBaseXml("user");
        el.addAttribute("type", this.getClass().getSimpleName());
        Dom4JUtil.addElement(el, "username", this.username);
        Dom4JUtil.addElement(el, "fullname", this.fullname);
        Dom4JUtil.addElement(el, "email", this.email);
        Dom4JUtil.addElement(el, "homephone", this.homephoneNumber);
        Dom4JUtil.addElement(el, "mobilephone", this.mobilephoneNumber);
        Dom4JUtil.addElement(el, "communication", this.communication.toString());
        Dom4JUtil.addElement(el, "is_verified", String.valueOf(this.isVerified));
        Dom4JUtil.addElement(el, "is_readonlyrestricted", String.valueOf(this.isReadOnlyRestricted));
        Dom4JUtil.addElement(el, "is_contact", String.valueOf(this.isContact()));
        Dom4JUtil.addElement(el, "image", this.profileImage);
        Dom4JUtil.addElement(el, "idnumber", this.idNumber);
        Dom4JUtil.addElement(el, "locale", this.locale);
        if (this.address != null) {
            el.add(this.address.getXml());
        }
        if (this.userRoles.size() > 0) {
            rel = el.addElement("userroles");
            for (UserRole role : this.userRoles) {
                rel.add(role.getXml());
            }
        }
        if (this.contactList.size() > 0) {
            rel = el.addElement("contacts");
            for (Contact contact : this.contactList) {
                rel.add(contact.getXml());
            }
        }
        if (this.goproClientReferences.size() > 0) {
            Element elRef = el.addElement("reference");
            for (GoProClientBaseReference ref : this.goproClientReferences) {
                elRef.add(ref.getXml());
            }
        }
        return el;
    }

    public static enum Communications {
        NONE,
        EMAIL,
        SMS,
        BANK;

    }
}

