/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.data.BaseDocument;
import org.dom4j.Element;

public class RecoveryTicket
extends BaseDocument {
    private static final int DEFAULT_TICKET_VALIDITY_HOURS = 12;
    private String userId;
    private String requestIp;
    private long expiryDate;
    private boolean isUsed;

    public RecoveryTicket(String userId, String requestIp) {
        this.userId = userId;
        this.requestIp = requestIp;
        this.isUsed = false;
        Calendar cal = Calendar.getInstance();
        cal.add(10, 12);
        this.expiryDate = cal.getTimeInMillis();
    }

    public RecoveryTicket(String userId, String requestIp, int ticketLifeTime) {
        this(userId, requestIp);
        if (ticketLifeTime > 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(12, ticketLifeTime);
            this.expiryDate = cal.getTimeInMillis();
        }
    }

    public RecoveryTicket(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("ticket_id");
        this.userId = rs.getString("user_id");
        this.requestIp = rs.getString("request_ip");
        this.expiryDate = rs.getTimestamp("expires").getTime();
        this.isUsed = rs.getInt("is_used") == 1;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRequestIp() {
        return this.requestIp;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public final boolean isExpired() {
        return new Date().getTime() > this.expiryDate;
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = this.getBaseXml("recovery_ticket");
        return el;
    }
}

