/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FormTemplateExtras {
    private String targetGroupId;
    private String goproAgent;
    private String goproAlias;
    private String javascriptFilePath;
    private String cssFilePath;
    private int requiredAttachmentCount = 0;
    private String customClass;
    private boolean goproSubject = false;
    private LinkedList<StatusListItem> caseStatusList = new LinkedList();
    private double formFeeAmount = 0.0;
    private String formFeeCurrency;
    private XSLFoType pdfFoType = XSLFoType.SINGLE;

    public FormTemplateExtras() {
        this.pdfFoType = XSLFoType.SINGLE;
    }

    public FormTemplateExtras(ResultSet rs) throws SQLException {
        this.cssFilePath = rs.getString("cssfile");
        this.customClass = rs.getString("customclass");
        this.javascriptFilePath = rs.getString("jscript");
        this.goproAgent = rs.getString("gopro_agent");
        this.goproAlias = rs.getString("gopro_alias");
        this.goproSubject = rs.getInt("gopro_subject") == 1;
        this.requiredAttachmentCount = rs.getInt("filecount");
        this.formFeeAmount = rs.getInt("fee_amount");
        this.formFeeCurrency = rs.getString("fee_currency");
        this.targetGroupId = rs.getString("targetgroup_id");
        try {
            this.pdfFoType = XSLFoType.valueOf(rs.getString("pdftype"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTargetGroupId() {
        return this.targetGroupId;
    }

    public void setTargetGroupId(String targetGroupId) {
        this.targetGroupId = targetGroupId;
    }

    public String getCssFilePath() {
        return this.cssFilePath;
    }

    public void setCssFilePath(String cssFilePath) {
        this.cssFilePath = cssFilePath;
    }

    public final String getJavascriptFilePath() {
        return this.javascriptFilePath;
    }

    public final void setJavascriptFilePath(String javascriptFilePath) {
        this.javascriptFilePath = javascriptFilePath;
    }

    public String getGoproAgent() {
        return this.goproAgent;
    }

    public void setGoproAgent(String goproAgent) {
        this.goproAgent = goproAgent;
    }

    public String getGoproAlias() {
        return this.goproAlias;
    }

    public void setGoproAlias(String goproAlias) {
        this.goproAlias = goproAlias;
    }

    public boolean isGoproSubject() {
        return this.goproSubject;
    }

    public void setGoproSubject(boolean goproSubject) {
        this.goproSubject = goproSubject;
    }

    public double getFormFeeAmount() {
        return this.formFeeAmount;
    }

    public void setFormFeeAmount(double formFeeAmount) {
        this.formFeeAmount = formFeeAmount;
    }

    public String getFormFeeCurrency() {
        return this.formFeeCurrency;
    }

    public void setFormFeeCurrency(String formFeeCurrency) {
        this.formFeeCurrency = formFeeCurrency;
    }

    public int getRequiredAttachmentCount() {
        return this.requiredAttachmentCount;
    }

    public void setRequiredAttachmentCount(int requiredAttachmentCount) {
        this.requiredAttachmentCount = requiredAttachmentCount;
    }

    public String getCustomClass() {
        return this.customClass;
    }

    public void setCustomClass(String customClass) {
        this.customClass = customClass;
    }

    public XSLFoType getPdfFoType() {
        return this.pdfFoType;
    }

    public void setPdfFoType(XSLFoType pdfFoType) {
        this.pdfFoType = pdfFoType;
    }

    public LinkedList<StatusListItem> getCaseStatusList() {
        return this.caseStatusList;
    }

    public void setCaseStatusList(LinkedList<StatusListItem> caseStatusList) {
        this.caseStatusList = caseStatusList;
    }

    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"extras");
        Dom4JUtil.addCDATAElement(el, "csspath", this.cssFilePath);
        Dom4JUtil.addElement(el, "customclass", this.customClass);
        Dom4JUtil.addCDATAElement(el, "javascript", this.javascriptFilePath);
        Dom4JUtil.addElement(el, "targetgroup_id", this.targetGroupId);
        Dom4JUtil.addElement(el, "agent", this.goproAgent);
        Dom4JUtil.addElement(el, "alias", this.goproAlias);
        Dom4JUtil.addElement(el, "filecount", String.valueOf(this.requiredAttachmentCount));
        Dom4JUtil.addElement(el, "feeamount", String.valueOf(this.formFeeAmount));
        if (this.formFeeCurrency != null) {
            Dom4JUtil.addElement(el, "feecurrency", String.valueOf(this.formFeeCurrency));
        }
        if (this.pdfFoType != null) {
            Dom4JUtil.addElement(el, "pdftype", this.pdfFoType.toString());
        }
        return el;
    }

    public static enum XSLFoType {
        SINGLE,
        DOUBLE;

    }
}

