/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class ConfigEntry
extends BaseDocument {
    private String key;
    private String value;
    private String section;
    private boolean isVisible = true;

    public ConfigEntry() {
    }

    public ConfigEntry(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("config_id");
        this.key = rs.getString("configkey");
        this.value = rs.getString("configvalue");
        this.section = rs.getString("section");
        this.isVisible = rs.getInt("is_visible") == 1;
    }

    public ConfigEntry(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getSection() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = super.getBaseXml("config");
        el.addElement("key").setText(this.key);
        el.addElement("value").setText(this.value);
        Dom4JUtil.addElement(el, "section", this.section);
        return el;
    }
}

