/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.Announcement;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Announcement.class, name="Announcement"), @JsonSubTypes.Type(value=BaseCase.class, name="BaseCase"), @JsonSubTypes.Type(value=CaseTemplate.class, name="CaseTemplate"), @JsonSubTypes.Type(value=Company.class, name="Company"), @JsonSubTypes.Type(value=ConfigEntry.class, name="ConfigEntry"), @JsonSubTypes.Type(value=FormTemplate.class, name="FormTemplate"), @JsonSubTypes.Type(value=FormTemplateFile.class, name="FormTemplateFile"), @JsonSubTypes.Type(value=TargetGroup.class, name="TargetGroup")})
public abstract class BaseDocument
implements Comparable<BaseDocument> {
    protected String documentId;
    protected boolean isDeleted;
    protected long dateCreated;
    protected long dateModified;
    @JsonIgnore
    protected boolean isDirty = false;
    protected List<MetaData> metadata = new ArrayList<MetaData>();

    protected BaseDocument() {
        this.isDeleted = false;
        this.dateModified = this.dateCreated = new Date().getTime();
    }

    protected BaseDocument(ResultSet rs) throws SQLException {
        this.isDeleted = rs.getInt("is_deleted") == 1;
        this.dateCreated = rs.getTimestamp("created").getTime();
        this.dateModified = rs.getTimestamp("modified").getTime();
    }

    @JsonIgnore
    @JsonbTransient
    public abstract Element getXml();

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public long getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(long dateCreated) {
        this.dateCreated = dateCreated;
    }

    public long getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(long dateModified) {
        this.dateModified = dateModified;
    }

    public String getId() {
        return this.documentId;
    }

    public void setId(String documentId) {
        this.documentId = documentId;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public List<MetaData> getMetadata() {
        return this.metadata;
    }

    public final MetaData getMetaDataByKey(String key) {
        if (this.metadata != null && this.metadata.size() > 0) {
            for (MetaData m : this.metadata) {
                if (!m.getKey().equals(key)) continue;
                return m;
            }
        }
        return null;
    }

    @JsonbTransient
    protected Element getBaseXml(String rootName) {
        Element el = DocumentHelper.createElement((String)rootName);
        el.addAttribute("type", this.getClass().getSimpleName());
        el.addAttribute("id", this.documentId);
        el.addAttribute("created", String.valueOf(this.dateCreated));
        el.addAttribute("modified", String.valueOf(this.dateModified));
        el.addElement("deleted").setText(String.valueOf(this.isDeleted));
        el.addElement("created").setText(LocaleUtil.formatDateShort(this.dateCreated));
        el.addElement("created_alt").setText(LocaleUtil.formatDate(this.dateCreated));
        el.addElement("created_sortable").setText(LocaleUtil.formatDateAsSortable(this.dateCreated));
        el.addElement("modified").setText(LocaleUtil.formatDateShort(this.dateModified));
        el.addElement("modified_alt").setText(LocaleUtil.formatDate(this.dateModified));
        el.addElement("modified_sortable").setText(LocaleUtil.formatDateAsSortable(this.dateModified));
        if (this.metadata.size() > 0) {
            Element elMeta = el.addElement("metadatalist");
            for (MetaData m : this.metadata) {
                elMeta.add(m.getXml());
            }
        }
        return el;
    }

    protected void setACLXml(Element parent, List<AccessControl> accessControlList) {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.common");
        for (AccessControl acl : accessControlList) {
            Element elAcl = acl.getXml();
            if (rb.containsKey("acl.type." + acl.getEntityType().toString().toLowerCase())) {
                elAcl.addElement("typename").setText(rb.getString("acl.type." + acl.getEntityType().toString().toLowerCase()));
            }
            String accessText = String.valueOf(acl.getBitmask());
            if (acl.getBitmask() == 1 && rb.containsKey("acl.read")) {
                accessText = rb.getString("acl.read");
            } else if ((acl.getBitmask() == 2 || acl.getBitmask() == 3) && rb.containsKey("acl.write")) {
                accessText = rb.getString("acl.write");
            }
            elAcl.addElement("accessmaskname").setText(accessText);
            parent.add(elAcl);
        }
    }

    @Override
    public int compareTo(BaseDocument o) {
        if (o.getDateCreated() < this.getDateCreated()) {
            return -1;
        }
        if (o.getDateCreated() > this.getDateCreated()) {
            return 1;
        }
        return 0;
    }
}

