/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AuditLogEntry
implements Comparable<AuditLogEntry> {
    protected String documentId;
    protected String userId;
    protected String ip;
    protected long timestamp;
    protected Action action;
    protected DataType dataType;

    public AuditLogEntry() {
        this.timestamp = new Date().getTime();
    }

    public AuditLogEntry(String documentId, String userId, DataType type, Action action) {
        this.timestamp = new Date().getTime();
        this.documentId = documentId;
        this.userId = userId;
        this.action = action;
        this.dataType = type;
    }

    public AuditLogEntry(String documentId, DataType type, Action action) {
        this.timestamp = new Date().getTime();
        this.documentId = documentId;
        this.action = action;
        this.dataType = type;
    }

    public AuditLogEntry(ResultSet rs) throws SQLException {
        this.documentId = rs.getString("document_id");
        this.userId = rs.getString("user_id");
        this.timestamp = rs.getTimestamp("stamp").getTime();
        this.action = Action.valueOf(rs.getString("action"));
        this.dataType = DataType.valueOf(rs.getString("datatype"));
        this.ip = rs.getString("ip");
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"entry");
        el.addAttribute("id", this.documentId);
        el.addAttribute("stamp", String.valueOf(this.timestamp));
        Dom4JUtil.addElement(el, "action", this.action.toString());
        Dom4JUtil.addElement(el, "type", this.dataType.toString());
        Dom4JUtil.addElement(el, "user_id", this.userId);
        Dom4JUtil.addElement(el, "ip", this.ip);
        DateFormat df = LocaleUtil.getTimeFormat();
        el.addElement("timestamp").setText(df.format(this.timestamp));
        el.addElement("timestamp_alt").setText(LocaleUtil.formatDate(this.timestamp));
        el.addElement("timestamp_sortable").setText(LocaleUtil.formatDateAsSortable(this.timestamp));
        return el;
    }

    @Override
    public int compareTo(AuditLogEntry o) {
        if (o.getTimestamp() < this.getTimestamp()) {
            return 1;
        }
        if (o.getTimestamp() > this.getTimestamp()) {
            return -1;
        }
        if (Action.CHECKIN.equals((Object)o.getAction())) {
            return -1;
        }
        return 0;
    }

    public static enum DataType {
        CASE,
        FORM,
        FORMTEMPLATE,
        MEMO,
        EXTERNAL_DOCUMENT,
        USER,
        EMAIL,
        EMAIL_ATTACHMENT,
        GDF,
        BROKER,
        COMPANY,
        MESSAGE,
        GUIDANCE,
        CONFIG,
        ORGANIZATION,
        STATUS,
        TARGETGROUP,
        LIST,
        LISTITEM,
        METADATA,
        USERROLE,
        CONTACT,
        GOPRO_CLIENT_REF,
        GOPRO_COMPANY_REF,
        CASETEMPLATE,
        COMPLETED_FORM,
        FORMTEMPLATE_FILE,
        QUEUE_ENTRY,
        ANNOUNCEMENT,
        TASK;

    }

    public static enum Action {
        READ,
        CREATE,
        UPDATE,
        DELETE,
        SEND,
        LOGIN,
        LOGOUT,
        FAILED_LOGIN,
        ILLEGAL_DOCUMENT_ACCESS,
        READ_CONFIRMATION,
        DOWNLOAD,
        REOPEN,
        CHECKIN,
        CHECKOUT,
        PICKUP,
        SHARE,
        UNSHARE,
        DIGITAL_SIGNING;

    }
}

