/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.av;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import net.gopro.selfservice.IVirusScanner;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.exceptions.VirusFoundException;
import net.gopro.selfservice.exceptions.VirusScannerException;
import org.jsmtpd.clamav.ClamAVScanner;
import org.jsmtpd.clamav.ClamAVScannerFactory;

public final class ClamAVImpl
implements IVirusScanner {
    private String clamhost;
    private int clamport = 3310;
    private int timeout = 0;
    private ClamAVScanner scanner;

    @Override
    public void setConfiguration(String hostname, Integer port, Properties config) throws VirusScannerException {
        this.clamhost = hostname;
        if (port != null) {
            this.clamport = port;
        }
        if (config.containsKey("av.timeout")) {
            try {
                this.timeout = Integer.parseInt(config.getProperty("av.timeout"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void initialize() throws VirusScannerException {
        if (this.clamhost == null || this.clamhost.equals("")) {
            throw new VirusScannerException("The ClamAV hostname is not set!");
        }
        ClamAVScannerFactory.setClamdHost((String)this.clamhost);
        ClamAVScannerFactory.setClamdPort((int)this.clamport);
        if (this.timeout > 0) {
            ClamAVScannerFactory.setConnectionTimeout((int)this.timeout);
        }
        this.scanner = ClamAVScannerFactory.getScanner();
    }

    @Override
    public void scan(Attachment att) throws VirusFoundException, VirusScannerException {
        if (att != null && att.getStream() != null) {
            try {
                ByteArrayInputStream baos = new ByteArrayInputStream(att.getStream());
                boolean isClean = this.scanner.performScan((InputStream)baos);
                if (!isClean) {
                    throw new VirusFoundException("The file " + att.getFilename() + " contains a virus!");
                }
            }
            catch (Exception ex) {
                throw new VirusScannerException(ex);
            }
        }
    }
}

