SELECT f.template_id AS template, f.subject AS subject
    FROM ss_formtemplates f 
    INNER JOIN ss_cases c ON c.formtemplate_id = f.template_id 
    WHERE c.is_deleted = 0 AND f.is_deleted = 0 AND c.case_id IN (

	-- User ACL
	SELECT a.document_id 
 	FROM ss_acl a 
  	WHERE a.entity_id = ? AND a.entity_type = 1 
	
	UNION
 
 	-- Target groups ACL 
	SELECT a.document_id 
	FROM ss_acl a
	INNER JOIN ss_targetgroups t ON t.targetgroup_id = a.entity_id
	INNER JOIN ss_targetgroupusers tu ON t.targetgroup_id = tu.targetgroup_id
	WHERE t.is_deleted = 0 AND tu.user_id = ? AND a.entity_type = 2
	
	UNION
	
  	-- Company ACL 
 	SELECT a.document_id
 	FROM ss_acl a 
    INNER JOIN ss_companies com ON com.company_id = a.entity_id
    INNER JOIN ss_contacts co ON com.company_id = co.company_id
    WHERE co.user_id = ? AND com.is_deleted = 0 AND co.is_deleted = 0 
    	AND co.is_confirmed = 1 AND a.entity_type = 3
	
	UNION 
 	
 	-- Role ACL
	SELECT a.document_id
  	FROM ss_acl a
    INNER JOIN ss_userroles r ON r.role_id = a.entity_id
    INNER JOIN ss_userrolemap rm ON r.role_id = rm.role_id
    WHERE r.is_deleted = 0 AND rm.user_id = ? AND a.entity_type = 4

)  



UNION 

SELECT t.casetemplate_id AS template, t.subject AS subject
    FROM ss_casetemplates t 
    INNER JOIN ss_cases c ON c.casetemplate_id = t.casetemplate_id 
    WHERE c.is_deleted = 0 AND t.casetemplate_id != ? AND c.case_id IN (

	-- User ACL
	SELECT a.document_id 
 	FROM ss_acl a 
  	WHERE a.entity_id = ? AND a.entity_type = 1 
	
	UNION
 
 	-- Target groups ACL 
	SELECT a.document_id 
	FROM ss_acl a
	INNER JOIN ss_targetgroups t ON t.targetgroup_id = a.entity_id
	INNER JOIN ss_targetgroupusers tu ON t.targetgroup_id = tu.targetgroup_id
	WHERE t.is_deleted = 0 AND tu.user_id = ? AND a.entity_type = 2
	
	UNION
	
  	-- Company ACL 
 	SELECT a.document_id
 	FROM ss_acl a 
    INNER JOIN ss_companies com ON com.company_id = a.entity_id
    INNER JOIN ss_contacts co ON com.company_id = co.company_id
    WHERE co.user_id = ? AND com.is_deleted = 0 AND co.is_deleted = 0 
    	AND co.is_confirmed = 1 AND a.entity_type = 3
	
	UNION 
 	
 	-- Role ACL
	SELECT a.document_id
  	FROM ss_acl a
    INNER JOIN ss_userroles r ON r.role_id = a.entity_id
    INNER JOIN ss_userrolemap rm ON r.role_id = rm.role_id
    WHERE r.is_deleted = 0 AND rm.user_id = ? AND a.entity_type = 4

)  


ORDER BY subject