/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webquery;

import is.hugvit.bird.WebContext;
import java.util.SortedSet;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.IRemoteUserDirectory;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.DirectoryUser;
import net.gopro.selfservice.exceptions.FormQueryException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.json.JSONObject;

public class DirectoryUserQuery
implements IWebFormQuery {
    @Override
    public void setContext(WebContext context) {
    }

    @Override
    public void doAction(Element el, String action, JSONObject data) throws FormQueryException {
        block6: {
            try {
                if (action == null || !"lookup".equalsIgnoreCase(action)) break block6;
                if (data.has("ssn")) {
                    String ssn = data.getString("ssn");
                    if (ssn.length() == 10 && StringUtils.isNumeric((String)ssn)) {
                        IRemoteUserDirectory directory = EngineFactory.getCustomEngine(IRemoteUserDirectory.class);
                        SortedSet<DirectoryUser> users = directory.search(IRemoteUserDirectory.SearchType.SSN, (Object)ssn);
                        if (users.size() == 1) {
                            el.addElement("status").setText("success");
                            el.add(users.first().getXml());
                        } else {
                            el.addElement("status").setText("error");
                            el.addElement("message").setText("User was not found in directory.");
                        }
                        break block6;
                    }
                    throw new FormQueryException("The SSN is invalid");
                }
                throw new FormQueryException("No SSN was provided");
            }
            catch (SelfServiceException ex) {
                throw new FormQueryException(ex);
            }
        }
    }
}

