/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webquery;

import is.hugvit.bird.WebContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.AuditLog;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.filters.AuditLogFilter;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.util.ThreadContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.json.JSONException;
import org.json.JSONObject;

public class CaseHistoryQuery
implements IWebFormQuery {
    private ResourceBundle rb = LocaleUtil.getResourceBundle("admin.admin");

    @Override
    public void doAction(Element el, String action, JSONObject data) throws FormQueryException {
        try {
            String caseId = data.getString("case_id");
            if ("history".equals(action) && StringUtil.isValid(caseId)) {
                User currentUser = UserService.getUser(ThreadContext.getCurrentUser().getUserId());
                BaseCase bc = CaseService.getCase(caseId);
                if (bc != null) {
                    HashMap<String, BaseDocument> documentMap = new HashMap<String, BaseDocument>();
                    documentMap.put(bc.getId(), bc);
                    for (BaseDocument baseDocument : bc.getSubDocuments()) {
                        documentMap.put(baseDocument.getId(), baseDocument);
                    }
                    ArrayList<AuditLogEntry> entries = new ArrayList<AuditLogEntry>();
                    AuditLogFilter auditLogFilter = new AuditLogFilter();
                    auditLogFilter.setDocumentId(bc.getId());
                    if (bc instanceof FormCase && ((FormCase)bc).isShared()) {
                        el.addElement("shared").setText("true");
                    } else if (bc instanceof FormCase && !bc.isCompanyCase()) {
                        auditLogFilter.addUserId(currentUser.getId());
                        el.addElement("shared").setText("false");
                    } else {
                        el.addElement("shared").setText("true");
                    }
                    AuditLog al = LogService.getAuditLog(auditLogFilter);
                    entries.addAll(al.getEntries());
                    for (SubDocument doc : bc.getSubDocuments()) {
                        auditLogFilter.setDocumentId(doc.getId());
                        al = LogService.getAuditLog(auditLogFilter);
                        entries.addAll(al.getEntries());
                    }
                    Collections.sort(entries);
                    Collections.reverse(entries);
                    HashMap<String, User> userMap = new HashMap<String, User>();
                    userMap.put(currentUser.getId(), currentUser);
                    for (AuditLogEntry entry : entries) {
                        if (entry.getUserId() != null && "00000000000000000000000000000000".equals(entry.getUserId())) continue;
                        Element cel = this.createElement(entry, documentMap);
                        if (entry.getUserId() != null) {
                            Dom4JUtil.addElement(cel, "uid", entry.getUserId());
                            if (userMap.containsKey(entry.getUserId())) {
                                Dom4JUtil.addElement(cel, "user", ((User)userMap.get(entry.getUserId())).getFullname());
                            } else {
                                User u = UserService.getUser(entry.getUserId());
                                if (u != null) {
                                    userMap.put(u.getId(), u);
                                    Dom4JUtil.addElement(cel, "user", u.getFullname());
                                }
                            }
                        }
                        el.add(cel);
                    }
                    el.addElement("success").setText("true");
                }
            }
        }
        catch (JSONException ex) {
            throw new FormQueryException((Exception)((Object)ex));
        }
        catch (SelfServiceException ex) {
            throw new FormQueryException(ex);
        }
    }

    private Element createElement(AuditLogEntry entry, Map<String, BaseDocument> map) {
        String title = this.getDocumentTitle(entry.getDocumentId(), map);
        String type = this.getDocumentType(entry, map);
        Element el = DocumentHelper.createElement((String)"entry");
        Dom4JUtil.addElement(el, "title", title);
        Dom4JUtil.addElement(el, "type", type);
        Dom4JUtil.addElement(el, "action", this.rb.getString("ac." + entry.getAction().toString().toLowerCase()));
        Dom4JUtil.addElement(el, "stamp", LocaleUtil.formatDate(entry.getTimestamp()));
        return el;
    }

    private String getDocumentType(AuditLogEntry entry, Map<String, BaseDocument> map) {
        BaseDocument doc;
        if (entry.getDataType().equals((Object)AuditLogEntry.DataType.EXTERNAL_DOCUMENT) && (doc = map.get(entry.getDocumentId())) != null && doc instanceof ApplicationForm) {
            return this.rb.getString("dt.application");
        }
        return this.rb.getString("dt." + entry.getDataType().toString().toLowerCase());
    }

    private String getDocumentTitle(String documentId, Map<String, BaseDocument> map) {
        BaseDocument doc = map.get(documentId);
        if (doc != null) {
            if (doc instanceof BaseCase) {
                return ((BaseCase)doc).getSubject();
            }
            if (doc instanceof SubDocument) {
                return ((SubDocument)doc).getSubject();
            }
        }
        return "";
    }

    @Override
    public void setContext(WebContext context) {
    }
}

