/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webelement;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.WebContext;
import is.hugvit.net.HttpUtil;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.ICaptchaProvider;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.webelement.BaseElement;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class PublicPageController
extends BaseElement {
    private static Logger logger = Logger.getLogger(PublicPageController.class);
    protected static List<String> validParamsKeys = new ArrayList<String>();
    protected static boolean paramsEnabled = false;
    protected static String paramsStorage = "session";

    @Override
    public synchronized void init(WebContext context) throws BirdException {
        super.init(context);
        this.checkUserContext(context);
    }

    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        this.checkSessionContext(context);
        String pageName = this.getPageName(context);
        this.dataroot.addAttribute("page", pageName.replace("portal/", ""));
        this.setParamsContext(context);
        if ("register.html".equals(pageName)) {
            this.setRegisterConstants(context);
        }
        this.localizePage(context);
    }

    protected void localizePage(WebContext context) throws BirdException {
        try {
            if ("true".equalsIgnoreCase(SelfServiceEngine.getConfig("web.locale.user.option"))) {
                String localizedPageUrl;
                boolean isAlreadyLocalized = false;
                if (context.getAttribute("localized") != null) {
                    isAlreadyLocalized = (Boolean)context.getAttribute("localized");
                }
                if (!isAlreadyLocalized && (localizedPageUrl = this.getLocalizedRedirectUrl(context, false)) != null) {
                    context.setAttribute("localized", (Object)true);
                    context.setAttribute("basepage", (Object)context.getPageName());
                    context.getRequest().getRequestDispatcher(localizedPageUrl).forward((ServletRequest)context.getRequest(), (ServletResponse)context.getResponseExclusive());
                }
            }
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (ServletException ex) {
            throw new BirdException((Exception)((Object)ex));
        }
    }

    protected String getLocalizedRedirectUrl(WebContext context, boolean fullpath) throws BirdException {
        Locale defaultLocale = LocaleUtil.getLocale();
        String requestUrl = context.getRequest().getRequestURI();
        if (requestUrl.endsWith(".html")) {
            String requestLocale = (String)context.getRequest().getAttribute("lang");
            if (requestLocale == null) {
                requestLocale = HttpUtil.getCookieValue((HttpServletRequest)context.getRequest(), (String)"locale");
            }
            if (requestLocale != null) {
                String[] urlparts;
                boolean isSupportedLocale = LocaleUtil.isAvailableLocale(requestLocale);
                boolean isMatch = requestLocale.startsWith(defaultLocale.getLanguage() + "_");
                if (isSupportedLocale && !isMatch && (urlparts = requestUrl.split("/")).length > 1) {
                    String localizedPageKey;
                    String langKey = requestLocale.split("_")[0];
                    String pageKey = urlparts[urlparts.length - 1];
                    String lookupPageKey = localizedPageKey = pageKey.replace(".html", "." + langKey + ".html");
                    logger.debug((Object)("Check for localized page for: " + requestUrl + " in lang: " + requestLocale));
                    logger.debug((Object)("Looking for pageKey: " + lookupPageKey + " in lang: " + requestLocale));
                    BirdPage birdPage = SelfServiceEngine.getBirdSession().getDatabase().getPageByName(lookupPageKey);
                    if (birdPage != null) {
                        context.setAttribute("locale", (Object)requestLocale);
                        context.setAttribute("parentPage", (Object)context.getPageName());
                        context.getResponse().setHeader("Content-Language", requestLocale.replace("_", "-"));
                        logger.debug((Object)("Found localized page for pagekey: " + localizedPageKey));
                        if (fullpath) {
                            return context.getRequest().getContextPath() + "/web/" + localizedPageKey;
                        }
                        return localizedPageKey;
                    }
                }
            }
        }
        return null;
    }

    protected void setParamsContext(WebContext context) {
        Cookie[] cookies;
        if (paramsEnabled && paramsStorage.equalsIgnoreCase("session") && (cookies = context.getRequest().getCookies()) != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                String value;
                if (!validParamsKeys.contains(cookie.getName()) || !StringUtil.isValid(cookie.getValue()) || !StringUtil.isValid(value = cookie.getValue().replaceAll("[^a-zA-Z0-9_\\s]", "")) || value.length() > 10) continue;
                this.dataroot.addAttribute(cookie.getName(), value);
            }
        }
    }

    private void checkSessionContext(WebContext context) {
        HttpSession session = context.getRequest().getSession(false);
        if (session != null) {
            Enumeration en = session.getAttributeNames();
            while (en.hasMoreElements()) {
                String value;
                String key = (String)en.nextElement();
                if (!validParamsKeys.contains(key) || !StringUtil.isValid(value = (String)session.getAttribute(key))) continue;
                this.updateCookie(context, key, value);
            }
        }
    }

    private void updateCookie(WebContext context, String key, String value) {
        Cookie[] cookies = context.getRequest().getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie c : cookies) {
                if (!key.equals(c.getName())) continue;
                if (value.equals(c.getValue())) {
                    return;
                }
                c.setValue(value);
                c.setSecure(context.getRequest().isSecure());
                c.setMaxAge(2592000);
                c.setPath("/");
                c.setDomain("." + context.getRequest().getServerName());
                context.getResponse().addCookie(c);
                return;
            }
        }
        Cookie c = new Cookie(key, value);
        c.setSecure(context.getRequest().isSecure());
        c.setMaxAge(2592000);
        c.setPath("/");
        c.setDomain("." + context.getRequest().getServerName());
        context.getResponse().addCookie(c);
    }

    private void setRegisterConstants(WebContext context) throws BirdException {
        this.dataroot.addAttribute("enabled", SelfServiceEngine.getConfig("registration.enabled", "true"));
        this.dataroot.addAttribute("companies", SelfServiceEngine.getConfig("registration.enable.companies", "true"));
        this.dataroot.addAttribute("strict", SelfServiceEngine.getConfig("registration.sendpasswordtobank", "false"));
        this.dataroot.addAttribute("address", SelfServiceEngine.getConfig("registration.require.address", "true"));
        ICaptchaProvider captcha = this.getCaptchaProvider();
        if (captcha != null) {
            try {
                Element el = this.dataroot.addElement("captcha");
                captcha.setContext(context);
                captcha.setRequest(el);
            }
            catch (SelfServiceException ex) {
                throw new BirdException((Exception)ex);
            }
        }
        this.dataroot.addAttribute("captcha", String.valueOf(captcha != null));
    }

    private void checkUserContext(WebContext context) {
        Principal principal;
        boolean isOpenSection;
        boolean bl = isOpenSection = !context.getPageName().contains("portal");
        if (isOpenSection && (principal = context.getRequest().getUserPrincipal()) != null) {
            List<String> pagelist;
            boolean isCitizen = context.isUserInRole("citizen");
            boolean isAdminPrivileged = context.isUserInRole("administrator") || context.isUserInRole("editor") || context.isUserInRole("designer");
            this.dataroot.addAttribute("authenticated", "true");
            if (isAdminPrivileged && !isCitizen) {
                HttpSession session = context.getRequest().getSession();
                Object attribute = session.getAttribute("twofactor.pending");
                if (attribute != null && Boolean.TRUE.equals(attribute)) {
                    logger.debug((Object)"twofactor.pending found in session for admin, redirect cancelled.");
                } else {
                    logger.debug((Object)"Redirect admin user to admin panel!");
                    context.setRedirectPage("admin/bird_index.html");
                }
            } else if (isCitizen && (pagelist = Arrays.asList("index.html", "register.html")).contains(context.getPageName())) {
                context.setRedirectPage("portal/home.html");
            }
        }
    }

    private final ICaptchaProvider getCaptchaProvider() throws BirdException {
        try {
            String className = SelfServiceEngine.getConfig(ICaptchaProvider.class.getName());
            if (StringUtil.isValid(className)) {
                return EngineFactory.getCustomEngine(ICaptchaProvider.class);
            }
            return null;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected final String getPageName(WebContext context) {
        if (context.getAttribute("localized") != null && context.getAttribute("parentPage") != null) {
            return (String)context.getAttribute("parentPage");
        }
        return context.getPageName();
    }

    static {
        paramsEnabled = Boolean.valueOf(SelfServiceEngine.getConfig("params.enabled", "false"));
        paramsStorage = SelfServiceEngine.getConfig("params.storage", "session");
        if (SelfServiceEngine.getConfig("params.list") != null) {
            validParamsKeys = Arrays.asList(SelfServiceEngine.getConfig("params.list").split(","));
        }
    }
}

