/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import is.hugvit.bird.BirdException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WebSecurityUtil {
    private static final Logger logger = Logger.getLogger(WebSecurityUtil.class);

    public static void validateOrigin(HttpServletRequest request) throws BirdException {
        if (request.getMethod().equalsIgnoreCase("POST") || request.getMethod().equalsIgnoreCase("PUT") || request.getMethod().equalsIgnoreCase("DELETE")) {
            String xfHost = request.getHeader("X-Forwarded-Host") == null ? null : request.getHeader("X-Forwarded-Host").split(":")[0];
            String xfIP = request.getHeader("X-Forwarded-For") == null ? request.getRemoteAddr() : request.getHeader("X-Forwarded-For").split(":")[0];
            String realHost = request.getHeader("Host").split(":")[0];
            String host = StringUtils.isBlank((String)xfHost) ? realHost : xfHost;
            String origin = request.getHeader("Origin");
            String referer = request.getHeader("Referer");
            if (!StringUtils.isBlank((String)origin)) {
                if (!(origin.contains(host + "/") || origin.contains(host + ":") || origin.endsWith("//" + host))) {
                    logger.warn((Object)String.format("Origin header value '%s' does not contain host '%s' (%s). Call was made from: %s", origin, realHost, xfHost, xfIP));
                    throw new BirdException("Host check (a) failed!");
                }
            } else if (!StringUtils.isBlank((String)referer)) {
                if (!referer.contains("//" + host + "/") && !referer.contains("//" + host + ":")) {
                    logger.warn((Object)String.format("Referer header value '%s' does not contain host '%s' (%s). Call was made from: %s", referer, realHost, xfHost, xfIP));
                    throw new BirdException("Host check (b) failed!");
                }
            } else {
                logger.warn((Object)String.format("NO REFERER OR ORIGIN HEADERS: Cannot Compare: Hosts are %s (%s). Call was made from: %s", realHost, xfHost, xfIP));
                throw new BirdException("Host check (c) failed!");
            }
        }
    }
}

