/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.User;
import org.apache.commons.codec.binary.Hex;

public class PBKDF2PasswordUtil {
    private static final int iterations = 5555;
    private static final int keyLength = 512;
    private static final String pepper = "C0ldC0ff33#ndr01dHeineken";

    public static String hashPassword(String password) throws SelfServiceException {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), pepper.getBytes(), 5555, 512);
            SecretKey key = skf.generateSecret(spec);
            byte[] res = key.getEncoded();
            return Hex.encodeHexString((byte[])res);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SelfServiceException(ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static boolean isValid(String s) {
        return s.matches("[a-fA-F0-9]{128}");
    }

    public static boolean matchesPassword(String password, User user) throws SelfServiceException {
        if (password != null && user != null) {
            return user.getPassword().equals(PBKDF2PasswordUtil.hashPassword(password));
        }
        return false;
    }
}

