/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.IAccessControlled;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.DocumentSecurityException;

public class DocumentSecurityUtil {
    public static final void validatePermission(BaseDocument doc, User user, AccessControl.Permission permission) throws DocumentSecurityException, SelfServiceException {
        if (doc == null || user == null || permission == null) {
            throw new SelfServiceException("Invalid document, user or permission parameter.");
        }
        if (user.isInRole("A2AAC04696D89CBC6C56EF934F892410")) {
            return;
        }
        switch (permission) {
            case READ: {
                if (DocumentSecurityUtil.validateReadPermission(doc, user)) break;
                throw new DocumentSecurityException("Read access denied for user: " + user.getUsername() + " on document: " + doc.getId());
            }
            case WRITE: {
                if (DocumentSecurityUtil.validateWritePermission(doc, user)) break;
                throw new DocumentSecurityException("Write access denied for user: " + user.getUsername() + " on document: " + doc.getId());
            }
            default: {
                throw new SelfServiceException("Unsupported Permission type: " + permission.toString());
            }
        }
    }

    private static final boolean validateReadPermission(BaseDocument doc, User user) throws SelfServiceException {
        if (doc instanceof IAccessControlled) {
            return DocumentSecurityUtil.isInAccessControlList(((IAccessControlled)((Object)doc)).getAccessControlList(), user);
        }
        if (doc instanceof Message) {
            Message message = (Message)doc;
            if (user.getId().equals(message.getRecipientId())) {
                return true;
            }
        }
        return false;
    }

    private static final boolean validateWritePermission(BaseDocument doc, User user) {
        if (doc instanceof IAccessControlled) {
            return DocumentSecurityUtil.getDocumentPermission(AccessControl.Permission.WRITE, user, (IAccessControlled)((Object)doc));
        }
        if (doc instanceof User) {
            MetaData m;
            if (((User)doc).getId().equals(user.getId())) {
                return true;
            }
            return user.isInRole("00DD3C9F86ABC8D80000012B10B69DA1") && (m = doc.getMetaDataByKey("AccountManagerId")) != null && user.getId().equals(m.getValue());
        }
        return false;
    }

    private static final boolean validateDeletePermission(IAccessControlled doc, User user) {
        if (doc instanceof SubDocument) {
            SubDocument sub = (SubDocument)doc;
            if (sub instanceof ApplicationForm || sub instanceof CompletedFormDocument) {
                return false;
            }
            if (!sub.isSent() && sub.getCreatedById().equals(user.getId())) {
                return true;
            }
        }
        return false;
    }

    private static final boolean validateSubDocumentPermission(SubDocument doc, BaseCase parentCase, User user) throws SelfServiceException {
        return true;
    }

    private static boolean isInAccessControlList(List<AccessControl> list, User user) {
        for (AccessControl acl : list) {
            if (AccessControl.AccessControlType.USER.equals((Object)acl.getEntityType()) && acl.getEntityId().equals(user.getId())) {
                return true;
            }
            if (!(AccessControl.AccessControlType.GROUP.equals((Object)acl.getEntityType()) ? user.isInTargetGroup(acl.getEntityId()) : (AccessControl.AccessControlType.COMPANY.equals((Object)acl.getEntityType()) ? user.isContactForCompany(acl.getEntityId()) : AccessControl.AccessControlType.ROLE.equals((Object)acl.getEntityType()) && user.isInRole(acl.getEntityId())))) continue;
            return true;
        }
        return false;
    }

    public static final boolean getDocumentPermission(AccessControl.Permission permission, User user, IAccessControlled document) {
        if (user == null) {
            return false;
        }
        if (AccessControl.Permission.WRITE.equals((Object)permission) && user.isReadOnlyRestricted()) {
            return false;
        }
        int currentAclLevel = AccessControl.Permission.NONE.getValue();
        for (AccessControl acl : document.getAccessControlList()) {
            if (AccessControl.AccessControlType.USER.equals((Object)acl.getEntityType())) {
                if (!user.getId().equals(acl.getEntityId()) || acl.getBitmask() <= currentAclLevel) continue;
                currentAclLevel = acl.getBitmask();
                continue;
            }
            if (AccessControl.AccessControlType.COMPANY.equals((Object)acl.getEntityType())) {
                if (!user.isContactForCompany(acl.getEntityId()) || acl.getBitmask() <= currentAclLevel) continue;
                currentAclLevel = acl.getBitmask();
                continue;
            }
            if (AccessControl.AccessControlType.GROUP.equals((Object)acl.getEntityType())) {
                if (!user.isInTargetGroup(acl.getEntityId()) || acl.getBitmask() <= currentAclLevel) continue;
                currentAclLevel = acl.getBitmask();
                continue;
            }
            if (!AccessControl.AccessControlType.ROLE.equals((Object)acl.getEntityType()) || !user.isInRole(acl.getEntityId()) || acl.getBitmask() <= currentAclLevel) continue;
            currentAclLevel = acl.getBitmask();
        }
        return currentAclLevel >= permission.getValue();
    }
}

